/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.DBG;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.Res2Constr;
import edu.psu.cse.siis.coal.arguments.switchLC;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

class RecursiveDAGSolverVisitorLC
implements switchLC {
    boolean fieldMode = false;
    static int g_uid = 0;
    int uid = g_uid++;
    int warnings = 0;
    Set<Object> result;
    int inline_depth = 0;
    Set<LanguageConstraints> seen = new HashSet<LanguageConstraints>();
    LanguageConstraints.Box[] parameters;
    MethodReturnValueAnalysisInterface methodReturnValueAnalysisInterface;

    RecursiveDAGSolverVisitorLC(int inline_depth0, LanguageConstraints.Box[] actual_arguments, MethodReturnValueAnalysisInterface mrvai) {
        this.result = new HashSet<Object>();
        this.parameters = actual_arguments;
        this.inline_depth = inline_depth0;
        this.methodReturnValueAnalysisInterface = mrvai;
    }

    RecursiveDAGSolverVisitorLC(int inline_depth0, MethodReturnValueAnalysisInterface mrvai) {
        this(inline_depth0, null, mrvai);
    }

    RecursiveDAGSolverVisitorLC(int inline_depth0) {
        this(inline_depth0, null, new MethodReturnValueAnalysisInterface(){

            @Override
            public Set<Object> getMethodReturnValues(LanguageConstraints.Call call) {
                return null;
            }
        });
    }

    RecursiveDAGSolverVisitorLC() {
        this(0);
    }

    boolean solve(LanguageConstraints.Box lcb) {
        if (lcb == null) {
            return false;
        }
        lcb.apply(this);
        return true;
    }

    @Override
    public boolean setFieldMode(boolean mode) {
        boolean old_fieldMode = this.fieldMode;
        this.fieldMode = mode;
        return old_fieldMode;
    }

    @Override
    public void caseTop(LanguageConstraints.Top lc) {
        ++this.warnings;
    }

    @Override
    public void caseBottom(LanguageConstraints.Bottom lc) {
        this.result.add("(.*)");
    }

    @Override
    public void caseTerminal(LanguageConstraints.Terminal lc) {
        this.result.add(lc.term);
    }

    @Override
    public void caseParameter(LanguageConstraints.Parameter lc) {
        if (!this.fieldMode && this.parameters != null) {
            if (this.parameters[lc.paramNum] != null) {
                this.parameters[lc.paramNum].apply(this);
            } else {
                this.result.add("(.*)");
            }
        } else {
            LanguageConstraints.Box lcb = Res2Constr.getArgument(lc.sm, lc.paramNum);
            lcb.apply(this);
        }
    }

    @Override
    public void caseUnion(LanguageConstraints.Union lc) {
        if (this.seen.contains(lc)) {
            this.result.add("(.*)");
            return;
        }
        this.seen.add(lc);
        for (LanguageConstraints.Box lcb : lc.elements) {
            lcb.apply(this);
        }
        assert (this.seen.contains(lc));
        this.seen.remove(lc);
    }

    @Override
    public void caseConcatenate(LanguageConstraints.Concatenate lc) {
        if (this.seen.contains(lc)) {
            this.result.add("(.*)");
            return;
        }
        this.seen.add(lc);
        Set<Object> old_result = this.result;
        HashSet<Object> left_result = new HashSet<Object>();
        this.result = left_result;
        lc.left.apply(this);
        HashSet<Object> right_result = new HashSet<Object>();
        this.result = right_result;
        lc.right.apply(this);
        this.result = old_result;
        for (Object e : left_result) {
            for (Object e2 : right_result) {
                if (e instanceof String && e2 instanceof String) {
                    this.result.add(String.valueOf((String)e) + (String)e2);
                    continue;
                }
                this.result.add("(.*)");
            }
        }
        assert (this.seen.contains(lc));
        this.seen.remove(lc);
    }

    @Override
    public void caseEq(LanguageConstraints.Eq lc) {
        if (this.seen.contains(lc)) {
            this.result.add("(.*)");
            return;
        }
        this.seen.add(lc);
        lc.lcb.apply(this);
        assert (this.seen.contains(lc));
        this.seen.remove(lc);
    }

    @Override
    public void casePending(LanguageConstraints.Pending lc) {
        throw new RuntimeException("BAD PENDING!");
    }

    @Override
    public void caseCall(LanguageConstraints.Call lc) {
        assert (this.inline_depth >= 0);
        if (this.inline_depth == 0) {
            this.result.add("(.*)");
        } else {
            Set<Object> methodReturnValues = this.methodReturnValueAnalysisInterface.getMethodReturnValues(lc);
            if (methodReturnValues == null) {
                DBG.BUG("While recursing, parameters in this context look the same as the parameters in the callee context. That is a LanguageConstraints.Parameter passed via lc.arguments is really a parameter of this(caller) function, but it will be mistakenly interpreted as a parameter of the callee");
                RecursiveDAGSolverVisitorLC solveCall = new RecursiveDAGSolverVisitorLC(this.inline_depth - 1, lc.arguments, this.methodReturnValueAnalysisInterface);
                CallGraph cg = Scene.v().getCallGraph();
                boolean seen_any_HACK = false;
                Iterator<Edge> ite = cg.edgesOutOf(lc.stmt);
                while (ite.hasNext()) {
                    Edge e = ite.next();
                    SootMethod callee = e.tgt();
                    if (callee.getSignature().endsWith(": void <clinit>()>")) continue;
                    seen_any_HACK = true;
                    if (Res2Constr.knownReturn(callee)) {
                        LanguageConstraints.Box lcb_callee_return = Res2Constr.getReturn(callee);
                        lcb_callee_return.apply(solveCall);
                        assert (!solveCall.result.isEmpty());
                        this.result.addAll(solveCall.result);
                        continue;
                    }
                    this.result.add("(.*)");
                }
                if (!seen_any_HACK) {
                    this.result.add("(.*)");
                }
            } else {
                this.result.addAll(methodReturnValues);
            }
        }
    }

    public static interface MethodReturnValueAnalysisInterface {
        public Set<Object> getMethodReturnValues(LanguageConstraints.Call var1);
    }
}

