/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.FieldRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;

class Res2Constr {
    private static Map<Stmt, LanguageConstraints.Box> stmt2constr = new HashMap<Stmt, LanguageConstraints.Box>();
    private static Set<Stmt> processed = new HashSet<Stmt>();
    private static Map<String, LanguageConstraints.Box> field2constr = new HashMap<String, LanguageConstraints.Box>();
    private static Map<SootMethod, LanguageConstraints.Box> ret2constr = new HashMap<SootMethod, LanguageConstraints.Box>();
    private static Map<String, LanguageConstraints.Box> argument2constr = new HashMap<String, LanguageConstraints.Box>();

    Res2Constr() {
    }

    static LanguageConstraints.Box getStmt(Stmt s) {
        LanguageConstraints.Box lcb = stmt2constr.get(s);
        if (lcb == null) {
            lcb = new LanguageConstraints.Box();
            stmt2constr.put(s, lcb);
            assert (stmt2constr.get(s) == lcb);
        }
        assert (lcb != null);
        return lcb;
    }

    private static void putInBox(LanguageConstraints.Box lcb, LanguageConstraints.Box new_lcb) {
        LanguageConstraints lc = lcb.getLC();
        if (lc == null || lc instanceof LanguageConstraints.Top) {
            lcb.setLC(new LanguageConstraints.Eq(new_lcb));
        } else if (lc instanceof LanguageConstraints.Union) {
            ((LanguageConstraints.Union)lc).addLCB(new_lcb);
        } else {
            LanguageConstraints.Union lcu = new LanguageConstraints.Union();
            lcu.addLCB(new LanguageConstraints.Box(lc));
            lcu.addLCB(new_lcb);
            lcb.setLC(lcu);
        }
    }

    static void putStmt(Stmt s, LanguageConstraints.Box new_lcb) {
        LanguageConstraints.Box lcb = Res2Constr.getStmt(s);
        Res2Constr.putInBox(lcb, new_lcb);
    }

    static void putStmtBottom(Stmt s) {
        LanguageConstraints.Box lcb = Res2Constr.getStmt(s);
        lcb.setLC(LanguageConstraints.Bottom.v());
    }

    static boolean checkAndSetProcessedStmt(Stmt s) {
        boolean res = processed.contains(s);
        processed.add(s);
        return res;
    }

    static Map<String, LanguageConstraints.Box> get_field2constr() {
        return field2constr;
    }

    static LanguageConstraints.Box getField(FieldRef fr) {
        String key = fr.getField().toString();
        LanguageConstraints.Box lcb = field2constr.get(key);
        if (lcb == null) {
            lcb = new LanguageConstraints.FieldBox();
            field2constr.put(key, lcb);
            assert (field2constr.get(key) == lcb);
        }
        assert (lcb != null);
        return lcb;
    }

    static void putField(FieldRef fr, LanguageConstraints.Box new_lcb) {
        LanguageConstraints.Box lcb = Res2Constr.getField(fr);
        Res2Constr.putInBox(lcb, new_lcb);
    }

    static boolean knownReturn(SootMethod method) {
        return ret2constr.containsKey(method);
    }

    static LanguageConstraints.Box getReturn(SootMethod method) {
        SootMethod key = method;
        LanguageConstraints.Box lcb = ret2constr.get(key);
        if (lcb == null) {
            lcb = new LanguageConstraints.Box();
            ret2constr.put(key, lcb);
            assert (ret2constr.get(key) == lcb);
        }
        assert (lcb != null);
        return lcb;
    }

    static void putReturn(SootMethod sm, ReturnStmt rstmt, LanguageConstraints.Box new_lcb) {
        LanguageConstraints.Box lcb = Res2Constr.getReturn(sm);
        Res2Constr.putInBox(lcb, new_lcb);
    }

    static LanguageConstraints.Box getArgument(SootMethod sm, int arg) {
        String key = String.valueOf(sm.getSignature()) + "#" + arg;
        LanguageConstraints.Box lcb = argument2constr.get(key);
        if (lcb == null) {
            lcb = new LanguageConstraints.Box();
            argument2constr.put(key, lcb);
            assert (argument2constr.get(key) == lcb);
        }
        assert (lcb != null);
        return lcb;
    }

    static void putArgument(SootMethod sm, int arg, LanguageConstraints.Box new_lcb) {
        LanguageConstraints.Box lcb = Res2Constr.getArgument(sm, arg);
        Res2Constr.putInBox(lcb, new_lcb);
    }

    static void putCallArguments(SootMethod sm_context, Stmt stmt, LanguageConstraints.Box[] arguments) {
        SootMethod callee = stmt.getInvokeExpr().getMethod();
        int i = 0;
        while (i < arguments.length) {
            LanguageConstraints.Box lcb = arguments[i];
            if (lcb != null) {
                Res2Constr.putArgument(callee, i, lcb);
            }
            ++i;
        }
    }
}

