/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.arguments.ArgumentValueAnalysis;
import edu.psu.cse.siis.coal.arguments.ConstraintCollector;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.MethodReturnValueManager;
import edu.psu.cse.siis.coal.arguments.RecursiveDAGSolverVisitorLC;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.Value;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.toolkits.graph.ExceptionalUnitGraph;

public class StringValueAnalysis
extends ArgumentValueAnalysis {
    private static final String TOP_VALUE = "(.*)";

    public static void initialize() {
        ConstraintCollector.globalCollection(new ConstraintCollector.CCModelInterface(){

            @Override
            public boolean isExcludedClass(String class_name) {
                return false;
            }
        });
    }

    @Override
    public Set<Object> computeInlineArgumentValues(String[] inlineValues) {
        return new HashSet<Object>(Arrays.asList(inlineValues));
    }

    @Override
    public Set<Object> computeVariableValues(Value value, Stmt stmt) {
        if (value instanceof StringConstant) {
            return Collections.singleton(((StringConstant)value).value.intern());
        }
        if (value instanceof NullConstant) {
            return Collections.singleton("<NULL>");
        }
        if (value instanceof Local) {
            Local local = (Local)value;
            RecursiveDAGSolverVisitorLC dagvlc = new RecursiveDAGSolverVisitorLC(5, null, new RecursiveDAGSolverVisitorLC.MethodReturnValueAnalysisInterface(){

                @Override
                public Set<Object> getMethodReturnValues(LanguageConstraints.Call call) {
                    return MethodReturnValueManager.v().getMethodReturnValues(call);
                }
            });
            ConstraintCollector constraintCollector = new ConstraintCollector(new ExceptionalUnitGraph(AnalysisParameters.v().getIcfg().getMethodOf(stmt).getActiveBody()));
            LanguageConstraints.Box lcb = constraintCollector.getConstraintOfAt(local, stmt);
            if (dagvlc.solve(lcb)) {
                return new HashSet<Object>(dagvlc.result);
            }
            return Collections.singleton(TOP_VALUE);
        }
        return Collections.singleton(TOP_VALUE);
    }

    @Override
    public Object getTopValue() {
        return TOP_VALUE;
    }
}

