/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.switchLC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ToStringVisitor
implements switchLC {
    boolean recursive = false;
    Set<LanguageConstraints> seen;
    StringBuilder result;
    static boolean show_uid = false;

    ToStringVisitor() {
        this.seen = new HashSet<LanguageConstraints>();
        this.result = new StringBuilder();
    }

    ToStringVisitor(Set<LanguageConstraints> seen0) {
        this.seen = seen0;
        this.result = new StringBuilder();
    }

    String uid(LanguageConstraints lc) {
        if (show_uid) {
            return "#" + lc.uid + ":";
        }
        return "";
    }

    @Override
    public boolean setFieldMode(boolean mode) {
        return false;
    }

    @Override
    public void caseTop(LanguageConstraints.Top lc) {
        this.result.append(String.valueOf(this.uid(lc)) + "<Top>");
    }

    @Override
    public void caseBottom(LanguageConstraints.Bottom lc) {
        this.result.append(String.valueOf(this.uid(lc)) + "(.*)");
    }

    @Override
    public void caseTerminal(LanguageConstraints.Terminal lc) {
        this.result.append(String.valueOf(this.uid(lc)) + "term(" + lc.term + ")");
    }

    @Override
    public void caseParameter(LanguageConstraints.Parameter lc) {
        this.result.append(String.valueOf(this.uid(lc)) + "param#" + lc.sm + "#" + lc.paramNum);
    }

    @Override
    public void caseUnion(LanguageConstraints.Union lc) {
        if (this.seen.contains(lc)) {
            this.recursive = true;
            this.result.append(String.valueOf(this.uid(lc)) + "{...}");
            return;
        }
        this.seen.add(lc);
        ArrayList<String> list = new ArrayList<String>();
        for (LanguageConstraints.Box lcb : lc.elements) {
            list.add(lcb.toString(this.seen));
        }
        Collections.sort(list);
        this.result.append(String.valueOf(this.uid(lc)) + "union(");
        Iterator lit = list.iterator();
        while (lit.hasNext()) {
            String lstr = (String)lit.next();
            this.result.append(lstr);
            if (!lit.hasNext()) continue;
            this.result.append(" | ");
        }
        this.result.append(")");
        assert (this.seen.contains(lc));
        this.seen.remove(lc);
    }

    @Override
    public void caseConcatenate(LanguageConstraints.Concatenate lc) {
        if (this.seen.contains(lc)) {
            this.recursive = true;
            this.result.append(String.valueOf(this.uid(lc)) + "{...}");
            return;
        }
        this.seen.add(lc);
        this.result.append(String.valueOf(this.uid(lc)) + "cat((" + lc.left.toString(this.seen) + ")(" + lc.right.toString(this.seen) + "))");
        assert (this.seen.contains(lc));
        this.seen.remove(lc);
    }

    @Override
    public void caseEq(LanguageConstraints.Eq lc) {
        if (this.seen.contains(lc)) {
            this.recursive = true;
            this.result.append(String.valueOf(this.uid(lc)) + "{...}");
            return;
        }
        this.seen.add(lc);
        this.result.append(String.valueOf(this.uid(lc)) + lc.lcb.toString(this.seen));
        assert (this.seen.contains(lc));
        this.seen.remove(lc);
    }

    @Override
    public void casePending(LanguageConstraints.Pending lc) {
        this.result.append(String.valueOf(this.uid(lc)) + "<PENDING??!>");
    }

    @Override
    public void caseCall(LanguageConstraints.Call lc) {
        if (this.seen.contains(lc)) {
            this.recursive = true;
            this.result.append(String.valueOf(this.uid(lc)) + "{...}");
            return;
        }
        this.seen.add(lc);
        this.result.append(String.valueOf(this.uid(lc)) + "[call]" + lc.callee().getName() + "(");
        int i = 0;
        while (i < lc.arguments.length) {
            String str_arg;
            String string = str_arg = lc.arguments[i] == null ? "null" : lc.arguments[i].toString(this.seen);
            if (i < lc.arguments.length - 1) {
                str_arg = String.valueOf(str_arg) + ",";
            }
            this.result.append(String.valueOf(this.uid(lc)) + str_arg);
            ++i;
        }
        this.result.append(")");
        assert (this.seen.contains(lc));
        this.seen.remove(lc);
    }
}

