/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.field;

import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.IdentityFieldTransformer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Value;
import soot.jimple.Stmt;

public class SequenceElement {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Value symbol;
    private final Stmt stmt;
    private final String op;
    private FieldTransformer fieldTransformer;

    public SequenceElement(Value symbol2, Stmt stmt, String op) {
        this.symbol = symbol2;
        this.stmt = stmt;
        this.op = op;
        this.fieldTransformer = IdentityFieldTransformer.v();
    }

    public void composeWith(FieldTransformer newFieldTransformer) {
        this.fieldTransformer = this.fieldTransformer.compose(newFieldTransformer);
    }

    public Set<FieldTransformer> makeFinalTransformers(String field, PropagationSolver solver) {
        HashSet<FieldTransformer> result = new HashSet<FieldTransformer>();
        for (FieldTransformer currentFieldTransformer : this.makeTransformersFromReferencedValue(field, solver)) {
            if (currentFieldTransformer != null) {
                result.add(currentFieldTransformer.compose(this.fieldTransformer));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private Set<FieldTransformer> makeTransformersFromReferencedValue(String field, PropagationSolver solver) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Making transformer from element " + this.toString());
        }
        throw new RuntimeException("Not implemented in this version.");
    }

    public String toString() {
        return "symbol " + this.symbol + ", stmt " + this.stmt + ", op " + this.op + ", field transformer " + this.fieldTransformer;
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.stmt, this.op, this.fieldTransformer);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SequenceElement)) {
            return false;
        }
        SequenceElement secondSequenceElement = (SequenceElement)other;
        return Objects.equals(this.symbol, secondSequenceElement.symbol) && Objects.equals(this.stmt, secondSequenceElement.stmt) && Objects.equals(this.op, secondSequenceElement.op) && Objects.equals(this.fieldTransformer, secondSequenceElement.fieldTransformer);
    }
}

