/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.field;

import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.field.SequenceElement;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.IdentityFieldTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Value;
import soot.jimple.Stmt;

public class TransformerSequence {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<SequenceElement> transformerSequence = null;

    public TransformerSequence() {
    }

    public TransformerSequence(TransformerSequence otherTransformerSequence) {
        this.transformerSequence = new ArrayList<SequenceElement>(otherTransformerSequence.transformerSequence);
    }

    public TransformerSequence(List<SequenceElement> otherTransformerSequence) {
        this.transformerSequence = new ArrayList<SequenceElement>(otherTransformerSequence);
    }

    public void addTransformerToSequence(FieldTransformer newFieldTransformer) {
        this.transformerSequence.get(this.transformerSequence.size() - 1).composeWith(newFieldTransformer);
    }

    public void addElementsToSequence(TransformerSequence transformerSequence) {
        if (this.transformerSequence == null) {
            this.transformerSequence = new ArrayList<SequenceElement>();
        }
        this.transformerSequence.addAll(transformerSequence.transformerSequence);
    }

    public void addElementToSequence(Value symbol2, Stmt stmt, String op) {
        if (this.transformerSequence == null) {
            this.transformerSequence = new ArrayList<SequenceElement>();
        }
        this.transformerSequence.add(new SequenceElement(symbol2, stmt, op));
    }

    public Set<FieldTransformer> makeFinalFieldTransformers(String field, PropagationSolver solver) {
        Set<FieldTransformer> result = Collections.singleton(IdentityFieldTransformer.v());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Making final field transformers for " + this);
        }
        for (SequenceElement sequenceElement : this.transformerSequence) {
            result = this.composeFieldTransformerSets(result, sequenceElement.makeFinalTransformers(field, solver));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Returning " + result);
        }
        return result;
    }

    private Set<FieldTransformer> composeFieldTransformerSets(Set<FieldTransformer> fieldTransformers1, Set<FieldTransformer> fieldTransformers2) {
        HashSet<FieldTransformer> result = new HashSet<FieldTransformer>();
        for (FieldTransformer fieldTransformer1 : fieldTransformers1) {
            for (FieldTransformer fieldTransformer2 : fieldTransformers2) {
                if (fieldTransformer1 != null && fieldTransformer2 != null) {
                    result.add(fieldTransformer1.compose(fieldTransformer2));
                    continue;
                }
                result.add(null);
            }
        }
        return result;
    }

    public String toString() {
        return this.transformerSequence.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.transformerSequence);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TransformerSequence)) {
            return false;
        }
        TransformerSequence secondTransformerSequence = (TransformerSequence)other;
        return Objects.equals(this.transformerSequence, secondTransformerSequence.transformerSequence);
    }
}

