/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.field.transformers;

import edu.psu.cse.siis.coal.field.transformers.FieldNullTransformerFactory;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformerFactory;
import edu.psu.cse.siis.coal.field.transformers.scalar.FieldScalarReplaceTransformerFactory;
import edu.psu.cse.siis.coal.field.transformers.set.FieldAddSequenceElementTransformerFactory;
import edu.psu.cse.siis.coal.field.transformers.set.FieldAddTransformerFactory;
import edu.psu.cse.siis.coal.field.transformers.set.FieldClearTransformerFactory;
import edu.psu.cse.siis.coal.field.transformers.set.FieldRemoveTransformerFactory;
import edu.psu.cse.siis.coal.field.transformers.set.FieldReplaceTransformerFactory;
import java.util.HashMap;
import java.util.Map;
import soot.Value;
import soot.jimple.Stmt;

public class FieldTransformerManager {
    private static FieldTransformerManager instance = new FieldTransformerManager();
    private final Map<String, FieldTransformerFactory> fieldTransformerFactoryMap = new HashMap<String, FieldTransformerFactory>();

    private FieldTransformerManager() {
    }

    public static FieldTransformerManager v() {
        return instance;
    }

    public void registerFieldTransformerFactory(String action, FieldTransformerFactory fieldTransformerFactory) {
        this.fieldTransformerFactoryMap.put(action, fieldTransformerFactory);
    }

    public void registerDefaultFieldTransformerFactories() {
        this.registerFieldTransformerFactory("add", new FieldAddTransformerFactory());
        this.registerFieldTransformerFactory("addAll", new FieldAddTransformerFactory());
        this.registerFieldTransformerFactory("remove", new FieldRemoveTransformerFactory());
        this.registerFieldTransformerFactory("clear", new FieldClearTransformerFactory());
        this.registerFieldTransformerFactory("replaceAll", new FieldReplaceTransformerFactory());
        this.registerFieldTransformerFactory("compose", new FieldAddSequenceElementTransformerFactory());
        this.registerFieldTransformerFactory("null", new FieldNullTransformerFactory());
        this.registerFieldTransformerFactory("replace", new FieldScalarReplaceTransformerFactory());
    }

    public FieldTransformer makeFieldTransformer(String action, Object value) {
        FieldTransformerFactory factory = this.fieldTransformerFactoryMap.get(action);
        if (factory == null) {
            throw new RuntimeException("No factory for action " + action);
        }
        return factory.makeFieldTransformer(value).intern();
    }

    public FieldTransformer makeFieldTransformer(String action, Value symbol2, Stmt stmt, String op) {
        FieldTransformerFactory factory = this.fieldTransformerFactoryMap.get(action);
        if (factory == null) {
            throw new RuntimeException("No factory for action " + action);
        }
        return factory.makeFieldTransformer(symbol2, stmt, op).intern();
    }
}

