/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.field.transformers.set;

import edu.psu.cse.siis.coal.field.TransformerSequence;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.IdentityFieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.NullFieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.TopFieldTransformer;
import edu.psu.cse.siis.coal.field.values.FieldValue;
import edu.psu.cse.siis.coal.field.values.SetFieldValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SetFieldTransformer
extends FieldTransformer {
    protected Set<Object> add;
    protected Set<Object> remove;
    protected boolean clear;
    protected TransformerSequence transformerSequence;

    @Override
    public FieldValue apply(FieldValue fieldValue) {
        SetFieldValue result = new SetFieldValue();
        assert (this.transformerSequence == null && (!fieldValue.hasTransformerSequence() || this.clear));
        if (!this.clear) {
            result.addAll((Set)fieldValue.getValue());
        }
        if (this.remove != null) {
            result.removeAll(this.remove);
        }
        if (this.add != null) {
            result.addAll(this.add);
        }
        return result.intern();
    }

    @Override
    public FieldTransformer compose(FieldTransformer secondFieldOperation) {
        if (secondFieldOperation == NullFieldTransformer.v() || secondFieldOperation == IdentityFieldTransformer.v() || secondFieldOperation == TopFieldTransformer.v()) {
            return secondFieldOperation;
        }
        assert (secondFieldOperation instanceof SetFieldTransformer);
        SetFieldTransformer secondFieldTransformer = (SetFieldTransformer)secondFieldOperation;
        if (secondFieldTransformer.clear) {
            return secondFieldOperation;
        }
        SetFieldTransformer result = new SetFieldTransformer();
        result.clear = this.clear;
        if (this.add != null) {
            result.add = new HashSet<Object>(this.add);
        }
        if (this.remove != null) {
            result.remove = new HashSet<Object>(this.remove);
        }
        if (this.transformerSequence != null) {
            result.transformerSequence = new TransformerSequence(this.transformerSequence);
            if (secondFieldTransformer.add != null || secondFieldTransformer.remove != null) {
                FieldTransformer intermediateFieldTransformer = secondFieldTransformer.makeNonComposedFieldTransformer();
                result.transformerSequence.addTransformerToSequence(intermediateFieldTransformer);
            }
        } else {
            if (secondFieldTransformer.add != null) {
                if (result.remove != null) {
                    result.remove.removeAll(secondFieldTransformer.add);
                }
                if (result.add == null) {
                    result.add = new HashSet<Object>(secondFieldTransformer.add);
                } else {
                    result.add.addAll(secondFieldTransformer.add);
                }
            }
            if (secondFieldTransformer.remove != null) {
                if (result.add != null) {
                    result.add.removeAll(secondFieldTransformer.remove);
                }
                if (result.remove == null) {
                    result.remove = new HashSet<Object>(secondFieldTransformer.remove);
                } else {
                    result.remove.addAll(secondFieldTransformer.remove);
                }
            }
        }
        if (secondFieldTransformer.transformerSequence != null) {
            if (result.transformerSequence == null) {
                result.transformerSequence = new TransformerSequence();
            }
            result.transformerSequence.addElementsToSequence(secondFieldTransformer.transformerSequence);
        }
        return result.intern();
    }

    public FieldTransformer makeNonComposedFieldTransformer() {
        SetFieldTransformer intermediateFieldTransformer = new SetFieldTransformer();
        intermediateFieldTransformer.add = this.add;
        intermediateFieldTransformer.remove = this.remove;
        return intermediateFieldTransformer.intern();
    }

    public String toString() {
        return "Add " + this.add + ", remove " + this.remove + ", clear " + this.clear + ", transformer sequence " + this.transformerSequence;
    }

    public int hashCode() {
        return Objects.hash(this.clear, this.add, this.remove, this.transformerSequence);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SetFieldTransformer)) {
            return false;
        }
        SetFieldTransformer secondFieldTransformer = (SetFieldTransformer)other;
        return Objects.equals(this.add, secondFieldTransformer.add) && Objects.equals(this.remove, secondFieldTransformer.remove) && this.clear == secondFieldTransformer.clear && Objects.equals(this.transformerSequence, secondFieldTransformer.transformerSequence);
    }
}

