/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.lang;

import edu.psu.cse.siis.coal.ExtendedSignature;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.arguments.Field;
import edu.psu.cse.siis.coal.lang.ParseException;
import edu.psu.cse.siis.coal.lang.PropagationParserConstants;
import edu.psu.cse.siis.coal.lang.PropagationParserTokenManager;
import edu.psu.cse.siis.coal.lang.SimpleCharStream;
import edu.psu.cse.siis.coal.lang.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagationParser
implements PropagationParserConstants {
    private static Logger logger = LoggerFactory.getLogger(PropagationParser.class);
    private Model model;
    private Map<String, Argument> namedArguments;
    private Map<String, String> namedSuperclasses;
    private Map<String, Field> fields;
    public PropagationParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[31];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void addModeledType(String type) {
        this.model.addModeledType(type);
    }

    private void addModifier(ExtendedSignature extendedSignature, Argument[] arguments, String modifierModifier) {
        this.model.addModifier(extendedSignature, arguments, modifierModifier);
    }

    private void addCopyConstructor(String signature, Argument[] arguments) {
        this.model.addCopyConstructor(signature, arguments);
    }

    private void addQuery(ExtendedSignature extendedSignature, Argument[] arguments) {
        this.model.addQuery(extendedSignature, arguments);
    }

    private void addNamedSuperclass(String name, String superclass) {
        this.namedSuperclasses.put(name, superclass);
    }

    private void addExcludedClass(String name) {
        this.model.addExcludedClass(name);
    }

    private void addSource(ExtendedSignature extendedSignature, Argument[] arguments) {
        this.model.addSource(extendedSignature, arguments);
    }

    private void addConstant(String signature, Argument[] arguments) {
        this.model.addConstant(signature, arguments);
    }

    private void addField(String name, String type, int count, int line) throws ParseException {
        if (this.fields.containsKey(name)) {
            throw new ParseException("Previously declared field " + name + " at line " + line);
        }
        this.fields.put(name, new Field(name, type));
    }

    private Field getField(String fieldName, int line) throws ParseException {
        Field field = this.fields.get(fieldName);
        if (field == null) {
            throw new ParseException("Unknown field " + fieldName + " at line " + line);
        }
        return field;
    }

    private String getNamedSuperclass(String name) throws ParseException {
        String superclass = this.namedSuperclasses.get(name);
        if (superclass == null) {
            throw new ParseException("Undeclared superclass: " + name);
        }
        return superclass;
    }

    public static void parseModelFromDirectory(Model model, String dir) throws FileNotFoundException, ParseException {
        logger.info("Parsing model from directory " + dir);
        ArrayList<File> files = new ArrayList<File>();
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(dir, new String[0]), "*.model");
            for (Path file : stream) {
                files.add(file.toFile());
            }
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not list model files in directory " + dir);
        }
        for (File file : files) {
            PropagationParser.parseModelFromFile(model, file);
        }
    }

    public static void parseModelFromFile(Model model, File file) throws FileNotFoundException, ParseException {
        logger.info("Parsing model from file " + file);
        PropagationParser parser2 = new PropagationParser(model, new FileInputStream(file));
        parser2.start();
    }

    private PropagationParser(Model model, InputStream inputStream) {
        this(inputStream);
        this.model = model;
    }

    public static void main(String[] args) throws FileNotFoundException, ParseException {
        for (String filePath : args) {
            Model.loadModelFromFile(filePath);
        }
        Model.v().endInitialization();
        Model.v().dump();
    }

    public final void start() throws ParseException {
        block3: while (true) {
            this.namedArguments = new HashMap<String, Argument>();
            this.namedSuperclasses = new HashMap<String, String>();
            this.fields = new HashMap<String, Field>();
            this.object();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
    }

    public final void object() throws ParseException {
        this.jj_consume_token(7);
        this.classIdentifier();
        this.jj_consume_token(36);
        this.classDeclaration();
        this.jj_consume_token(37);
    }

    public final void classIdentifier() throws ParseException {
        String type = this.typeDescriptor();
        this.addModeledType(type);
    }

    public final void classDeclaration() throws ParseException {
        block15: {
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 10: 
                    case 11: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 21: 
                    case 22: 
                    case 30: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.fieldDeclaration();
                        continue block14;
                    }
                    case 10: {
                        this.argument();
                        continue block14;
                    }
                    case 8: {
                        this.modifier();
                        continue block14;
                    }
                    case 11: {
                        this.copy();
                        continue block14;
                    }
                    case 17: {
                        this.superclassDeclaration();
                        continue block14;
                    }
                    case 16: {
                        this.query();
                        continue block14;
                    }
                    case 19: {
                        this.exclude();
                        continue block14;
                    }
                    case 21: {
                        this.source();
                        continue block14;
                    }
                    case 22: {
                        this.staticField();
                        continue block14;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void fieldDeclaration() throws ParseException {
        int count = -1;
        Token t = this.jj_consume_token(30);
        String type = t.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                t = this.jj_consume_token(30);
                this.jj_consume_token(39);
                String optional = t.image;
                type = type + "<" + optional + ">";
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        t = this.jj_consume_token(30);
        String name = t.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                count = this.count();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(40);
        this.addField(name, type, count, t.beginLine);
    }

    public final String typeDescriptor() throws ParseException {
        Token t;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            t = this.jj_consume_token(31);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    t = this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return t.image;
    }

    public final void argument() throws ParseException {
        this.jj_consume_token(10);
        Token t = this.jj_consume_token(30);
        String argumentName = t.image;
        this.jj_consume_token(24);
        Argument argument = this.argumentDeclaration();
        this.namedArguments.put(argumentName, argument);
    }

    public final Argument argumentDeclaration() throws ParseException {
        Argument argument = new Argument();
        if (this.jj_2_2(2)) {
            this.argumentWithNumbers(argument);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: 
                case 42: {
                    this.argumentWithoutNumbers(argument);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return argument;
    }

    public final void argumentWithNumbers(Argument argument) throws ParseException {
        this.numbers(argument);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                if (this.jj_2_3(2)) {
                    this.jj_consume_token(23);
                    this.actionAndField(argument);
                    block12: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 41: {
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                                break block12;
                            }
                        }
                        this.jj_consume_token(41);
                        this.argumentDeclarationElement(argument);
                    }
                    this.jj_consume_token(40);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        this.argumentDeclarationElement(argument);
                        block13: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 41: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[8] = this.jj_gen;
                                    break block13;
                                }
                            }
                            this.jj_consume_token(41);
                            this.argumentDeclarationElement(argument);
                        }
                        this.jj_consume_token(40);
                        break block0;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void argumentWithoutNumbers(Argument argument) throws ParseException {
        if (this.jj_2_4(2)) {
            this.field(argument);
            this.jj_consume_token(40);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: 
                case 42: {
                    this.actionAndField(argument);
                    block6: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 41: {
                                break;
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(41);
                        this.argumentDeclarationElement(argument);
                    }
                    this.jj_consume_token(40);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void actionAndField(Argument argument) throws ParseException {
        this.actions(argument);
        this.field(argument);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 33: 
            case 42: {
                this.inlineValues(argument);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
    }

    public final void argumentDeclarationElement(Argument argument) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.type(argument);
                break;
            }
            case 25: {
                this.properties(argument);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void numbers(Argument argument) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.singleNumber(argument);
                break;
            }
            case 42: {
                this.multipleNumbers(argument);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void singleNumber(Argument argument) throws ParseException {
        Token t = this.jj_consume_token(27);
        try {
            argument.setArgnum(new int[]{Integer.parseInt(t.image)});
        }
        catch (NumberFormatException e) {
            throw new ParseException("Badly formatted integer: " + t.image);
        }
    }

    public final void multipleNumbers(Argument argument) throws ParseException {
        ArrayList<Integer> numberList = new ArrayList<Integer>(2);
        this.jj_consume_token(42);
        int number = this.multipleNumbersElement();
        numberList.add(number);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(41);
            number = this.multipleNumbersElement();
            numberList.add(number);
        }
        this.jj_consume_token(43);
        int[] numbers = new int[numberList.size()];
        for (int i = 0; i < numberList.size(); ++i) {
            numbers[i] = (Integer)numberList.get(i);
        }
        argument.setArgnum(numbers);
    }

    public final int multipleNumbersElement() throws ParseException {
        Token t = this.jj_consume_token(27);
        try {
            return Integer.parseInt(t.image);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Badly formatted integer: " + t.image);
        }
    }

    public final void field(Argument argument) throws ParseException {
        Token t = this.jj_consume_token(30);
        argument.setField(this.getField(t.image, t.beginLine));
    }

    public final void type(Argument argument) throws ParseException {
        this.jj_consume_token(9);
        String type = this.typeDescriptor();
        argument.setType(type);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                Token t = this.jj_consume_token(30);
                argument.setReferencedFieldName(t.image);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
    }

    public final void inlineValues(Argument argument) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 33: {
                this.singleInlineValue(argument);
                break;
            }
            case 42: {
                this.multipleInlineValues(argument);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void singleInlineValue(Argument argument) throws ParseException {
        String value = this.inlineValue();
        argument.setInlineValues(new String[]{value});
    }

    public final void multipleInlineValues(Argument argument) throws ParseException {
        ArrayList<String> valueList = new ArrayList<String>();
        this.jj_consume_token(42);
        String value = this.inlineValue();
        valueList.add(value);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(41);
            value = this.inlineValue();
            valueList.add(value);
        }
        this.jj_consume_token(43);
        argument.setInlineValues(valueList.toArray(new String[valueList.size()]));
    }

    public final String inlineValue() throws ParseException {
        String inlineValue;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                Token t = this.jj_consume_token(33);
                inlineValue = t.image;
                inlineValue = inlineValue.substring(1, inlineValue.length() - 1);
                break;
            }
            case 27: {
                Token t = this.jj_consume_token(27);
                inlineValue = t.image;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return inlineValue;
    }

    public final void actions(Argument argument) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.singleAction(argument);
                break;
            }
            case 42: {
                this.multipleActions(argument);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void singleAction(Argument argument) throws ParseException {
        Token t = this.jj_consume_token(30);
        argument.setActions(new String[]{t.image});
    }

    public final void multipleActions(Argument argument) throws ParseException {
        ArrayList<String> actionList = new ArrayList<String>(2);
        this.jj_consume_token(42);
        Token t = this.jj_consume_token(30);
        actionList.add(t.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(41);
            t = this.jj_consume_token(30);
            actionList.add(t.image);
        }
        this.jj_consume_token(43);
        argument.setActions(actionList.toArray(new String[actionList.size()]));
    }

    public final void properties(Argument argument) throws ParseException {
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 33: {
                this.singleProperty(argument);
                break;
            }
            case 42: {
                this.multipleProperties(argument);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void singleProperty(Argument argument) throws ParseException {
        String key = this.inlineValue();
        this.jj_consume_token(23);
        String value = this.inlineValue();
        argument.addProperty(key, value);
    }

    public final void multipleProperties(Argument argument) throws ParseException {
        this.jj_consume_token(42);
        String key = this.inlineValue();
        this.jj_consume_token(23);
        String value = this.inlineValue();
        argument.addProperty(key, value);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(41);
            key = this.inlineValue();
            this.jj_consume_token(23);
            value = this.inlineValue();
            argument.addProperty(key, value);
        }
        this.jj_consume_token(43);
    }

    public final int count() throws ParseException {
        this.jj_consume_token(42);
        Token t = this.jj_consume_token(27);
        this.jj_consume_token(43);
        try {
            return Short.parseShort(t.image);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Badly formatted integer: " + t.image);
        }
    }

    public final void modifier() throws ParseException {
        this.jj_consume_token(8);
        String modifierModifier = this.modifierModifier();
        ExtendedSignature extendedSignature = this.extendedSignature();
        this.jj_consume_token(36);
        Argument[] arguments = this.modifierOrQueryOrFieldDeclaration();
        this.jj_consume_token(37);
        this.addModifier(extendedSignature, arguments, modifierModifier);
    }

    public final String modifierModifier() throws ParseException {
        String modifierModifier = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 20: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        t = this.jj_consume_token(20);
                        break;
                    }
                    case 11: {
                        t = this.jj_consume_token(11);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                modifierModifier = t.image;
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        return modifierModifier;
    }

    public final ExtendedSignature extendedSignature() throws ParseException {
        String signature;
        String superclass = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                signature = this.queryOrModifierSignature();
                break;
            }
            case 30: {
                superclass = this.superclass();
                this.jj_consume_token(23);
                signature = this.queryShortSignature();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new ExtendedSignature(signature, superclass);
    }

    public final Argument[] modifierOrQueryOrFieldDeclaration() throws ParseException {
        ArrayList<Argument> argumentList = new ArrayList<Argument>();
        block7: while (true) {
            Argument argument;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 27: 
                case 30: 
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    argument = this.namedArgument();
                    break;
                }
                case 27: 
                case 30: 
                case 42: {
                    argument = this.argumentDeclaration();
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            argumentList.add(argument);
        }
        return argumentList.toArray(new Argument[argumentList.size()]);
    }

    public final Argument namedArgument() throws ParseException {
        this.jj_consume_token(10);
        Token t = this.jj_consume_token(30);
        this.jj_consume_token(40);
        Argument argument = this.namedArguments.get(t.image);
        if (argument == null) {
            throw new ParseException("Undefined argument: " + t.image);
        }
        return argument;
    }

    public final void copy() throws ParseException {
        this.jj_consume_token(11);
        Token t = this.jj_consume_token(29);
        String signature = t.image;
        this.jj_consume_token(36);
        Argument[] arguments = this.modifierOrQueryOrFieldDeclaration();
        this.jj_consume_token(37);
        this.addCopyConstructor(signature, arguments);
    }

    public final void query() throws ParseException {
        this.jj_consume_token(16);
        ExtendedSignature extendedSignature = this.extendedSignature();
        this.jj_consume_token(36);
        Argument[] arguments = this.modifierOrQueryOrFieldDeclaration();
        this.jj_consume_token(37);
        this.addQuery(extendedSignature, arguments);
    }

    public final String queryOrModifierSignature() throws ParseException {
        Token t = this.jj_consume_token(29);
        return t.image;
    }

    public final void superclassDeclaration() throws ParseException {
        this.jj_consume_token(17);
        Token t = this.jj_consume_token(30);
        this.jj_consume_token(24);
        String name = t.image;
        String superclass = this.typeDescriptor();
        this.jj_consume_token(40);
        this.addNamedSuperclass(name, superclass);
    }

    public final String superclass() throws ParseException {
        String superclass = this.namedSuperclass();
        return superclass;
    }

    public final String namedSuperclass() throws ParseException {
        Token t = this.jj_consume_token(30);
        return this.getNamedSuperclass(t.image);
    }

    public final String queryShortSignature() throws ParseException {
        Token t = this.jj_consume_token(28);
        return t.image;
    }

    public final void exclude() throws ParseException {
        this.jj_consume_token(19);
        Token t = this.jj_consume_token(31);
        this.jj_consume_token(40);
        this.addExcludedClass(t.image);
    }

    public final void source() throws ParseException {
        this.jj_consume_token(21);
        Token t = this.jj_consume_token(29);
        String signature = t.image;
        this.jj_consume_token(36);
        Argument[] arguments = this.modifierOrQueryOrFieldDeclaration();
        this.jj_consume_token(37);
        this.addSource(new ExtendedSignature(signature, null), arguments);
    }

    public final void staticField() throws ParseException {
        this.jj_consume_token(22);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.shortStaticField();
                break;
            }
            case 32: {
                this.extendedStaticField();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void shortStaticField() throws ParseException {
        Argument argument = new Argument();
        Token t = this.jj_consume_token(30);
        argument.setField(this.getField(t.image, t.beginLine));
        t = this.jj_consume_token(32);
        String signature = t.image;
        this.jj_consume_token(24);
        this.inlineValues(argument);
        this.jj_consume_token(40);
        argument.setActions(new String[]{"replace"});
        this.addConstant(signature, new Argument[]{argument});
    }

    public final void extendedStaticField() throws ParseException {
        Token t = this.jj_consume_token(32);
        String signature = t.image;
        this.jj_consume_token(36);
        Argument[] arguments = this.modifierOrQueryOrFieldDeclaration();
        this.jj_consume_token(37);
        this.addConstant(signature, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private boolean jj_3R_25() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_12() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3_4() {
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_15() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private boolean jj_3R_11() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_15()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_19() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_20() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_17() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_18() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{128, 1080757504, 1080757504, 0, 0, 0x40000000, 0x40000000, 0, 0, 0, 0x800000, 0, 0x40000000, 0x8000000, 0x2000200, 0x8000000, 0, 0x800000, 0x8000000, 0, 0x8000000, 0x40000000, 0, 0x8000000, 0, 0x100800, 0x100800, 0x60000000, 0x48000400, 0x48000400, 0x40000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 64, 1024, 0, 1024, 512, 512, 256, 0, 512, 1024, 1026, 0, 1024, 512, 0, 1026, 512, 2, 1024, 512, 1026, 512, 0, 0, 0, 1024, 1024, 1};
    }

    public PropagationParser(InputStream stream) {
        this(stream, null);
    }

    public PropagationParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PropagationParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PropagationParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PropagationParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PropagationParser(PropagationParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PropagationParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[44];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 31; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 44; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PropagationParser.jj_la1_init_0();
        PropagationParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

