/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.transformers;

import edu.psu.cse.siis.coal.Internable;
import edu.psu.cse.siis.coal.Pool;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.values.FieldValue;
import edu.psu.cse.siis.coal.field.values.NullFieldValue;
import edu.psu.cse.siis.coal.transformers.NullPathTransformer;
import edu.psu.cse.siis.coal.values.PathValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PathTransformer
implements Internable<PathTransformer> {
    private static final Pool<PathTransformer> POOL = new Pool();
    protected Map<String, FieldTransformer> fieldMap = new HashMap<String, FieldTransformer>();

    public void addFieldTransformer(String field, FieldTransformer transformer) {
        this.fieldMap.put(field, transformer);
    }

    public PathValue computeTarget(PathValue source) {
        String field;
        Map<String, FieldValue> secondFieldMap = source.getFieldMap();
        PathValue result = new PathValue();
        for (Map.Entry<String, FieldTransformer> entry : this.fieldMap.entrySet()) {
            field = entry.getKey();
            FieldTransformer fieldTransformer = entry.getValue();
            FieldValue fieldValue = secondFieldMap.get(field);
            if (fieldValue == null) {
                fieldValue = NullFieldValue.v();
            }
            if (fieldTransformer != null) {
                result.addFieldEntry(field, fieldTransformer.apply(fieldValue));
                continue;
            }
            result.addFieldEntry(field, fieldValue);
        }
        for (Map.Entry<String, Internable<FieldTransformer>> entry : secondFieldMap.entrySet()) {
            field = entry.getKey();
            if (this.fieldMap.containsKey(field)) continue;
            result.addFieldEntry(field, (FieldValue)entry.getValue());
        }
        return result;
    }

    public PathTransformer compose(PathTransformer secondPathTransformer) {
        String field;
        if (secondPathTransformer instanceof NullPathTransformer) {
            return secondPathTransformer;
        }
        PathTransformer result = new PathTransformer();
        Map<String, FieldTransformer> secondFieldMap = secondPathTransformer.fieldMap;
        for (Map.Entry<String, FieldTransformer> entry : this.fieldMap.entrySet()) {
            field = entry.getKey();
            FieldTransformer fieldTransformer = entry.getValue();
            if (fieldTransformer == null) continue;
            FieldTransformer secondFieldTransformer = secondFieldMap.get(field);
            if (secondFieldTransformer != null) {
                fieldTransformer = fieldTransformer.compose(secondFieldTransformer);
            }
            result.addFieldTransformer(field, fieldTransformer);
        }
        for (Map.Entry<String, FieldTransformer> entry : secondFieldMap.entrySet()) {
            field = entry.getKey();
            if (this.fieldMap.containsKey(field)) continue;
            result.addFieldTransformer(field, entry.getValue());
        }
        return result.intern();
    }

    public String toString() {
        return this.fieldMap != null ? this.fieldMap.toString() : "null";
    }

    public int hashCode() {
        return Objects.hashCode(this.fieldMap);
    }

    public boolean equals(Object other) {
        return other instanceof PathTransformer && Objects.equals(this.fieldMap, ((PathTransformer)other).fieldMap);
    }

    @Override
    public PathTransformer intern() {
        return POOL.intern(this);
    }
}

