/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.transformers;

import edu.psu.cse.siis.coal.Internable;
import edu.psu.cse.siis.coal.Pool;
import edu.psu.cse.siis.coal.transformers.PathTransformer;
import edu.psu.cse.siis.coal.transformers.TopPropagationTransformer;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import edu.psu.cse.siis.coal.values.PathValue;
import edu.psu.cse.siis.coal.values.PropagationValue;
import edu.psu.cse.siis.coal.values.TopPropagationValue;
import heros.EdgeFunction;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagationTransformer
implements EdgeFunction<BasePropagationValue>,
Internable<PropagationTransformer> {
    private static final Pool<PropagationTransformer> POOL = new Pool();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<PathTransformer> pathTransformers = new HashSet<PathTransformer>(2);

    public void addPathTransformer(PathTransformer pathTransformer) {
        this.pathTransformers.add(pathTransformer);
    }

    @Override
    public PropagationValue computeTarget(BasePropagationValue source) {
        PropagationValue result;
        block4: {
            block3: {
                result = new PropagationValue();
                if (!(source instanceof PropagationValue)) break block3;
                for (PathTransformer pathTransformer : this.pathTransformers) {
                    for (PathValue pathValue : ((PropagationValue)source).getPathValues()) {
                        result.addPathValue(pathTransformer.computeTarget(pathValue));
                    }
                }
                break block4;
            }
            if (!(source instanceof TopPropagationValue)) break block4;
            for (PathTransformer pathTransformer : this.pathTransformers) {
                result.addPathValue(pathTransformer.computeTarget(new PathValue()));
            }
        }
        return result.intern();
    }

    @Override
    public EdgeFunction<BasePropagationValue> composeWith(EdgeFunction<BasePropagationValue> secondFunction) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Composing " + this + " with " + secondFunction);
        }
        if (secondFunction instanceof PropagationTransformer) {
            Set<PathTransformer> secondPathTransformers = ((PropagationTransformer)secondFunction).pathTransformers;
            PropagationTransformer result = new PropagationTransformer();
            for (PathTransformer pathTransformer : this.pathTransformers) {
                for (PathTransformer secondPathTransformer : secondPathTransformers) {
                    result.pathTransformers.add(pathTransformer.compose(secondPathTransformer));
                    if (result.pathTransformers.size() <= 256) continue;
                    return TopPropagationTransformer.v();
                }
            }
            return result.intern();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Returning " + this);
        }
        return this;
    }

    @Override
    public EdgeFunction<BasePropagationValue> joinWith(EdgeFunction<BasePropagationValue> otherFunction) {
        if (otherFunction instanceof PropagationTransformer) {
            PropagationTransformer result = new PropagationTransformer();
            result.pathTransformers.addAll(this.pathTransformers);
            result.pathTransformers.addAll(((PropagationTransformer)otherFunction).pathTransformers);
            if (result.pathTransformers.size() > 256) {
                return TopPropagationTransformer.v();
            }
            return result.intern();
        }
        return this;
    }

    @Override
    public boolean equalTo(EdgeFunction<BasePropagationValue> other) {
        if (!(other instanceof PropagationTransformer)) {
            return false;
        }
        PropagationTransformer secondTransformer = (PropagationTransformer)other;
        return this.pathTransformers.equals(secondTransformer.pathTransformers);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Transformer: " + this.pathTransformers.size() + " values\n");
        for (PathTransformer pathTransformer : this.pathTransformers) {
            result.append(pathTransformer.toString());
            result.append("\n");
        }
        return result.toString();
    }

    public int hashCode() {
        return this.pathTransformers.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof PropagationTransformer && Objects.equals(this.pathTransformers, ((PropagationTransformer)other).equals(this.pathTransformers));
    }

    @Override
    public PropagationTransformer intern() {
        return POOL.intern(this);
    }
}

