/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.transformers;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.IterationSolver;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import edu.psu.cse.siis.coal.arguments.SourceDescriptor;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformerManager;
import edu.psu.cse.siis.coal.field.transformers.IdentityFieldTransformer;
import edu.psu.cse.siis.coal.transformers.IdentityPathTransformer;
import edu.psu.cse.siis.coal.transformers.NullPathTransformer;
import edu.psu.cse.siis.coal.transformers.PathTransformer;
import edu.psu.cse.siis.coal.transformers.PropagationTransformer;
import edu.psu.cse.siis.coal.transformers.TopPropagationTransformer;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import heros.EdgeFunction;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Unit;
import soot.jimple.Stmt;

public class PropagationTransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger(PropagationTransformerFactory.class);

    public static EdgeFunction<BasePropagationValue> makeTransformer(Unit callSite, Argument[] arguments, boolean alias) {
        PropagationTransformer result = new PropagationTransformer();
        if (callSite == null && arguments == null) {
            result.addPathTransformer(NullPathTransformer.v());
        } else {
            result.addPathTransformer(IdentityPathTransformer.v());
            for (Argument argument : arguments) {
                PropagationTransformer newTransformer = PropagationTransformerFactory.makeTransformerForArgument(callSite, argument);
                EdgeFunction<BasePropagationValue> newResult = result.composeWith(newTransformer);
                if (newResult instanceof TopPropagationTransformer) {
                    return TopPropagationTransformer.v();
                }
                result = (PropagationTransformer)newResult;
            }
        }
        return result.intern();
    }

    private static PropagationTransformer makeTransformerForArgument(Unit callSite, Argument argument) {
        PropagationTransformer transformer = new PropagationTransformer();
        if (Model.v().isModeledType(argument.getType())) {
            String[] actions2 = argument.getActions();
            if (AnalysisParameters.v().isIterative()) {
                String field = argument.getFieldName();
                Set<FieldTransformer> fieldTransformers = IterationSolver.v().makeTransformersFromReferencedValue(callSite, ((Stmt)callSite).getInvokeExpr().getArg(argument.getArgnum()[0]), field, argument.getNominalFieldType(), actions2[0]);
                for (FieldTransformer fieldTransformer : fieldTransformers) {
                    PathTransformer pathTransformer = new PathTransformer();
                    pathTransformer.addFieldTransformer(field, fieldTransformer);
                    transformer.addPathTransformer(pathTransformer.intern());
                }
            } else {
                FieldTransformer fieldTransformer = FieldTransformerManager.v().makeFieldTransformer("compose", ((Stmt)callSite).getInvokeExpr().getArg(argument.getArgnum()[0]), (Stmt)callSite, actions2[0]);
                PathTransformer pathTransformer = new PathTransformer();
                pathTransformer.addFieldTransformer(argument.getFieldName(), fieldTransformer);
                transformer.addPathTransformer(pathTransformer.intern());
            }
        } else {
            Set<Object> values = ArgumentValueManager.v().getArgumentValues(argument, callSite);
            PropagationTransformerFactory.makePlainTransformer(values, transformer, argument, callSite);
        }
        return transformer.intern();
    }

    private static void makePlainTransformer(Set<Object> values, PropagationTransformer transformer, Argument argument, Unit callSite) {
        if (values == null) {
            PropagationTransformerFactory.addPathTransformer(transformer, argument, null);
        } else {
            if (values.size() == 0) {
                logger.error(callSite.toString());
                logger.error(AnalysisParameters.v().getIcfg().getMethodOf(callSite).toString());
                logger.error("Warning: Missing argument value for type " + argument.getType() + ". Setting to (.*)");
                values.add("(.*)");
            }
            for (Object value : values) {
                PropagationTransformerFactory.addPathTransformer(transformer, argument, value);
            }
        }
    }

    private static void addPathTransformer(PropagationTransformer transformer, Argument argument, Object value) {
        FieldTransformer fieldTransformer = IdentityFieldTransformer.v();
        if (value instanceof SourceDescriptor) {
            if (AnalysisParameters.v().isIterative()) {
                SourceDescriptor sourceDescriptor = (SourceDescriptor)value;
                String[] actions2 = argument.getActions();
                if (actions2.length != 1) {
                    throw new RuntimeException("Not implemented with more than one action at stmt");
                }
                String field = argument.getFieldName();
                Set<FieldTransformer> fieldTransformers = IterationSolver.v().makeTransformersFromReferencedValue(sourceDescriptor.getStmt(), sourceDescriptor.getSymbol(), field, argument.getNominalFieldType(), actions2[0]);
                for (FieldTransformer fieldTransformer2 : fieldTransformers) {
                    PathTransformer pathTransformer = new PathTransformer();
                    pathTransformer.addFieldTransformer(field, fieldTransformer2);
                    transformer.addPathTransformer(pathTransformer.intern());
                }
                return;
            }
            for (String action : argument.getActions()) {
                SourceDescriptor sourceDescriptor = (SourceDescriptor)value;
                fieldTransformer = ((FieldTransformer)fieldTransformer).compose(FieldTransformerManager.v().makeFieldTransformer("compose", sourceDescriptor.getSymbol(), sourceDescriptor.getStmt(), action));
            }
        } else {
            for (String action : argument.getActions()) {
                fieldTransformer = ((FieldTransformer)fieldTransformer).compose(FieldTransformerManager.v().makeFieldTransformer(action, value));
            }
        }
        PathTransformer pathTransformer = new PathTransformer();
        pathTransformer.addFieldTransformer(argument.getFieldName(), fieldTransformer);
        transformer.addPathTransformer(pathTransformer.intern());
    }
}

