/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.values;

import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.field.values.FieldValue;
import edu.psu.cse.siis.coal.field.values.IntermediateFieldValue;
import edu.psu.cse.siis.coal.field.values.NullFieldValue;
import edu.psu.cse.siis.coal.field.values.ScalarFieldValue;
import edu.psu.cse.siis.coal.field.values.SetFieldValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PathValue {
    private Map<String, FieldValue> fieldMap = new HashMap<String, FieldValue>();

    public void addFieldEntry(String field, FieldValue fieldValue) {
        this.fieldMap.put(field, fieldValue);
    }

    public Map<String, FieldValue> getFieldMap() {
        return this.fieldMap;
    }

    public FieldValue getFieldValue(String field) {
        return this.fieldMap.get(field);
    }

    public <T> Set<T> getSetFieldValue(String field, Class<T> type) {
        FieldValue fieldValue = this.fieldMap.get(field);
        if (fieldValue == null || fieldValue == NullFieldValue.v()) {
            return null;
        }
        if (fieldValue instanceof SetFieldValue) {
            SetFieldValue setFieldValue = (SetFieldValue)fieldValue;
            HashSet result = new HashSet();
            for (Object value : (Set)setFieldValue.getValue()) {
                result.add(value);
            }
            return result;
        }
        throw new RuntimeException("Could not apply getSetFieldValue to non-set type " + fieldValue.getClass() + ": " + fieldValue);
    }

    public Set<String> getSetStringFieldValue(String field) {
        return this.getSetFieldValue(field, String.class);
    }

    public boolean containsNonNullFieldValue(String field) {
        FieldValue fieldValue = this.fieldMap.get(field);
        return fieldValue != null && fieldValue != NullFieldValue.v();
    }

    public <T> T getScalarFieldValue(String field, Class<T> type) {
        FieldValue fieldValue = this.fieldMap.get(field);
        if (fieldValue == null || fieldValue == NullFieldValue.v()) {
            return null;
        }
        if (fieldValue instanceof ScalarFieldValue) {
            return ((ScalarFieldValue)fieldValue).getFieldValue(type);
        }
        throw new RuntimeException("Could not apply getScalarFieldValue to non-scalar type " + this.getClass());
    }

    public String getScalarStringFieldValue(String field) {
        return this.getScalarFieldValue(field, String.class);
    }

    public boolean containsIntermediateField() {
        for (Map.Entry<String, FieldValue> entry : this.fieldMap.entrySet()) {
            if (!(entry.getValue() instanceof IntermediateFieldValue)) continue;
            return true;
        }
        return false;
    }

    public Set<PathValue> makeFinalBranchValues(PropagationSolver solver) {
        ArrayList<String> partialValueFields = new ArrayList<String>();
        HashMap<String, FieldValue> partialFieldMap = new HashMap<String, FieldValue>();
        for (Map.Entry<String, FieldValue> entry : this.fieldMap.entrySet()) {
            FieldValue fieldValue = entry.getValue();
            if (fieldValue instanceof IntermediateFieldValue) {
                partialValueFields.add(entry.getKey());
                continue;
            }
            partialFieldMap.put(entry.getKey(), fieldValue);
        }
        Set<Map<String, FieldValue>> fieldMaps = Collections.singleton(partialFieldMap);
        for (String partialValueField : partialValueFields) {
            fieldMaps = this.addFieldValuesToFieldMaps(fieldMaps, partialValueField, ((IntermediateFieldValue)this.fieldMap.get(partialValueField)).makeFinalFieldValues(partialValueField, solver));
        }
        HashSet<PathValue> result = new HashSet<PathValue>();
        for (Map map : fieldMaps) {
            PathValue newBranchValue = new PathValue();
            newBranchValue.fieldMap = map;
            result.add(newBranchValue);
        }
        return result;
    }

    private Set<Map<String, FieldValue>> addFieldValuesToFieldMaps(Set<Map<String, FieldValue>> fieldMaps, String field, Set<FieldValue> fieldValues) {
        HashSet<Map<String, FieldValue>> result = new HashSet<Map<String, FieldValue>>();
        for (Map<String, FieldValue> fieldMap : fieldMaps) {
            result.addAll(this.addFieldValuesToFieldMap(fieldMap, field, fieldValues));
        }
        return result;
    }

    private Set<Map<String, FieldValue>> addFieldValuesToFieldMap(Map<String, FieldValue> fieldMap, String field, Set<FieldValue> fieldValues) {
        HashSet<Map<String, FieldValue>> result = new HashSet<Map<String, FieldValue>>();
        for (FieldValue fieldValue : fieldValues) {
            HashMap<String, FieldValue> newFieldMap = new HashMap<String, FieldValue>(fieldMap);
            if (fieldValue != null) {
                newFieldMap.put(field, fieldValue);
            }
            result.add(newFieldMap);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> parts = new ArrayList<String>(this.fieldMap.size());
        for (Map.Entry<String, FieldValue> entry : this.fieldMap.entrySet()) {
            FieldValue value = entry.getValue();
            String valueString = value == null ? "null" : value.toString();
            parts.add(entry.getKey() + "=" + valueString + ", ");
        }
        Collections.sort(parts);
        for (String part : parts) {
            result.append(part);
        }
        return result.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.fieldMap);
    }

    public boolean equals(Object other) {
        return other instanceof PathValue && Objects.equals(this.fieldMap, ((PathValue)other).fieldMap);
    }
}

