/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.values;

import edu.psu.cse.siis.coal.Internable;
import edu.psu.cse.siis.coal.Pool;
import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.field.values.FieldValue;
import edu.psu.cse.siis.coal.field.values.NullFieldValue;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import edu.psu.cse.siis.coal.values.NullPathValue;
import edu.psu.cse.siis.coal.values.PathValue;
import edu.psu.cse.siis.coal.values.TopPropagationValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagationValue
implements BasePropagationValue,
Internable<PropagationValue> {
    private static final Pool<PropagationValue> POOL = new Pool();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<PathValue> pathValues = new HashSet<PathValue>();

    public Set<PathValue> getPathValues() {
        return this.pathValues;
    }

    public void addPathValue(PathValue pathValue) {
        this.pathValues.add(pathValue);
    }

    public Set<FieldValue> getValuesForField(String field) {
        HashSet<FieldValue> result = new HashSet<FieldValue>();
        for (PathValue pathValue : this.pathValues) {
            if (pathValue == NullPathValue.v()) {
                NullFieldValue nullFieldValue = NullFieldValue.v();
                result.add(nullFieldValue);
                continue;
            }
            result.add(pathValue.getFieldMap().get(field));
        }
        return result;
    }

    public BasePropagationValue joinWith(PropagationValue other) {
        if (this.pathValues.size() + other.pathValues.size() > 256) {
            return TopPropagationValue.v();
        }
        PropagationValue result = new PropagationValue();
        result.pathValues.addAll(this.pathValues);
        result.pathValues.addAll(other.pathValues);
        return result.intern();
    }

    public boolean isIntermediateValue() {
        for (PathValue pathValue : this.pathValues) {
            if (!pathValue.containsIntermediateField()) continue;
            return true;
        }
        return false;
    }

    public void makeFinalValue(PropagationSolver solver) {
        if (!this.isIntermediateValue()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Making final value for " + this.toString());
        }
        HashSet<PathValue> finalPathValues = new HashSet<PathValue>();
        for (PathValue pathValue : this.pathValues) {
            if (pathValue.containsIntermediateField()) {
                finalPathValues.addAll(pathValue.makeFinalBranchValues(solver));
                continue;
            }
            finalPathValues.add(pathValue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Transformed to " + ((Object)finalPathValues).toString());
        }
        this.pathValues = finalPathValues;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Value: " + this.pathValues.size() + " path values\n");
        ArrayList<String> parts = new ArrayList<String>(this.pathValues.size());
        for (PathValue pathValue : this.pathValues) {
            parts.add("  " + pathValue.toString() + "\n");
        }
        Collections.sort(parts);
        for (String part : parts) {
            result.append(part);
        }
        return result.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.pathValues);
    }

    public boolean equals(Object other) {
        return other instanceof PropagationValue && Objects.equals(this.pathValues, ((PropagationValue)other).pathValues);
    }

    @Override
    public PropagationValue intern() {
        return POOL.intern(this);
    }
}

