/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.PropagationTimers;
import edu.psu.cse.siis.ic3.Timers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Hierarchy;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;

public class EntryPointMappingSceneTransformer
extends SceneTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static SootClass activityClass = null;
    private static SootClass serviceClass = null;
    private static SootClass gcmBaseIntentServiceClass = null;
    private static SootClass receiverClass = null;
    private static SootClass providerClass = null;
    private static SootClass applicationClass = null;
    private final Set<String> entryPointClasses;
    private final Map<String, Set<String>> callbackMethods;
    private final Map<SootMethod, Set<String>> entryPointMap;
    private final Set<SootMethod> visitedEntryPoints = new HashSet<SootMethod>();

    public EntryPointMappingSceneTransformer(Set<String> entryPointClasses, Map<String, Set<String>> callbackMethods, Map<SootMethod, Set<String>> entryPointMap) {
        this.entryPointClasses = entryPointClasses;
        this.callbackMethods = callbackMethods;
        this.entryPointMap = entryPointMap;
    }

    protected void internalTransform(String phaseName, Map options) {
        PropagationTimers.v().totalTimer.start();
        Timers.v().entryPointMapping.start();
        Map<SootMethod, Set<String>> entryPointMap = this.entryPointMap;
        if (this.logger.isDebugEnabled()) {
            HashSet<String> difference = new HashSet<String>(this.callbackMethods.keySet());
            difference.removeAll(this.entryPointClasses);
            if (difference.size() == 0) {
                this.logger.debug("Difference size is 0");
            } else {
                this.logger.debug("Difference is " + difference);
            }
        }
        activityClass = Scene.v().getSootClass("android.app.Activity");
        serviceClass = Scene.v().getSootClass("android.app.Service");
        gcmBaseIntentServiceClass = Scene.v().getSootClass("com.google.android.gcm.GCMBaseIntentService");
        receiverClass = Scene.v().getSootClass("android.content.BroadcastReceiver");
        providerClass = Scene.v().getSootClass("android.content.ContentProvider");
        applicationClass = Scene.v().getSootClass("android.app.Application");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.callbackMethods.toString());
        }
        for (String entryPoint : this.entryPointClasses) {
            SootMethod method;
            SootClass entryPointClass = Scene.v().getSootClass(entryPoint);
            ArrayList<MethodOrMethodContext> callbacks = new ArrayList<MethodOrMethodContext>();
            boolean knownComponentType = this.addLifecycleMethods(entryPointClass, callbacks);
            for (SootMethod method2 : entryPointClass.getMethods()) {
                String methodName = method2.getName();
                if (!methodName.equals("<init>") && !methodName.equals("<clinit>") && knownComponentType) continue;
                callbacks.add(method2);
            }
            Set<String> callbackMethodStrings = this.callbackMethods.get(entryPoint);
            if (callbackMethodStrings != null) {
                for (String callbackMethodString : callbackMethodStrings) {
                    if (!Scene.v().containsMethod(callbackMethodString)) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn("Warning: " + callbackMethodString + " is not in scene");
                        continue;
                    }
                    method = Scene.v().getMethod(callbackMethodString);
                    for (SootMethod potentialInit : method.getDeclaringClass().getMethods()) {
                        if (potentialInit.isPrivate()) continue;
                        String name = potentialInit.getName();
                        if (name.equals("<init>")) {
                            this.addConstructorStack(potentialInit, callbacks);
                            continue;
                        }
                        if (!name.equals("<clinit>")) continue;
                        callbacks.add(potentialInit);
                    }
                    callbacks.add(method);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(((Object)callbacks).toString());
            }
            ReachableMethods reachableMethods = new ReachableMethods(Scene.v().getCallGraph(), callbacks.iterator(), null);
            reachableMethods.update();
            QueueReader<MethodOrMethodContext> iter = reachableMethods.listener();
            while (iter.hasNext()) {
                Set<String> entryPoints;
                method = ((MethodOrMethodContext)iter.next()).method();
                if (!AnalysisParameters.v().isAnalysisClass(method.getDeclaringClass().getName())) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(method.toString());
                }
                if ((entryPoints = entryPointMap.get(method)) == null) {
                    entryPoints = new HashSet<String>();
                    entryPointMap.put(method, entryPoints);
                }
                entryPoints.add(entryPoint);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entry points");
            this.logger.debug(entryPointMap.toString());
            CallGraph cg = Scene.v().getCallGraph();
            QueueReader<Edge> it = cg.listener();
            StringBuilder stringBuilder = new StringBuilder("Call graph:\n");
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                stringBuilder.append("" + e.src() + e.srcStmt() + " =" + e.kind() + "=> " + e.tgt() + "\n");
            }
            this.logger.debug(stringBuilder.toString());
        }
        Timers.v().entryPointMapping.end();
        PropagationTimers.v().totalTimer.end();
    }

    private boolean addLifecycleMethods(SootClass entryPointClass, List<MethodOrMethodContext> callbacks) {
        boolean result = true;
        Hierarchy hierarchy = Scene.v().getActiveHierarchy();
        if (hierarchy.isClassSubclassOf(entryPointClass, activityClass)) {
            this.addLifecycleMethodsHelper(entryPointClass, AndroidEntryPointConstants.getActivityLifecycleMethods(), callbacks);
        } else if (hierarchy.isClassSubclassOf(entryPointClass, gcmBaseIntentServiceClass)) {
            this.addLifecycleMethodsHelper(entryPointClass, AndroidEntryPointConstants.getGCMIntentServiceMethods(), callbacks);
        } else if (hierarchy.isClassSubclassOf(entryPointClass, serviceClass)) {
            this.addLifecycleMethodsHelper(entryPointClass, AndroidEntryPointConstants.getServiceLifecycleMethods(), callbacks);
        } else if (hierarchy.isClassSubclassOf(entryPointClass, receiverClass)) {
            this.addLifecycleMethodsHelper(entryPointClass, AndroidEntryPointConstants.getBroadcastLifecycleMethods(), callbacks);
        } else if (hierarchy.isClassSubclassOf(entryPointClass, providerClass)) {
            this.addLifecycleMethodsHelper(entryPointClass, AndroidEntryPointConstants.getContentproviderLifecycleMethods(), callbacks);
        } else if (hierarchy.isClassSubclassOf(entryPointClass, applicationClass)) {
            this.addLifecycleMethodsHelper(entryPointClass, AndroidEntryPointConstants.getApplicationLifecycleMethods(), callbacks);
        } else {
            System.err.println("Unknown entry point type: " + entryPointClass);
            result = false;
        }
        return result;
    }

    private void addLifecycleMethodsHelper(SootClass entryPointClass, List<String> lifecycleMethods, List<MethodOrMethodContext> callbacks) {
        for (String lifecycleMethod : lifecycleMethods) {
            SootMethod method = this.findMethod(entryPointClass, lifecycleMethod);
            if (method == null) continue;
            callbacks.add(method);
        }
    }

    protected SootMethod findMethod(SootClass currentClass, String subsignature) {
        if (currentClass.declaresMethod(subsignature)) {
            return currentClass.getMethod(subsignature);
        }
        if (currentClass.hasSuperclass()) {
            return this.findMethod(currentClass.getSuperclass(), subsignature);
        }
        return null;
    }

    private void addConstructorStack(SootMethod method, List<MethodOrMethodContext> callbacks) {
        if (this.visitedEntryPoints.contains(method)) {
            return;
        }
        callbacks.add(method);
        this.visitedEntryPoints.add(method);
        for (Type type : method.getParameterTypes()) {
            String typeString = type.toString();
            if (!AnalysisParameters.v().isAnalysisClass(typeString)) continue;
            if (Scene.v().containsClass(typeString)) {
                SootClass sootClass = Scene.v().getSootClass(typeString);
                for (SootMethod sootMethod : sootClass.getMethods()) {
                    if (!sootMethod.getName().equals("<init>")) continue;
                    this.addConstructorStack(sootMethod, callbacks);
                }
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Warning: " + typeString + " is not in scene");
        }
    }
}

