/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.Analysis;
import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.FatalAnalysisException;
import edu.psu.cse.siis.coal.PropagationSceneTransformer;
import edu.psu.cse.siis.coal.PropagationSceneTransformerFilePrinter;
import edu.psu.cse.siis.coal.SymbolFilter;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import edu.psu.cse.siis.coal.arguments.MethodReturnValueManager;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformerManager;
import edu.psu.cse.siis.ic3.AndroidMethodReturnValueAnalyses;
import edu.psu.cse.siis.ic3.AuthorityValueAnalysis;
import edu.psu.cse.siis.ic3.ClassTypeValueAnalysis;
import edu.psu.cse.siis.ic3.ContextValueAnalysis;
import edu.psu.cse.siis.ic3.EntryPointMappingSceneTransformer;
import edu.psu.cse.siis.ic3.Ic3CommandLineArguments;
import edu.psu.cse.siis.ic3.Ic3Data;
import edu.psu.cse.siis.ic3.Ic3ResultBuilder;
import edu.psu.cse.siis.ic3.PathValueAnalysis;
import edu.psu.cse.siis.ic3.ProtobufResultProcessor;
import edu.psu.cse.siis.ic3.ResultProcessor;
import edu.psu.cse.siis.ic3.SetupApplication;
import edu.psu.cse.siis.ic3.Timers;
import edu.psu.cse.siis.ic3.db.SQLConnection;
import edu.psu.cse.siis.ic3.manifest.ManifestPullParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Value;
import soot.jimple.StaticFieldRef;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.manifest.ProcessManifest;
import soot.options.Options;

public class Ic3Analysis
extends Analysis<Ic3CommandLineArguments> {
    private static final String INTENT = "android.content.Intent";
    private static final String INTENT_FILTER = "android.content.IntentFilter";
    private static final String BUNDLE = "android.os.Bundle";
    private static final String COMPONENT_NAME = "android.content.ComponentName";
    private static final String ACTIVITY = "android.app.Activity";
    private static final String[] frameworkClassesArray = new String[]{"android.content.Intent", "android.content.IntentFilter", "android.os.Bundle", "android.content.ComponentName", "android.app.Activity"};
    protected static final List<String> frameworkClasses = Arrays.asList(frameworkClassesArray);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Ic3Data.Application.Builder ic3Builder;
    private Map<String, Ic3Data.Application.Component.Builder> componentNameToBuilderMap;
    protected String outputDir;
    protected Writer writer;
    protected ManifestPullParser detailedManifest;
    protected Map<String, Integer> componentToIdMap;
    protected SetupApplication setupApplication;
    protected String packageName;

    @Override
    protected void registerFieldTransformerFactories(Ic3CommandLineArguments commandLineArguments) {
        Timers.v().totalTimer.start();
        FieldTransformerManager.v().registerDefaultFieldTransformerFactories();
    }

    @Override
    protected void registerArgumentValueAnalyses(Ic3CommandLineArguments commandLineArguments) {
        ArgumentValueManager.v().registerDefaultArgumentValueAnalyses();
        ArgumentValueManager.v().registerArgumentValueAnalysis("classType", new ClassTypeValueAnalysis());
        ArgumentValueManager.v().registerArgumentValueAnalysis("authority", new AuthorityValueAnalysis());
        ArgumentValueManager.v().registerArgumentValueAnalysis("Set<authority>", new AuthorityValueAnalysis());
        ArgumentValueManager.v().registerArgumentValueAnalysis("path", new PathValueAnalysis());
        ArgumentValueManager.v().registerArgumentValueAnalysis("Set<path>", new PathValueAnalysis());
    }

    @Override
    protected void registerMethodReturnValueAnalyses(Ic3CommandLineArguments commandLineArguments) {
        MethodReturnValueManager.v().registerDefaultMethodReturnValueAnalyses();
    }

    @Override
    protected void initializeAnalysis(Ic3CommandLineArguments commandLineArguments) throws FatalAnalysisException {
        Map<String, Set<String>> callBackMethods;
        long startTime = System.currentTimeMillis() / 1000L;
        this.outputDir = commandLineArguments.getOutput();
        this.prepareManifestFile(commandLineArguments);
        if (commandLineArguments.getProtobufDestination() != null) {
            this.ic3Builder = Ic3Data.Application.newBuilder();
            this.ic3Builder.setAnalysisStart(startTime);
            if (commandLineArguments.getSample() != null) {
                this.ic3Builder.setSample(commandLineArguments.getSample());
            }
            this.componentNameToBuilderMap = this.detailedManifest.populateProtobuf(this.ic3Builder);
        } else if (commandLineArguments.getDb() != null) {
            SQLConnection.init(commandLineArguments.getDbName(), commandLineArguments.getDb(), commandLineArguments.getSsh(), commandLineArguments.getDbLocalPort());
            this.componentToIdMap = this.detailedManifest.writeToDb(false);
        }
        Timers.v().mainGeneration.start();
        this.setupApplication = new SetupApplication(commandLineArguments.getManifest(), commandLineArguments.getInput(), commandLineArguments.getClasspath());
        Set<String> entryPointClasses = null;
        if (this.detailedManifest == null) {
            try {
                ProcessManifest manifest = new ProcessManifest(commandLineArguments.getManifest());
                entryPointClasses = manifest.getEntryPointClasses();
                this.packageName = manifest.getPackageName();
            }
            catch (IOException | XmlPullParserException e) {
                throw new FatalAnalysisException("Could not process manifest file " + commandLineArguments.getManifest() + ": " + e);
            }
        } else {
            entryPointClasses = this.detailedManifest.getEntryPointClasses();
            this.packageName = this.detailedManifest.getPackageName();
        }
        try {
            callBackMethods = this.setupApplication.calculateSourcesSinksEntrypoints(new HashSet<AndroidMethod>(), new HashSet<AndroidMethod>(), this.packageName, entryPointClasses);
        }
        catch (IOException e) {
            this.logger.error("Could not calculate entry points", e);
            throw new FatalAnalysisException();
        }
        Timers.v().mainGeneration.end();
        Timers.v().misc.start();
        ArgumentValueManager.v().registerArgumentValueAnalysis("context", new ContextValueAnalysis(this.packageName));
        AndroidMethodReturnValueAnalyses.registerAndroidMethodReturnValueAnalyses(this.packageName);
        if (this.outputDir != null && this.packageName != null) {
            String outputFile = String.format("%s/%s.csv", this.outputDir, this.packageName);
            try {
                this.writer = new BufferedWriter(new FileWriter(outputFile, false));
            }
            catch (IOException e1) {
                this.logger.error("Could not open file " + outputFile, e1);
            }
        }
        G.reset();
        HashMap<SootMethod, Set<String>> entryPointMap = commandLineArguments.computeComponents() ? new HashMap<SootMethod, Set<String>>() : null;
        this.addSceneTransformer(entryPointMap);
        if (commandLineArguments.computeComponents()) {
            this.addEntryPointMappingSceneTransformer(entryPointClasses, callBackMethods, entryPointMap);
        }
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_output_format(12);
        Options.v().set_whole_program(true);
        Options.v().set_soot_classpath(commandLineArguments.getInput() + File.pathSeparator + commandLineArguments.getClasspath());
        Options.v().set_ignore_resolution_errors(true);
        Options.v().set_process_dir(frameworkClasses);
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().setPhaseOption("jb.ulp", "off");
        Options.v().setPhaseOption("jb.uce", "remove-unreachable-traps:true");
        Options.v().setPhaseOption("cg", "trim-clinit:false");
        Options.v().set_prepend_classpath(true);
        if (AnalysisParameters.v().useShimple()) {
            Options.v().set_via_shimple(true);
            Options.v().set_whole_shimple(true);
        }
        Options.v().set_src_prec(4);
        Timers.v().misc.end();
        Timers.v().classLoading.start();
        for (String frameworkClass : frameworkClasses) {
            SootClass c = Scene.v().loadClassAndSupport(frameworkClass);
            Scene.v().forceResolve(frameworkClass, 3);
            c.setApplicationClass();
        }
        Scene.v().loadNecessaryClasses();
        Timers.v().classLoading.end();
        Timers.v().entryPointMapping.start();
        Scene.v().setEntryPoints(Collections.singletonList(this.setupApplication.getEntryPointCreator().createDummyMain()));
        Timers.v().entryPointMapping.end();
    }

    protected void prepareManifestFile(Ic3CommandLineArguments commandLineArguments) {
        if (commandLineArguments.getDb() != null || commandLineArguments.getProtobufDestination() != null) {
            this.detailedManifest = new ManifestPullParser();
            this.detailedManifest.loadManifestFile(commandLineArguments.getManifest());
        }
    }

    @Override
    protected void setApplicationClasses(Ic3CommandLineArguments commandLineArguments) throws FatalAnalysisException {
        AnalysisParameters.v().addAnalysisClasses(this.computeAnalysisClasses(commandLineArguments.getInput()));
        AnalysisParameters.v().addAnalysisClasses(frameworkClasses);
    }

    @Override
    protected void handleFatalAnalysisException(Ic3CommandLineArguments commandLineArguments, FatalAnalysisException exception) {
        this.logger.error("Could not process application " + this.packageName, exception);
        if (this.outputDir != null && this.packageName != null) {
            try {
                if (this.writer == null) {
                    String outputFile = String.format("%s/%s.csv", this.outputDir, this.packageName);
                    this.writer = new BufferedWriter(new FileWriter(outputFile, false));
                }
                this.writer.write(commandLineArguments.getInput() + " -1\n");
                this.writer.close();
            }
            catch (IOException e1) {
                this.logger.error("Could not write to file after failure to process application", e1);
            }
        }
    }

    @Override
    protected void processResults(Ic3CommandLineArguments commandLineArguments) throws FatalAnalysisException {
        System.out.println("\n*****Manifest*****");
        System.out.println(this.detailedManifest.toString());
        if (commandLineArguments.getProtobufDestination() != null) {
            ProtobufResultProcessor resultProcessor = new ProtobufResultProcessor();
            try {
                resultProcessor.processResult(this.packageName, this.ic3Builder, commandLineArguments.getProtobufDestination(), commandLineArguments.binary(), this.componentNameToBuilderMap, AnalysisParameters.v().getAnalysisClasses().size(), this.writer);
            }
            catch (IOException e) {
                this.logger.error("Could not process analysis results", e);
                throw new FatalAnalysisException();
            }
        }
        ResultProcessor resultProcessor = new ResultProcessor();
        try {
            resultProcessor.processResult(commandLineArguments.getDb() != null, this.packageName, this.componentToIdMap, AnalysisParameters.v().getAnalysisClasses().size(), this.writer);
        }
        catch (IOException | SQLException e) {
            this.logger.error("Could not process analysis results", e);
            throw new FatalAnalysisException();
        }
    }

    @Override
    protected void finalizeAnalysis(Ic3CommandLineArguments commandLineArguments) {
    }

    protected void addSceneTransformer(Map<SootMethod, Set<String>> entryPointMap) {
        Ic3ResultBuilder resultBuilder = new Ic3ResultBuilder();
        resultBuilder.setEntryPointMap(entryPointMap);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String debugDirPath = System.getProperty("user.home") + File.separator + "debug";
        File debugDir = new File(debugDirPath);
        if (!debugDir.exists()) {
            debugDir.mkdir();
        }
        String fileName = dateFormat.format(new Date()) + ".txt";
        String debugFilename = debugDirPath + File.separator + fileName;
        String pack = AnalysisParameters.v().useShimple() ? "wstp" : "wjtp";
        Transform transform = new Transform(pack + ".ifds", new PropagationSceneTransformer(resultBuilder, new PropagationSceneTransformerFilePrinter(debugFilename, new SymbolFilter(){

            @Override
            public boolean filterOut(Value symbol2) {
                return symbol2 instanceof StaticFieldRef && ((StaticFieldRef)symbol2).getField().getDeclaringClass().getName().startsWith("android.provider");
            }
        })));
        if (PackManager.v().getPack(pack).get(pack + ".ifds") == null) {
            PackManager.v().getPack(pack).add(transform);
        } else {
            Iterator<Transform> it = PackManager.v().getPack(pack).iterator();
            while (it.hasNext()) {
                Transform current = it.next();
                if (!(current instanceof Transform) || !current.getPhaseName().equals(pack + ".ifds")) continue;
                it.remove();
                break;
            }
            PackManager.v().getPack(pack).add(transform);
        }
    }

    protected void addEntryPointMappingSceneTransformer(Set<String> entryPointClasses, Map<String, Set<String>> entryPointMapping, Map<SootMethod, Set<String>> entryPointMap) {
        String pack = AnalysisParameters.v().useShimple() ? "wstp" : "wjtp";
        Transform transform = new Transform(pack + ".epm", new EntryPointMappingSceneTransformer(entryPointClasses, entryPointMapping, entryPointMap));
        if (PackManager.v().getPack(pack).get(pack + ".epm") == null) {
            PackManager.v().getPack(pack).add(transform);
        } else {
            Iterator<Transform> it = PackManager.v().getPack(pack).iterator();
            while (it.hasNext()) {
                Transform current = it.next();
                if (!(current instanceof Transform) || !current.getPhaseName().equals(pack + ".epm")) continue;
                it.remove();
                break;
            }
            PackManager.v().getPack(pack).add(transform);
        }
    }
}

