/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.CommandLineArguments;
import org.apache.commons.cli.ParseException;

public class Ic3CommandLineArguments
extends CommandLineArguments {
    private static final String DEFAULT_SSH_PROPERTIES_PATH = "/db/ssh.properties";
    private static final String DEFAULT_DATABASE_PROPERTIES_PATH = "/db/cc.properties";
    private static final int DEFAULT_LOCAL_PORT = 3369;
    private static final String DEFAULT_COMPILED_MODEL_PATH = "/res/icc.cmodel";
    private static final String DEFAULT_DB_NAME = "cc";
    private String manifest;
    private String db;
    private String ssh;
    private String iccStudy;
    private int dbLocalPort = 3369;
    private boolean computeComponents;
    private String dbName;
    private String protobufDestination;
    private boolean binary;
    private String sample;

    public String getDbName() {
        return this.dbName != null ? this.dbName : DEFAULT_DB_NAME;
    }

    public String getManifest() {
        return this.manifest;
    }

    public String getDb() {
        return this.db;
    }

    public String getSsh() {
        return this.ssh;
    }

    public String getIccStudy() {
        return this.iccStudy;
    }

    public int getDbLocalPort() {
        return this.dbLocalPort;
    }

    public boolean computeComponents() {
        return this.computeComponents;
    }

    public String getProtobufDestination() {
        return this.protobufDestination;
    }

    public boolean binary() {
        return this.binary;
    }

    public String getSample() {
        return this.sample;
    }

    public void processCommandLineArguments() {
        this.manifest = this.getOptionValue("apkormanifest");
        if (this.getCompiledModel() == null && this.getModel() == null) {
            this.setCompiledModel(DEFAULT_COMPILED_MODEL_PATH);
        }
        this.iccStudy = this.getOptionValue("iccstudy");
        if (this.hasOption("db")) {
            this.db = this.getOptionValue("db", DEFAULT_DATABASE_PROPERTIES_PATH);
        }
        if (this.hasOption("ssh")) {
            this.ssh = this.getOptionValue("ssh", DEFAULT_SSH_PROPERTIES_PATH);
        }
        if (this.hasOption("localport")) {
            try {
                this.dbLocalPort = ((Number)this.getParsedOptionValue("localport")).intValue();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (this.hasOption("dbname")) {
            this.dbName = this.getOptionValue("dbname", DEFAULT_DB_NAME);
        }
        boolean bl = this.computeComponents = this.hasOption("computecomponents") || this.db != null;
        if (this.hasOption("protobuf")) {
            this.protobufDestination = this.getOptionValue("protobuf");
        }
        this.computeComponents = this.hasOption("computecomponents") || this.db != null || this.protobufDestination != null;
        this.binary = this.hasOption("binary");
        this.sample = this.getOptionValue("sample");
    }
}

