/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.CommandLineParser;
import edu.psu.cse.siis.ic3.Ic3CommandLineArguments;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Ic3CommandLineParser
extends CommandLineParser<Ic3CommandLineArguments> {
    private static final String COPYRIGHT = "Copyright (C) 2015 The Pennsylvania State University and the University of Wisconsin\nSystems and Internet Infrastructure Security Laboratory\n";

    @Override
    protected void parseAnalysisSpecificArguments(Options options) {
        options.addOption(Option.builder("apkormanifest").desc("Path to the manifest file or the .apk of the application.").hasArg().argName(".apk or manifest").required().build());
        options.addOption(Option.builder("db").desc("Store entry points to database.").hasArg().optionalArg(true).argName("DB properties file").build());
        options.addOption(Option.builder("ssh").desc("Use SSH to connect to the database.").hasArg().optionalArg(true).argName("SSH properties file").build());
        options.addOption(Option.builder("localport").desc("Local DB port to connect to.").hasArg().type(Number.class).argName("local DB port").build());
        options.addOption(Option.builder("protobuf").desc("Destination path for the results.").hasArg().argName("destination path").build());
        options.addOption(Option.builder("sample").desc("Specify a sample name.").hasArg().argName("sample name").build());
        options.addOption(Option.builder("dbname").desc("DB name to connect to.").hasArg().type(Number.class).argName("DB name").build());
        options.addOption("computecomponents", false, "Compute which components each exit point belongs to.");
        options.addOption("binary", false, "Output a binary protobuf.");
    }

    @Override
    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        System.out.println(COPYRIGHT);
        formatter.printHelp("ic3 -input <Android directory> -classpath <classpath> -apk <path to application .apk> [-computecomponents] [-db <path to DB properties file>] [-ssh <path to SSH properties file>] [-localport <DB local port>] [-modeledtypesonly] [-output <output directory>] [-protobuf <destination path>] [-binary] [-sample <sample name>] [-threadcount <thread count>]", options);
    }
}

