/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.Result;
import edu.psu.cse.siis.coal.arguments.Argument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;

public class Ic3Result
extends Result {
    private final Map<SootMethod, Set<String>> entryPointMap;
    private final Map<Unit, Map<Integer, Object>> result = new HashMap<Unit, Map<Integer, Object>>();
    private String statistics;

    public Ic3Result(Map<SootMethod, Set<String>> entryPointMap) {
        this.entryPointMap = entryPointMap;
    }

    @Override
    public Map<Unit, Map<Integer, Object>> getResults() {
        return this.result;
    }

    @Override
    public Object getResult(Unit unit, Argument argument) {
        Map<Integer, Object> unitResult = this.result.get(unit);
        if (unitResult != null) {
            return unitResult.get(argument.getArgnum());
        }
        return null;
    }

    @Override
    public String getStatistics() {
        return this.statistics;
    }

    public Map<SootMethod, Set<String>> getEntryPointMap() {
        return this.entryPointMap;
    }

    @Override
    public void addResult(Unit unit, int argnum, Object value) {
        Map<Integer, Object> unitResult = this.result.get(unit);
        if (unitResult == null) {
            unitResult = new HashMap<Integer, Object>();
            this.result.put(unit, unitResult);
        }
        unitResult.put(argnum, value);
    }

    @Override
    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public void dump() {
        System.out.println("*****Result*****");
        ArrayList<String> results = new ArrayList<String>();
        boolean outputComponents = this.entryPointMap != null;
        for (Map.Entry<Unit, Map<Integer, Object>> entry : this.result.entrySet()) {
            Unit unit = entry.getKey();
            SootMethod method = AnalysisParameters.v().getIcfg().getMethodOf(unit);
            String current = method.getDeclaringClass().getName() + "/" + method.getSubSignature() + " : " + unit + "\n";
            if (outputComponents) {
                Set<String> components = this.entryPointMap.get(method);
                current = components != null ? current + "Components: " + components + "\n" : current + "Unknown components\n";
            }
            for (Map.Entry<Integer, Object> entry2 : entry.getValue().entrySet()) {
                current = current + "    " + entry2.getKey() + " : " + entry2.getValue() + "\n";
            }
            results.add(current);
        }
        Collections.sort(results);
        for (String result : results) {
            System.out.println(result);
        }
    }
}

