/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.PropagationTimers;
import edu.psu.cse.siis.coal.Result;
import edu.psu.cse.siis.coal.ResultBuilder;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import edu.psu.cse.siis.coal.values.PropagationValue;
import edu.psu.cse.siis.ic3.Ic3Result;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.queue.QueueReader;

public class Ic3ResultBuilder
implements ResultBuilder {
    private Map<SootMethod, Set<String>> entryPointMap;

    public void setEntryPointMap(Map<SootMethod, Set<String>> entryPointMap) {
        this.entryPointMap = entryPointMap;
    }

    @Override
    public Result buildResult(PropagationSolver solver) {
        PropagationTimers.v().resultGeneration.start();
        Ic3Result result = new Ic3Result(this.entryPointMap);
        ArrayList<SootMethod> eps = new ArrayList<SootMethod>(Scene.v().getEntryPoints());
        ReachableMethods reachableMethods = new ReachableMethods(Scene.v().getCallGraph(), eps.iterator(), null);
        reachableMethods.update();
        long reachableStatements = 0L;
        QueueReader<MethodOrMethodContext> iter = reachableMethods.listener();
        while (iter.hasNext()) {
            SootMethod method = ((MethodOrMethodContext)iter.next()).method();
            if (!(!method.hasActiveBody() || Model.v().isExcludedClass(method.getDeclaringClass().getName()) || method.getDeclaringClass().getName().equals("dummyMainClass") || method.getDeclaringClass().getName().startsWith("android.support") || method.getDeclaringClass().getName().startsWith("android.provider"))) {
                ++PropagationTimers.v().reachableMethods;
                ExceptionalUnitGraph cfg = new ExceptionalUnitGraph(method.getActiveBody());
                Stack<Unit> stack = new Stack<Unit>();
                for (Unit unit : cfg.getHeads()) {
                    stack.push(unit);
                }
                HashSet<Unit> visited = new HashSet<Unit>();
                while (!stack.empty()) {
                    Unit unit;
                    unit = (Unit)stack.pop();
                    if (visited.contains(unit)) continue;
                    visited.add(unit);
                    for (Unit successor : cfg.getSuccsOf(unit)) {
                        stack.push(successor);
                    }
                    Argument[] arguments = Model.v().getArgumentsForQuery((Stmt)unit);
                    if (arguments == null) continue;
                    boolean foundModeledType = false;
                    for (Argument argument : arguments) {
                        if (!Model.v().isModeledType(argument.getType())) continue;
                        foundModeledType = true;
                        break;
                    }
                    Stmt stmt = (Stmt)unit;
                    for (Argument argument : arguments) {
                        if (Model.v().isModeledType(argument.getType())) {
                            BasePropagationValue basePropagationValue;
                            int argnum = argument.getArgnum()[0];
                            InvokeExpr invokeExpr = stmt.getInvokeExpr();
                            if (argnum >= 0) {
                                basePropagationValue = (BasePropagationValue)solver.resultAt(unit, invokeExpr.getArg(argnum));
                            } else if (invokeExpr instanceof InstanceInvokeExpr && argnum == -1) {
                                InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
                                basePropagationValue = (BasePropagationValue)solver.resultAt(stmt, instanceInvokeExpr.getBase());
                            } else {
                                throw new RuntimeException("Unexpected argument number " + argnum + " for invoke expression " + invokeExpr);
                            }
                            if (basePropagationValue instanceof PropagationValue) {
                                PropagationValue propagationValue = (PropagationValue)basePropagationValue;
                                PropagationTimers.v().resultGeneration.end();
                                PropagationTimers.v().valueComposition.start();
                                propagationValue.makeFinalValue(solver);
                                PropagationTimers.v().valueComposition.end();
                                PropagationTimers.v().resultGeneration.start();
                                ((Result)result).addResult(unit, argument.getArgnum()[0], propagationValue);
                                continue;
                            }
                            ((Result)result).addResult(unit, argument.getArgnum()[0], basePropagationValue);
                            continue;
                        }
                        if (!foundModeledType && !AnalysisParameters.v().inferNonModeledTypes()) continue;
                        ((Result)result).addResult(unit, argument.getArgnum()[0], ArgumentValueManager.v().getArgumentValues(argument, unit));
                    }
                }
                reachableStatements += (long)visited.size();
            }
            PropagationTimers.v().reachableStatements += reachableStatements;
        }
        PropagationTimers.v().resultGeneration.end();
        return result;
    }
}

