/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.arguments.ArgumentValueAnalysis;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;

public class PathValueAnalysis
extends ArgumentValueAnalysis {
    private static final String TOP_VALUE = "(.*)";
    private static final int PATTERN_LITERAL = 0;
    private static final int PATTERN_PREFIX = 1;
    private static final int PATTERN_SIMPLE_GLOB = 2;

    @Override
    public Set<Object> computeArgumentValues(Argument argument, Unit callSite) {
        Argument argument0 = new Argument(argument);
        argument0.setArgnum(new int[]{argument.getArgnum()[0]});
        argument0.setType("String");
        Argument argument1 = new Argument(argument);
        argument1.setArgnum(new int[]{argument.getArgnum()[1]});
        argument1.setType("int");
        Set<Object> paths = ArgumentValueManager.v().getArgumentValues(argument0, callSite);
        Set<Object> types = ArgumentValueManager.v().getArgumentValues(argument1, callSite);
        HashSet<Object> result = new HashSet<Object>();
        for (Object path : paths) {
            for (Object type : types) {
                result.add(this.computePathForType((String)path, (Integer)type));
            }
        }
        return result;
    }

    private String computePathForType(String path, int type) {
        if (type == 0 || type == 2) {
            return path;
        }
        if (type == 1 || type == -1) {
            if (path.equals(TOP_VALUE)) {
                return TOP_VALUE;
            }
            return String.format("%s(.*)", path);
        }
        throw new RuntimeException("Unknown path type: " + type);
    }

    @Override
    public Set<Object> computeInlineArgumentValues(String[] inlineValue) {
        return new HashSet<Object>(Arrays.asList(inlineValue));
    }

    @Override
    public Object getTopValue() {
        return TOP_VALUE;
    }

    @Override
    public Set<Object> computeVariableValues(Value value, Stmt callSite) {
        throw new RuntimeException("Should not be reached.");
    }
}

