/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import com.google.protobuf.TextFormat;
import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.PropagationTimers;
import edu.psu.cse.siis.coal.Result;
import edu.psu.cse.siis.coal.Results;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.field.values.FieldValue;
import edu.psu.cse.siis.coal.field.values.ScalarFieldValue;
import edu.psu.cse.siis.coal.field.values.TopFieldValue;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import edu.psu.cse.siis.coal.values.BottomPropagationValue;
import edu.psu.cse.siis.coal.values.PathValue;
import edu.psu.cse.siis.coal.values.PropagationValue;
import edu.psu.cse.siis.coal.values.TopPropagationValue;
import edu.psu.cse.siis.ic3.DataAuthority;
import edu.psu.cse.siis.ic3.Ic3Data;
import edu.psu.cse.siis.ic3.Ic3Result;
import edu.psu.cse.siis.ic3.Timers;
import edu.psu.cse.siis.ic3.manifest.ManifestComponent;
import edu.psu.cse.siis.ic3.manifest.ManifestData;
import edu.psu.cse.siis.ic3.manifest.ManifestIntentFilter;
import edu.psu.cse.siis.ic3.manifest.ManifestPullParser;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class ProtobufResultProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ENTRY_POINT_INTENT = "<INTENT>";
    private final int[] preciseNonLinking = new int[]{0, 0, 0, 0};
    private final int[] preciseLinking = new int[]{0, 0, 0, 0};
    private final int[] imprecise = new int[]{0, 0, 0, 0, 0};
    private final int[] top = new int[]{0, 0, 0};
    private final int[] bottom = new int[]{0, 0, 0};
    private final int[] nonexistent = new int[]{0, 0, 0};
    private final int[] preciseFieldValueCount = new int[]{0, 0, 0};
    private final int[] partiallyPreciseFieldValueCount = new int[]{0, 0, 0};
    private final int[] impreciseFieldValueCount = new int[]{0, 0, 0};
    private int intentWithData = 0;
    private int providerArgument = 0;

    public void processResult(String appName, Ic3Data.Application.Builder ic3Builder, String protobufDestination, boolean binary, Map<String, Ic3Data.Application.Component.Builder> componentNameToBuilderMap, int analysisClassesCount, Writer writer) throws IOException {
        for (Result result : Results.getResults()) {
            ((Ic3Result)result).dump();
            this.analyzeResult(result);
            this.writeResultToProtobuf(result, ic3Builder, componentNameToBuilderMap);
        }
        ic3Builder.setAnalysisEnd(System.currentTimeMillis() / 1000L);
        String extension = binary ? "dat" : "txt";
        String path = String.format("%s/%s_%s.%s", protobufDestination, ic3Builder.getName(), ic3Builder.getVersion(), extension);
        System.out.println("PATH: " + path);
        if (binary) {
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            ic3Builder.build().writeTo(fileOutputStream);
            fileOutputStream.close();
        } else {
            FileWriter fileWriter = new FileWriter(path);
            TextFormat.print(ic3Builder, (Appendable)fileWriter);
            fileWriter.close();
        }
        Timers.v().totalTimer.end();
        String statistics = appName + " " + analysisClassesCount + " " + PropagationTimers.v().reachableMethods + " " + this.preciseNonLinking[0] + " " + this.preciseNonLinking[3] + " " + this.preciseNonLinking[1] + " " + this.preciseNonLinking[2] + " " + this.preciseLinking[0] + " " + this.preciseLinking[3] + " " + this.preciseLinking[1] + " " + this.preciseLinking[2] + " " + this.imprecise[0] + " " + this.imprecise[3] + " " + this.imprecise[1] + " " + this.imprecise[2] + " " + this.bottom[0] + " " + this.bottom[1] + " " + this.bottom[2] + " " + this.top[0] + " " + this.top[1] + " " + this.top[2] + " " + this.nonexistent[0] + " " + this.nonexistent[1] + " " + this.nonexistent[2] + " " + this.providerArgument + " " + this.imprecise[4] + " " + this.preciseFieldValueCount[0] + " " + this.preciseFieldValueCount[1] + " " + this.preciseFieldValueCount[2] + " " + this.partiallyPreciseFieldValueCount[0] + " " + this.partiallyPreciseFieldValueCount[1] + " " + this.partiallyPreciseFieldValueCount[2] + " " + this.impreciseFieldValueCount[0] + " " + this.impreciseFieldValueCount[1] + " " + this.impreciseFieldValueCount[2] + " " + PropagationTimers.v().modelParsing.getTime() + " " + Timers.v().mainGeneration.getTime() + " " + Timers.v().entryPointMapping.getTime() + " " + Timers.v().classLoading.getTime() + " " + PropagationTimers.v().problemGeneration.getTime() + " " + PropagationTimers.v().ideSolution.getTime() + " " + PropagationTimers.v().valueComposition.getTime() + " " + PropagationTimers.v().resultGeneration.getTime() + " " + (PropagationTimers.v().soot.getTime() - PropagationTimers.v().totalTimer.getTime()) + " " + (Timers.v().misc.getTime() + PropagationTimers.v().misc.getTime()) + " " + Timers.v().totalTimer.getTime() + "\n";
        if (this.logger.isInfoEnabled()) {
            this.logger.info(statistics);
        }
        if (writer != null) {
            writer.write(statistics);
            writer.close();
        }
    }

    private void writeResultToProtobuf(Result result, Ic3Data.Application.Builder ic3Builder, Map<String, Ic3Data.Application.Component.Builder> componentNameToBuilderMap) {
        HashMap componentToExtrasMap = new HashMap();
        HashMap<String, ManifestComponent> dynamicReceivers = new HashMap<String, ManifestComponent>();
        Map<SootMethod, Set<String>> entryPointMap = ((Ic3Result)result).getEntryPointMap();
        for (Map.Entry<Unit, Map<Integer, Object>> entry : result.getResults().entrySet()) {
            Set extras;
            Unit unit = entry.getKey();
            Argument[] arguments = Model.v().getArgumentsForQuery((Stmt)unit);
            if (arguments == null) continue;
            SootMethod method = AnalysisParameters.v().getIcfg().getMethodOf(unit);
            Ic3Data.Application.Component.Instruction.Builder instructionBuilder = this.unitToInstructionBuilder(method, unit);
            HashMap<String, Object> valueMap = new HashMap<String, Object>(arguments.length);
            Map<Integer, Object> argnumToValueMap = entry.getValue();
            for (Argument argument : arguments) {
                valueMap.put(argument.getProperty("valueType"), argnumToValueMap.get(argument.getArgnum()[0]));
            }
            if (valueMap.containsKey("activity")) {
                this.insertProtobufExitPoint(instructionBuilder, (BasePropagationValue)valueMap.get("activity"), Ic3Data.Application.Component.ComponentKind.ACTIVITY, null, null, entryPointMap.get(method), componentNameToBuilderMap);
                continue;
            }
            if (valueMap.containsKey("service")) {
                this.insertProtobufExitPoint(instructionBuilder, (BasePropagationValue)valueMap.get("service"), Ic3Data.Application.Component.ComponentKind.SERVICE, null, null, entryPointMap.get(method), componentNameToBuilderMap);
                continue;
            }
            if (valueMap.containsKey("receiver")) {
                this.insertProtobufExitPoint(instructionBuilder, (BasePropagationValue)valueMap.get("receiver"), Ic3Data.Application.Component.ComponentKind.RECEIVER, (Set)valueMap.get("permission"), null, entryPointMap.get(method), componentNameToBuilderMap);
                continue;
            }
            if (valueMap.containsKey("intentFilter")) {
                this.insertDynamicReceiver(dynamicReceivers, (Set)valueMap.get("permission"), (Set)valueMap.get("receiverType"), (BasePropagationValue)valueMap.get("intentFilter"), method, unit);
                continue;
            }
            if (valueMap.containsKey("provider")) {
                this.insertProtobufExitPoint(instructionBuilder, (BasePropagationValue)valueMap.get("provider"), Ic3Data.Application.Component.ComponentKind.PROVIDER, null, null, entryPointMap.get(method), componentNameToBuilderMap);
                continue;
            }
            if (valueMap.containsKey("authority")) {
                this.insertProtobufExitPoint(instructionBuilder, this.getUriValueForAuthorities((Set)valueMap.get("authority")), Ic3Data.Application.Component.ComponentKind.PROVIDER, null, null, entryPointMap.get(method), componentNameToBuilderMap);
                continue;
            }
            if (valueMap.containsKey("pendingIntent")) {
                BasePropagationValue baseCollectingValue = (BasePropagationValue)valueMap.get("pendingIntent");
                String targetType = baseCollectingValue instanceof PropagationValue ? (String)((PropagationValue)baseCollectingValue).getValuesForField("targetType").iterator().next().getValue() : null;
                Set permissions = (Set)valueMap.get("permission");
                if (targetType != null) {
                    this.insertProtobufExitPoint(instructionBuilder, baseCollectingValue, this.stringToComponentKind(targetType), permissions, null, entryPointMap.get(method), componentNameToBuilderMap);
                    continue;
                }
                for (Ic3Data.Application.Component.ComponentKind target : Arrays.asList(Ic3Data.Application.Component.ComponentKind.ACTIVITY, Ic3Data.Application.Component.ComponentKind.RECEIVER, Ic3Data.Application.Component.ComponentKind.SERVICE)) {
                    this.insertProtobufExitPoint(instructionBuilder, baseCollectingValue, target, null, null, entryPointMap.get(method), componentNameToBuilderMap);
                }
                continue;
            }
            if (!valueMap.containsKey("componentExtra") || (extras = (Set)valueMap.get("componentExtra")) == null) continue;
            for (String component : entryPointMap.get(method)) {
                HashSet<Ic3Data.Application.Component.Extra> existingExtras = (HashSet<Ic3Data.Application.Component.Extra>)componentToExtrasMap.get(component);
                if (existingExtras == null) {
                    existingExtras = new HashSet<Ic3Data.Application.Component.Extra>();
                    componentToExtrasMap.put(component, existingExtras);
                }
                for (String extra : extras) {
                    Ic3Data.Application.Component.Extra.Builder extraBuilder = Ic3Data.Application.Component.Extra.newBuilder();
                    extraBuilder.setExtra(extra);
                    extraBuilder.setInstruction(instructionBuilder);
                    existingExtras.add(extraBuilder.build());
                }
            }
        }
        for (Map.Entry<Unit, Map<Integer, Object>> entry : componentToExtrasMap.entrySet()) {
            componentNameToBuilderMap.get(entry.getKey()).addAllExtras((Iterable)((Object)entry.getValue()));
        }
        for (Ic3Data.Application.Component.Builder builder : componentNameToBuilderMap.values()) {
            ic3Builder.addComponents(builder);
        }
        for (ManifestComponent manifestComponent : dynamicReceivers.values()) {
            Ic3Data.Application.Component.Builder componentBuilder = ManifestPullParser.makeProtobufComponentBuilder(manifestComponent, Ic3Data.Application.Component.ComponentKind.DYNAMIC_RECEIVER);
            componentBuilder.setRegistrationInstruction(this.unitToInstructionBuilder(manifestComponent.getRegistrationMethod(), manifestComponent.getRegistrationUnit()));
            ic3Builder.addComponents(componentBuilder);
        }
    }

    private Ic3Data.Application.Component.Instruction.Builder unitToInstructionBuilder(SootMethod method, Unit unit) {
        Ic3Data.Application.Component.Instruction.Builder builder = Ic3Data.Application.Component.Instruction.newBuilder();
        builder.setClassName(method.getDeclaringClass().getName());
        builder.setMethod(method.getSignature());
        builder.setStatement(unit.toString());
        builder.setId(this.getIdForUnit(unit, method));
        return builder;
    }

    private void insertProtobufExitPoint(Ic3Data.Application.Component.Instruction.Builder instructionBuilder, BasePropagationValue intentValue, Ic3Data.Application.Component.ComponentKind componentKind, Set<String> intentPermissions, Integer missingIntents, Set<String> exitPointComponents, Map<String, Ic3Data.Application.Component.Builder> componentNameToBuilderMap) {
        for (String exitPointComponent : exitPointComponents) {
            Ic3Data.Application.Component.ExitPoint.Builder exitPointBuilder = Ic3Data.Application.Component.ExitPoint.newBuilder();
            exitPointBuilder.setInstruction(instructionBuilder).setKind(componentKind);
            PropagationValue collectingValue = null;
            if (intentValue == null || intentValue instanceof TopPropagationValue || intentValue instanceof BottomPropagationValue) {
                missingIntents = 0;
            } else if (intentValue instanceof PropagationValue) {
                collectingValue = (PropagationValue)intentValue;
                if (collectingValue.getPathValues() == null || collectingValue.getPathValues().size() == 0) {
                    missingIntents = 0;
                }
            } else {
                throw new RuntimeException("Unknown CollectingValue type: " + intentValue.getClass());
            }
            if (missingIntents != null) {
                exitPointBuilder.setMissing(missingIntents);
            } else {
                Set<PathValue> pathValues = collectingValue.getPathValues();
                if (pathValues != null) {
                    for (PathValue pathValue : pathValues) {
                        if (componentKind.equals(Ic3Data.Application.Component.ComponentKind.PROVIDER)) {
                            exitPointBuilder.addUris(this.makeProtobufUriBuilder(pathValue));
                            continue;
                        }
                        if (intentPermissions != null && intentPermissions.size() != 0) {
                            for (String intentPermission : intentPermissions) {
                                exitPointBuilder.addIntents(this.makeProtobufIntentBuilder(pathValue).setPermission(intentPermission));
                            }
                            continue;
                        }
                        exitPointBuilder.addIntents(this.makeProtobufIntentBuilder(pathValue));
                    }
                }
            }
            Ic3Data.Application.Component.Builder componentBuilder = componentNameToBuilderMap.get(exitPointComponent);
            componentBuilder.addExitPoints(exitPointBuilder);
        }
    }

    private Ic3Data.Application.Component.ExitPoint.Intent.Builder makeProtobufIntentBuilder(PathValue intentValue) {
        Set<Integer> flags;
        Ic3Data.Application.Component.ExitPoint.Intent.Builder intentBuilder = Ic3Data.Application.Component.ExitPoint.Intent.newBuilder();
        this.insertSingleValuedIntentAttribute(intentValue, "action", Ic3Data.AttributeKind.ACTION, intentBuilder);
        Set<String> categories = intentValue.getSetStringFieldValue("categories");
        if (categories != null) {
            if (categories.contains(null)) {
                categories.remove(null);
                categories.add("NULL-CONSTANT");
            }
            intentBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.CATEGORY).addAllValue(categories));
        }
        if ((flags = intentValue.getSetFieldValue("flags", Integer.class)) != null) {
            intentBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.FLAG).addAllIntValue(flags));
        }
        this.insertSingleValuedIntentAttribute(intentValue, "dataType", Ic3Data.AttributeKind.TYPE, intentBuilder);
        Set<String> extras = intentValue.getSetStringFieldValue("extras");
        if (extras != null) {
            if (extras.contains(null)) {
                extras.remove(null);
                extras.add("NULL-CONSTANT");
            }
            intentBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.EXTRA).addAllValue(extras));
        }
        this.insertSingleValuedIntentAttribute(intentValue, "clazz", Ic3Data.AttributeKind.CLASS, intentBuilder);
        this.insertSingleValuedIntentAttribute(intentValue, "package", Ic3Data.AttributeKind.PACKAGE, intentBuilder);
        this.insertSingleValuedIntentAttribute(intentValue, "scheme", Ic3Data.AttributeKind.SCHEME, intentBuilder);
        this.insertSingleValuedIntentAttribute(intentValue, "ssp", Ic3Data.AttributeKind.SSP, intentBuilder);
        this.insertSingleValuedIntentAttribute(intentValue, "uri", Ic3Data.AttributeKind.URI, intentBuilder);
        this.insertSingleValuedIntentAttribute(intentValue, "path", Ic3Data.AttributeKind.PATH, intentBuilder);
        this.insertSingleValuedIntentAttribute(intentValue, "query", Ic3Data.AttributeKind.QUERY, intentBuilder);
        this.insertSingleValuedIntentAttribute(intentValue, "authority", Ic3Data.AttributeKind.AUTHORITY, intentBuilder);
        return intentBuilder;
    }

    private void insertSingleValuedIntentAttribute(PathValue pathValue, String attribute, Ic3Data.AttributeKind kind, Ic3Data.Application.Component.ExitPoint.Intent.Builder intentBuilder) {
        String attributeValue = pathValue.getScalarStringFieldValue(attribute);
        if (attributeValue != null) {
            intentBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(kind).addValue(attributeValue));
        }
    }

    private Ic3Data.Application.Component.ExitPoint.Uri.Builder makeProtobufUriBuilder(PathValue uriValue) {
        Ic3Data.Application.Component.ExitPoint.Uri.Builder uriBuilder = Ic3Data.Application.Component.ExitPoint.Uri.newBuilder();
        this.insertSingleValuedUriAttribute(uriValue, "scheme", Ic3Data.AttributeKind.SCHEME, uriBuilder);
        this.insertSingleValuedUriAttribute(uriValue, "ssp", Ic3Data.AttributeKind.SSP, uriBuilder);
        this.insertSingleValuedUriAttribute(uriValue, "uri", Ic3Data.AttributeKind.URI, uriBuilder);
        this.insertSingleValuedUriAttribute(uriValue, "path", Ic3Data.AttributeKind.PATH, uriBuilder);
        this.insertSingleValuedUriAttribute(uriValue, "query", Ic3Data.AttributeKind.QUERY, uriBuilder);
        this.insertSingleValuedUriAttribute(uriValue, "authority", Ic3Data.AttributeKind.AUTHORITY, uriBuilder);
        return uriBuilder;
    }

    private void insertSingleValuedUriAttribute(PathValue pathValue, String attribute, Ic3Data.AttributeKind kind, Ic3Data.Application.Component.ExitPoint.Uri.Builder uriBuilder) {
        String attributeValue = pathValue.getScalarStringFieldValue(attribute);
        if (attributeValue != null) {
            uriBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(kind).addValue(attributeValue));
        }
    }

    private Ic3Data.Application.Component.ComponentKind stringToComponentKind(String componentKind) {
        switch (componentKind) {
            case "a": {
                return Ic3Data.Application.Component.ComponentKind.ACTIVITY;
            }
            case "s": {
                return Ic3Data.Application.Component.ComponentKind.SERVICE;
            }
            case "r": {
                return Ic3Data.Application.Component.ComponentKind.RECEIVER;
            }
        }
        throw new RuntimeException("Unknown component kind: " + componentKind);
    }

    private void insertDynamicReceiver(Map<String, ManifestComponent> dynamicReceivers, Set<String> permissions, Set<String> receiverTypes, BasePropagationValue intentFilters, SootMethod method, Unit unit) {
        if (permissions == null) {
            permissions = Collections.singleton(null);
        }
        for (String receiverType : receiverTypes) {
            for (String permission : permissions) {
                this.insertDynamicReceiverHelper(dynamicReceivers, permission, receiverType, intentFilters, method, unit);
            }
        }
    }

    private void insertDynamicReceiverHelper(Map<String, ManifestComponent> dynamicReceivers, String permission, String receiverType, BasePropagationValue intentFilters, SootMethod method, Unit unit) {
        HashSet<ManifestIntentFilter> manifestIntentFilters;
        Integer missingIntentFilters;
        if (intentFilters == null || intentFilters instanceof TopPropagationValue || intentFilters instanceof BottomPropagationValue) {
            missingIntentFilters = 0;
            manifestIntentFilters = null;
        } else if (intentFilters instanceof PropagationValue) {
            missingIntentFilters = null;
            PropagationValue collectingValue = (PropagationValue)intentFilters;
            manifestIntentFilters = new HashSet<ManifestIntentFilter>();
            for (PathValue branchValue : collectingValue.getPathValues()) {
                Integer filterPriority = null;
                FieldValue priorityFieldValue = branchValue.getFieldValue("priority");
                if (priorityFieldValue != null) {
                    filterPriority = (Integer)priorityFieldValue.getValue();
                }
                manifestIntentFilters.add(new ManifestIntentFilter(branchValue.getSetStringFieldValue("actions"), branchValue.getSetStringFieldValue("categories"), false, this.makeManifestData(branchValue), filterPriority));
            }
        } else {
            throw new RuntimeException("Unknown intent filter type: " + intentFilters.getClass());
        }
        ManifestComponent manifestComponent = dynamicReceivers.get(receiverType);
        if (manifestComponent == null) {
            manifestComponent = new ManifestComponent("d", receiverType, true, true, permission, null, missingIntentFilters, method, unit);
            dynamicReceivers.put(receiverType, manifestComponent);
        }
        manifestComponent.addIntentFilters(manifestIntentFilters);
    }

    private List<ManifestData> makeManifestData(PathValue branchValue) {
        Set<String> mimeTypes = branchValue.getSetStringFieldValue("dataType");
        Set<DataAuthority> authorities = branchValue.getSetFieldValue("authorities", DataAuthority.class);
        Set<String> paths = branchValue.getSetStringFieldValue("paths");
        Set<String> schemes = branchValue.getSetStringFieldValue("schemes");
        if (mimeTypes == null && authorities == null && paths == null && schemes == null) {
            return null;
        }
        if (mimeTypes == null) {
            mimeTypes = Collections.singleton(null);
        }
        if (authorities == null) {
            authorities = Collections.singleton(new DataAuthority(null, null));
        }
        if (paths == null) {
            paths = Collections.singleton(null);
        }
        if (schemes == null) {
            schemes = Collections.singleton(null);
        }
        ArrayList<ManifestData> result = new ArrayList<ManifestData>();
        for (String mimeType : mimeTypes) {
            for (DataAuthority dataAuthority : authorities) {
                for (String dataPath : paths) {
                    for (String scheme : schemes) {
                        result.add(new ManifestData(scheme, dataAuthority.getHost(), dataAuthority.getPort(), dataPath, mimeType));
                    }
                }
            }
        }
        return result;
    }

    private BasePropagationValue getUriValueForAuthorities(Set<String> authorities) {
        if (authorities == null) {
            return null;
        }
        PropagationValue collectingValue = new PropagationValue();
        for (String authority : authorities) {
            PathValue branchValue = new PathValue();
            ScalarFieldValue schemeFieldValue = new ScalarFieldValue("content");
            branchValue.addFieldEntry("scheme", schemeFieldValue);
            ScalarFieldValue authorityFieldValue = new ScalarFieldValue(authority);
            branchValue.addFieldEntry("authority", authorityFieldValue);
            collectingValue.addPathValue(branchValue);
        }
        return collectingValue;
    }

    private int getIdForUnit(Unit unit, SootMethod method) {
        int id = 0;
        for (Unit currentUnit : method.getActiveBody().getUnits()) {
            if (currentUnit == unit) {
                return id;
            }
            ++id;
        }
        return -1;
    }

    private void analyzeResult(Result result) {
        HashSet<String> nonLinkingFieldNames = new HashSet<String>();
        nonLinkingFieldNames.add("extras");
        nonLinkingFieldNames.add("flags");
        nonLinkingFieldNames.add("fragment");
        nonLinkingFieldNames.add("query");
        for (Map.Entry<Unit, Map<Integer, Object>> entry0 : result.getResults().entrySet()) {
            Collection<Object> argumentValues = entry0.getValue().values();
            boolean top = false;
            boolean bottom = false;
            boolean preciseLinking = true;
            boolean preciseNonLinking = true;
            boolean nonexistent = false;
            boolean intentWithUri = false;
            boolean entryPointIntent = false;
            int resultIndex = this.getResultIndex((Stmt)entry0.getKey());
            for (Object value2 : argumentValues) {
                if (value2 == null) {
                    nonexistent = true;
                    continue;
                }
                if (value2 instanceof TopPropagationValue) {
                    top = true;
                    continue;
                }
                if (value2 instanceof BottomPropagationValue) {
                    bottom = true;
                    continue;
                }
                if (!(value2 instanceof PropagationValue)) continue;
                PropagationValue collectingValue = (PropagationValue)value2;
                for (PathValue branchValue : collectingValue.getPathValues()) {
                    intentWithUri = intentWithUri || this.isIntentWithUri(branchValue.getFieldMap());
                    for (Map.Entry<String, FieldValue> entry : branchValue.getFieldMap().entrySet()) {
                        String fieldName = entry.getKey();
                        FieldValue fieldValue = entry.getValue();
                        if (fieldValue instanceof TopFieldValue) {
                            if (nonLinkingFieldNames.contains(fieldName)) {
                                preciseNonLinking = false;
                                continue;
                            }
                            preciseNonLinking = false;
                            preciseLinking = false;
                            continue;
                        }
                        Object value = fieldValue.getValue();
                        if (value == null) continue;
                        if (value instanceof Set) {
                            Set values = (Set)value;
                            if (!values.contains("(.*)") && !values.contains("(.*)") && !values.contains(-1) && !values.contains(ENTRY_POINT_INTENT) && !values.contains("top")) continue;
                            if (values.contains(ENTRY_POINT_INTENT)) {
                                entryPointIntent = true;
                            }
                            preciseNonLinking = false;
                            if (nonLinkingFieldNames.contains(fieldName)) continue;
                            preciseLinking = false;
                            continue;
                        }
                        if (!value.equals("(.*)") && !value.equals("(.*)") && !value.equals(-1) && !value.equals(ENTRY_POINT_INTENT) && !value.equals("top")) continue;
                        if (value.equals(ENTRY_POINT_INTENT)) {
                            entryPointIntent = true;
                        }
                        preciseNonLinking = false;
                        if (nonLinkingFieldNames.contains(fieldName)) continue;
                        preciseLinking = false;
                    }
                }
            }
            if (intentWithUri) {
                ++this.intentWithData;
            }
            if (nonexistent) {
                if (Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(AnalysisParameters.v().getIcfg().getMethodOf(entry0.getKey()).getDeclaringClass(), Scene.v().getSootClass("android.content.ContentProvider"))) {
                    ++this.providerArgument;
                    continue;
                }
                int n = resultIndex;
                this.nonexistent[n] = this.nonexistent[n] + 1;
                continue;
            }
            if (top) {
                int n = resultIndex;
                this.top[n] = this.top[n] + 1;
                continue;
            }
            if (bottom) {
                int n = resultIndex;
                this.bottom[n] = this.bottom[n] + 1;
                continue;
            }
            if (preciseNonLinking) {
                if (intentWithUri) {
                    this.preciseNonLinking[3] = this.preciseNonLinking[3] + 1;
                    continue;
                }
                int n = resultIndex;
                this.preciseNonLinking[n] = this.preciseNonLinking[n] + 1;
                continue;
            }
            if (preciseLinking) {
                if (intentWithUri) {
                    this.preciseLinking[3] = this.preciseLinking[3] + 1;
                    continue;
                }
                int n = resultIndex;
                this.preciseLinking[n] = this.preciseLinking[n] + 1;
                continue;
            }
            if (entryPointIntent) {
                this.imprecise[4] = this.imprecise[4] + 1;
                continue;
            }
            if (intentWithUri) {
                this.imprecise[3] = this.imprecise[3] + 1;
                continue;
            }
            int n = resultIndex;
            this.imprecise[n] = this.imprecise[n] + 1;
        }
    }

    private boolean isIntentWithUri(Map<String, FieldValue> fieldMap) {
        Set<String> fields = fieldMap.keySet();
        return (fields.contains("action") || fields.contains("categories")) && (fields.contains("uri") && fieldMap.get("uri") != null && fieldMap.get("uri").getValue() != null || fields.contains("path") && fieldMap.get("path") != null && fieldMap.get("path").getValue() != null || fields.contains("scheme") && fieldMap.get("scheme") != null && fieldMap.get("scheme").getValue() != null || fields.contains("ssp") && fieldMap.get("ssp") != null && fieldMap.get("ssp").getValue() != null);
    }

    private int getResultIndex(Stmt stmt) {
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        List<Type> types = invokeExpr.getMethod().getParameterTypes();
        for (Type type : types) {
            if (type.toString().equals("android.content.IntentFilter")) {
                return 1;
            }
            if (!type.toString().equals("android.net.Uri")) continue;
            return 2;
        }
        return 0;
    }

    private boolean containsPartialDefinition(Set<Object> values) {
        for (Object value : values) {
            if (!(value instanceof String) || !((String)value).contains("(.*)")) continue;
            return true;
        }
        return false;
    }
}

