/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.PropagationTimers;
import edu.psu.cse.siis.coal.Result;
import edu.psu.cse.siis.coal.Results;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.field.values.FieldValue;
import edu.psu.cse.siis.coal.field.values.ScalarFieldValue;
import edu.psu.cse.siis.coal.field.values.TopFieldValue;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import edu.psu.cse.siis.coal.values.BottomPropagationValue;
import edu.psu.cse.siis.coal.values.PathValue;
import edu.psu.cse.siis.coal.values.PropagationValue;
import edu.psu.cse.siis.coal.values.TopPropagationValue;
import edu.psu.cse.siis.ic3.DataAuthority;
import edu.psu.cse.siis.ic3.Ic3Result;
import edu.psu.cse.siis.ic3.Timers;
import edu.psu.cse.siis.ic3.db.DbConnection;
import edu.psu.cse.siis.ic3.db.SQLConnection;
import edu.psu.cse.siis.ic3.manifest.ManifestComponent;
import edu.psu.cse.siis.ic3.manifest.ManifestData;
import edu.psu.cse.siis.ic3.manifest.ManifestIntentFilter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class ResultProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ENTRY_POINT_INTENT = "<INTENT>";
    private final int[] preciseNonLinking = new int[]{0, 0, 0, 0};
    private final int[] preciseLinking = new int[]{0, 0, 0, 0};
    private final int[] imprecise = new int[]{0, 0, 0, 0, 0};
    private final int[] top = new int[]{0, 0, 0};
    private final int[] bottom = new int[]{0, 0, 0};
    private final int[] nonexistent = new int[]{0, 0, 0};
    private final int[] preciseFieldValueCount = new int[]{0, 0, 0};
    private final int[] partiallyPreciseFieldValueCount = new int[]{0, 0, 0};
    private final int[] impreciseFieldValueCount = new int[]{0, 0, 0};
    private int intentWithData = 0;
    private int providerArgument = 0;

    public void processResult(boolean writeToDb, String appName, Map<String, Integer> componentToIdMap, int analysisClassesCount, Writer writer) throws IOException, SQLException {
        for (Result result : Results.getResults()) {
            ((Ic3Result)result).dump();
            this.analyzeResult(result);
            if (!writeToDb) continue;
            this.writeResultToDb(result, componentToIdMap);
        }
        if (writeToDb) {
            SQLConnection.closeConnection();
        }
        Timers.v().totalTimer.end();
        String statistics = appName + " " + analysisClassesCount + " " + PropagationTimers.v().reachableMethods + " " + PropagationTimers.v().reachableStatements + " " + this.preciseNonLinking[0] + " " + this.preciseNonLinking[3] + " " + this.preciseNonLinking[1] + " " + this.preciseNonLinking[2] + " " + this.preciseLinking[0] + " " + this.preciseLinking[3] + " " + this.preciseLinking[1] + " " + this.preciseLinking[2] + " " + this.imprecise[0] + " " + this.imprecise[3] + " " + this.imprecise[1] + " " + this.imprecise[2] + " " + this.bottom[0] + " " + this.bottom[1] + " " + this.bottom[2] + " " + this.top[0] + " " + this.top[1] + " " + this.top[2] + " " + this.nonexistent[0] + " " + this.nonexistent[1] + " " + this.nonexistent[2] + " " + this.providerArgument + " " + this.imprecise[4] + " " + PropagationTimers.v().pathValues + " " + PropagationTimers.v().separatePathValues + " " + PropagationTimers.v().modelParsing.getTime() + " " + Timers.v().mainGeneration.getTime() + " " + Timers.v().entryPointMapping.getTime() + " " + Timers.v().classLoading.getTime() + " " + PropagationTimers.v().problemGeneration.getTime() + " " + PropagationTimers.v().ideSolution.getTime() + " " + PropagationTimers.v().valueComposition.getTime() + " " + PropagationTimers.v().resultGeneration.getTime() + " " + (PropagationTimers.v().soot.getTime() - PropagationTimers.v().totalTimer.getTime()) + " " + (Timers.v().misc.getTime() + PropagationTimers.v().misc.getTime()) + " " + Timers.v().totalTimer.getTime() + "\n";
        if (this.logger.isInfoEnabled()) {
            this.logger.info(statistics);
        }
        if (writer != null) {
            writer.write(statistics);
            writer.close();
        }
    }

    private void writeResultToDb(Result result, Map<String, Integer> componentToIdMap) throws SQLException {
        for (Map.Entry<Unit, Map<Integer, Object>> entry : result.getResults().entrySet()) {
            Unit unit = entry.getKey();
            Argument[] arguments = Model.v().getArgumentsForQuery((Stmt)unit);
            Map<SootMethod, Set<String>> entryPointMap = ((Ic3Result)result).getEntryPointMap();
            if (arguments == null) continue;
            SootMethod method = AnalysisParameters.v().getIcfg().getMethodOf(unit);
            int unitId = this.getIdForUnit(unit, method);
            HashMap<String, Object> valueMap = new HashMap<String, Object>(arguments.length);
            Map<Integer, Object> argnumToValueMap = entry.getValue();
            for (Argument argument : arguments) {
                valueMap.put(argument.getProperty("valueType"), argnumToValueMap.get(argument.getArgnum()[0]));
            }
            String className = method.getDeclaringClass().getName();
            String methodSignature = method.getSignature();
            if (valueMap.containsKey("activity")) {
                DbConnection.insertIntentAtExitPoint(className, methodSignature, unitId, (BasePropagationValue)valueMap.get("activity"), "a", null, null, entryPointMap.get(method), componentToIdMap);
                continue;
            }
            if (valueMap.containsKey("service")) {
                DbConnection.insertIntentAtExitPoint(className, methodSignature, unitId, (BasePropagationValue)valueMap.get("service"), "s", null, null, entryPointMap.get(method), componentToIdMap);
                continue;
            }
            if (valueMap.containsKey("receiver")) {
                DbConnection.insertIntentAtExitPoint(className, methodSignature, unitId, (BasePropagationValue)valueMap.get("receiver"), "r", (Set)valueMap.get("permission"), null, entryPointMap.get(method), componentToIdMap);
                continue;
            }
            if (valueMap.containsKey("intentFilter")) {
                this.insertDynamicReceiver((Set)valueMap.get("permission"), (Set)valueMap.get("receiverType"), (BasePropagationValue)valueMap.get("intentFilter"), method, unit);
                continue;
            }
            if (valueMap.containsKey("provider")) {
                DbConnection.insertIntentAtExitPoint(className, methodSignature, unitId, (BasePropagationValue)valueMap.get("provider"), "p", null, null, entryPointMap.get(method), componentToIdMap);
                continue;
            }
            if (valueMap.containsKey("authority")) {
                DbConnection.insertIntentAtExitPoint(className, methodSignature, unitId, this.getUriValueForAuthorities((Set)valueMap.get("authority")), "p", null, null, entryPointMap.get(method), componentToIdMap);
                continue;
            }
            if (valueMap.containsKey("pendingIntent")) {
                BasePropagationValue basePropagationValue = (BasePropagationValue)valueMap.get("pendingIntent");
                String targetType = basePropagationValue instanceof PropagationValue ? (String)((PropagationValue)basePropagationValue).getValuesForField("targetType").iterator().next().getValue() : null;
                Set permissions = (Set)valueMap.get("permission");
                if (targetType != null) {
                    DbConnection.insertIntentAtExitPoint(className, methodSignature, unitId, basePropagationValue, targetType, permissions, null, entryPointMap.get(method), componentToIdMap);
                    continue;
                }
                for (String target : Arrays.asList("a", "r", "s")) {
                    DbConnection.insertIntentAtExitPoint(className, methodSignature, unitId, basePropagationValue, target, permissions, null, entryPointMap.get(method), componentToIdMap);
                }
                continue;
            }
            if (!valueMap.containsKey("componentExtra")) continue;
            DbConnection.insertComponentExtras(entryPointMap.get(method), componentToIdMap, (Set)valueMap.get("componentExtra"));
        }
    }

    private void insertDynamicReceiver(Set<String> permissions, Set<String> receiverTypes, BasePropagationValue intentFilters, SootMethod method, Unit unit) throws SQLException {
        if (permissions == null) {
            permissions = Collections.singleton(null);
        }
        for (String receiverType : receiverTypes) {
            for (String permission : permissions) {
                this.insertDynamicReceiverHelper(permission, receiverType, intentFilters, method, unit);
            }
        }
    }

    private void insertDynamicReceiverHelper(String permission, String receiverType, BasePropagationValue intentFilters, SootMethod method, Unit unit) throws SQLException {
        HashSet<ManifestIntentFilter> manifestIntentFilters;
        Integer missingIntentFilters;
        if (intentFilters == null || intentFilters instanceof TopPropagationValue || intentFilters instanceof BottomPropagationValue) {
            missingIntentFilters = 0;
            manifestIntentFilters = null;
        } else if (intentFilters instanceof PropagationValue) {
            missingIntentFilters = null;
            PropagationValue propagationValue = (PropagationValue)intentFilters;
            manifestIntentFilters = new HashSet<ManifestIntentFilter>();
            for (PathValue branchValue : propagationValue.getPathValues()) {
                Integer filterPriority = null;
                FieldValue priorityFieldValue = branchValue.getFieldValue("priority");
                if (priorityFieldValue != null) {
                    filterPriority = (Integer)priorityFieldValue.getValue();
                }
                manifestIntentFilters.add(new ManifestIntentFilter(branchValue.getSetStringFieldValue("actions"), branchValue.getSetStringFieldValue("categories"), false, this.makeManifestData(branchValue), filterPriority));
            }
        } else {
            throw new RuntimeException("Unknown intent filter type: " + intentFilters.getClass());
        }
        ManifestComponent manifestComponent = new ManifestComponent("r", receiverType, true, true, permission, null, missingIntentFilters, method, unit);
        manifestComponent.setIntentFilters(manifestIntentFilters);
        SQLConnection.insertIntentFilters(Collections.singletonList(manifestComponent));
    }

    private List<ManifestData> makeManifestData(PathValue branchValue) {
        Set<String> mimeTypes = branchValue.getSetStringFieldValue("dataType");
        Set<DataAuthority> authorities = branchValue.getSetFieldValue("authorities", DataAuthority.class);
        Set<String> paths = branchValue.getSetStringFieldValue("paths");
        Set<String> schemes = branchValue.getSetStringFieldValue("schemes");
        if (mimeTypes == null && authorities == null && paths == null && schemes == null) {
            return null;
        }
        if (mimeTypes == null) {
            mimeTypes = Collections.singleton(null);
        }
        if (authorities == null) {
            authorities = Collections.singleton(new DataAuthority(null, null));
        }
        if (paths == null) {
            paths = Collections.singleton(null);
        }
        if (schemes == null) {
            schemes = Collections.singleton(null);
        }
        ArrayList<ManifestData> result = new ArrayList<ManifestData>();
        for (String mimeType : mimeTypes) {
            for (DataAuthority dataAuthority : authorities) {
                for (String dataPath : paths) {
                    for (String scheme : schemes) {
                        result.add(new ManifestData(scheme, dataAuthority.getHost(), dataAuthority.getPort(), dataPath, mimeType));
                    }
                }
            }
        }
        return result;
    }

    private BasePropagationValue getUriValueForAuthorities(Set<String> authorities) {
        if (authorities == null) {
            return null;
        }
        PropagationValue collectingValue = new PropagationValue();
        for (String authority : authorities) {
            PathValue branchValue = new PathValue();
            ScalarFieldValue schemeFieldValue = new ScalarFieldValue("content");
            branchValue.addFieldEntry("scheme", schemeFieldValue);
            ScalarFieldValue authorityFieldValue = new ScalarFieldValue(authority);
            branchValue.addFieldEntry("authority", authorityFieldValue);
            collectingValue.addPathValue(branchValue);
        }
        return collectingValue;
    }

    private int getIdForUnit(Unit unit, SootMethod method) {
        int id = 0;
        for (Unit currentUnit : method.getActiveBody().getUnits()) {
            if (currentUnit == unit) {
                return id;
            }
            ++id;
        }
        return -1;
    }

    private void analyzeResult(Result result) {
        HashSet<String> nonLinkingFieldNames = new HashSet<String>();
        nonLinkingFieldNames.add("extras");
        nonLinkingFieldNames.add("flags");
        nonLinkingFieldNames.add("fragment");
        nonLinkingFieldNames.add("query");
        for (Map.Entry<Unit, Map<Integer, Object>> entry0 : result.getResults().entrySet()) {
            Collection<Object> argumentValues = entry0.getValue().values();
            boolean top = false;
            boolean bottom = false;
            boolean preciseLinking = true;
            boolean preciseNonLinking = true;
            boolean nonexistent = false;
            boolean intentWithUri = false;
            boolean entryPointIntent = false;
            int resultIndex = this.getResultIndex((Stmt)entry0.getKey());
            for (Object value2 : argumentValues) {
                if (value2 == null) {
                    nonexistent = true;
                    continue;
                }
                if (value2 instanceof TopPropagationValue) {
                    top = true;
                    continue;
                }
                if (value2 instanceof BottomPropagationValue) {
                    bottom = true;
                    continue;
                }
                if (!(value2 instanceof PropagationValue)) continue;
                Set<PathValue> pathValues = ((PropagationValue)value2).getPathValues();
                PropagationTimers.v().pathValues += pathValues.size();
                HashSet<String> definedFields = new HashSet<String>();
                for (PathValue pathValue : pathValues) {
                    definedFields.addAll(pathValue.getFieldMap().keySet());
                }
                HashMap<String, Set<FieldValue>> separateFieldValues = new HashMap<String, Set<FieldValue>>();
                for (PathValue branchValue : pathValues) {
                    intentWithUri = intentWithUri || this.isIntentWithUri(branchValue.getFieldMap());
                    HashSet<String> definedFieldsInPath = new HashSet<String>();
                    for (Map.Entry<String, FieldValue> entry : branchValue.getFieldMap().entrySet()) {
                        String fieldName = entry.getKey();
                        FieldValue fieldValue = entry.getValue();
                        this.addValueToSetMap(fieldName, fieldValue, separateFieldValues);
                        definedFieldsInPath.add(fieldName);
                        if (fieldValue instanceof TopFieldValue) {
                            if (nonLinkingFieldNames.contains(fieldName)) {
                                preciseNonLinking = false;
                                continue;
                            }
                            preciseNonLinking = false;
                            preciseLinking = false;
                            continue;
                        }
                        Object value = fieldValue.getValue();
                        if (value == null) continue;
                        if (value instanceof Set) {
                            Set values = (Set)value;
                            if (!values.contains("(.*)") && !values.contains("(.*)") && !values.contains(-1) && !values.contains(ENTRY_POINT_INTENT) && !values.contains("top")) continue;
                            if (values.contains(ENTRY_POINT_INTENT)) {
                                entryPointIntent = true;
                            }
                            preciseNonLinking = false;
                            if (nonLinkingFieldNames.contains(fieldName)) continue;
                            preciseLinking = false;
                            continue;
                        }
                        if (!value.equals("(.*)") && !value.equals("(.*)") && !value.equals(-1) && !value.equals(ENTRY_POINT_INTENT) && !value.equals("top")) continue;
                        if (value.equals(ENTRY_POINT_INTENT)) {
                            entryPointIntent = true;
                        }
                        preciseNonLinking = false;
                        if (nonLinkingFieldNames.contains(fieldName)) continue;
                        preciseLinking = false;
                    }
                    HashSet undefinedFieldForPath = new HashSet(definedFields);
                    undefinedFieldForPath.removeAll(definedFieldsInPath);
                    for (String fieldName : undefinedFieldForPath) {
                        this.addValueToSetMap(fieldName, null, separateFieldValues);
                    }
                }
                int separateCount = 1;
                for (Set values : separateFieldValues.values()) {
                    separateCount *= values.size();
                }
                PropagationTimers.v().separatePathValues += separateCount;
            }
            if (intentWithUri) {
                ++this.intentWithData;
            }
            if (nonexistent) {
                if (Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(AnalysisParameters.v().getIcfg().getMethodOf(entry0.getKey()).getDeclaringClass(), Scene.v().getSootClass("android.content.ContentProvider"))) {
                    ++this.providerArgument;
                    continue;
                }
                int n = resultIndex;
                this.nonexistent[n] = this.nonexistent[n] + 1;
                continue;
            }
            if (top) {
                int n = resultIndex;
                this.top[n] = this.top[n] + 1;
                continue;
            }
            if (bottom) {
                int n = resultIndex;
                this.bottom[n] = this.bottom[n] + 1;
                continue;
            }
            if (preciseNonLinking) {
                if (intentWithUri) {
                    this.preciseNonLinking[3] = this.preciseNonLinking[3] + 1;
                    continue;
                }
                int n = resultIndex;
                this.preciseNonLinking[n] = this.preciseNonLinking[n] + 1;
                continue;
            }
            if (preciseLinking) {
                if (intentWithUri) {
                    this.preciseLinking[3] = this.preciseLinking[3] + 1;
                    continue;
                }
                int n = resultIndex;
                this.preciseLinking[n] = this.preciseLinking[n] + 1;
                continue;
            }
            if (entryPointIntent) {
                this.imprecise[4] = this.imprecise[4] + 1;
                continue;
            }
            if (intentWithUri) {
                this.imprecise[3] = this.imprecise[3] + 1;
                continue;
            }
            int n = resultIndex;
            this.imprecise[n] = this.imprecise[n] + 1;
        }
    }

    private void addValueToSetMap(String key, FieldValue value, Map<String, Set<FieldValue>> map) {
        Set<FieldValue> separateValuesForField = map.get(key);
        if (separateValuesForField == null) {
            separateValuesForField = new HashSet<FieldValue>();
            map.put(key, separateValuesForField);
        }
        separateValuesForField.add(value);
    }

    private boolean isIntentWithUri(Map<String, FieldValue> fieldMap) {
        Set<String> fields = fieldMap.keySet();
        return (fields.contains("action") || fields.contains("categories")) && (fields.contains("uri") && fieldMap.get("uri") != null && fieldMap.get("uri").getValue() != null || fields.contains("path") && fieldMap.get("path") != null && fieldMap.get("path").getValue() != null || fields.contains("scheme") && fieldMap.get("scheme") != null && fieldMap.get("scheme").getValue() != null || fields.contains("ssp") && fieldMap.get("ssp") != null && fieldMap.get("ssp").getValue() != null);
    }

    private int getResultIndex(Stmt stmt) {
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        List<Type> types = invokeExpr.getMethod().getParameterTypes();
        for (Type type : types) {
            if (type.toString().equals("android.content.IntentFilter")) {
                return 1;
            }
            if (!type.toString().equals("android.net.Uri")) continue;
            return 2;
        }
        return 0;
    }

    private boolean containsPartialDefinition(Set<Object> values) {
        for (Object value : values) {
            if (!(value instanceof String) || !((String)value).contains("(.*)")) continue;
            return true;
        }
        return false;
    }
}

