/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.Main;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.infoflow.android.AnalyzeJimpleClass;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.LayoutControl;
import soot.jimple.infoflow.android.resources.LayoutFileParser;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.AndroidEntryPointCreator;
import soot.options.Options;

public class SetupApplication {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Set<SootMethodAndClass>> callbackMethods = new HashMap<String, Set<SootMethodAndClass>>(10000);
    private Set<String> entrypoints = null;
    private String appPackageName = "";
    private final String apkFileLocation;
    private final String classDirectory;
    private final String androidClassPath;
    private AndroidEntryPointCreator entryPointCreator;

    public SetupApplication(String apkFileLocation, String classDirectory, String androidClassPath) {
        this.apkFileLocation = apkFileLocation;
        this.classDirectory = classDirectory;
        this.androidClassPath = androidClassPath;
    }

    public AndroidEntryPointCreator getEntryPointCreator() {
        return this.entryPointCreator;
    }

    public void printEntrypoints() {
        if (this.logger.isDebugEnabled()) {
            if (this.entrypoints == null) {
                this.logger.debug("Entry points not initialized");
            } else {
                this.logger.debug("Classes containing entry points:");
                for (String className : this.entrypoints) {
                    this.logger.debug("\t" + className);
                }
                this.logger.debug("End of Entrypoints");
            }
        }
    }

    public Map<String, Set<String>> calculateSourcesSinksEntrypoints(Set<AndroidMethod> sourceMethods, Set<AndroidMethod> modifierMethods, String packageName, Set<String> entryPointClasses) throws IOException {
        this.appPackageName = packageName;
        this.entrypoints = entryPointClasses;
        boolean parseLayoutFile = !this.apkFileLocation.endsWith(".xml");
        ARSCFileParser resParser = null;
        if (parseLayoutFile) {
            resParser = new ARSCFileParser();
            resParser.parse(this.apkFileLocation);
        }
        AnalyzeJimpleClass jimpleClass = null;
        LayoutFileParser lfp = parseLayoutFile ? new LayoutFileParser(this.appPackageName, resParser) : null;
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            G.reset();
            this.initializeSoot();
            this.createMainMethod();
            if (jimpleClass == null) {
                jimpleClass = new AnalyzeJimpleClass(this.entrypoints);
                jimpleClass.collectCallbackMethods();
                if (parseLayoutFile) {
                    lfp.parseLayoutFile(this.apkFileLocation, this.entrypoints);
                }
            } else {
                jimpleClass.collectCallbackMethodsIncremental();
            }
            PackManager.v().getPack("wjpp").apply();
            PackManager.v().getPack("cg").apply();
            PackManager.v().getPack("wjtp").apply();
            for (Map.Entry<String, Set<Object>> entry : jimpleClass.getCallbackMethods().entrySet()) {
                if (this.callbackMethods.containsKey(entry.getKey())) {
                    if (!this.callbackMethods.get(entry.getKey()).addAll((Collection<SootMethodAndClass>)entry.getValue())) continue;
                    hasChanged = true;
                    continue;
                }
                this.callbackMethods.put(entry.getKey(), new HashSet(entry.getValue()));
                hasChanged = true;
            }
        }
        for (Map.Entry<String, Set<Integer>> entry : jimpleClass.getLayoutClasses().entrySet()) {
            SootClass callbackClass = Scene.v().getSootClass(entry.getKey());
            for (Integer classId : entry.getValue()) {
                ARSCFileParser.AbstractResource resource = resParser.findResource(classId);
                if (resource instanceof ARSCFileParser.StringResource) {
                    Set<LayoutControl> controls;
                    String layoutFileName = ((ARSCFileParser.StringResource)resource).getValue();
                    Set<String> callbackMethods = lfp.getCallbackMethods().get(layoutFileName);
                    if (callbackMethods != null) {
                        block4: for (String methodName : callbackMethods) {
                            String subSig = "void " + methodName + "(android.view.View)";
                            SootClass currentClass = callbackClass;
                            while (true) {
                                SootMethod callbackMethod;
                                if ((callbackMethod = currentClass.getMethodUnsafe(subSig)) != null) {
                                    this.addCallbackMethod(callbackClass.getName(), new AndroidMethod(callbackMethod));
                                    continue block4;
                                }
                                if (!currentClass.hasSuperclass()) {
                                    System.err.println("Callback method " + methodName + " not found in class " + callbackClass.getName());
                                    continue block4;
                                }
                                currentClass = currentClass.getSuperclass();
                            }
                        }
                    }
                    if ((controls = lfp.getUserControls().get(layoutFileName)) == null) continue;
                    for (LayoutControl lc : controls) {
                        this.registerCallbackMethodsForView(callbackClass, lc);
                    }
                    continue;
                }
                System.err.println("Unexpected resource type for layout class");
            }
        }
        this.logger.info("Entry point calculation done.");
        G.reset();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(this.callbackMethods.size());
        for (Map.Entry<String, Set<SootMethodAndClass>> entry : this.callbackMethods.entrySet()) {
            Set<SootMethodAndClass> callbackSet = entry.getValue();
            HashSet<String> callbackStrings = new HashSet<String>(callbackSet.size());
            for (SootMethodAndClass androidMethod : callbackSet) {
                callbackStrings.add(androidMethod.getSignature());
            }
            result.put(entry.getKey(), callbackStrings);
        }
        this.entryPointCreator = this.createEntryPointCreator();
        return result;
    }

    private void registerCallbackMethodsForView(SootClass callbackClass, LayoutControl lc) {
        if (callbackClass.getName().startsWith("android.")) {
            return;
        }
        if (lc.getViewClass().getName().startsWith("android.")) {
            return;
        }
        SootClass sc = lc.getViewClass();
        boolean isView = false;
        while (sc.hasSuperclass()) {
            if (sc.getName().equals("android.view.View")) {
                isView = true;
                break;
            }
            sc = sc.getSuperclass();
        }
        if (!isView) {
            return;
        }
        sc = lc.getViewClass();
        HashSet<String> systemMethods = new HashSet<String>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sc)) {
            if (!parentClass.getName().startsWith("android.")) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.add(sm.getSubSignature());
            }
        }
        for (SootMethod sm : sc.getMethods()) {
            if (sm.isConstructor() || !systemMethods.contains(sm.getSubSignature())) continue;
            this.addCallbackMethod(callbackClass.getName(), new AndroidMethod(sm));
        }
    }

    private void addCallbackMethod(String layoutClass, AndroidMethod callbackMethod) {
        Set<SootMethodAndClass> methods = this.callbackMethods.get(layoutClass);
        if (methods == null) {
            methods = new HashSet<SootMethodAndClass>();
            this.callbackMethods.put(layoutClass, methods);
        }
        methods.add(new AndroidMethod(callbackMethod));
    }

    private void createMainMethod() {
        SootMethod entryPoint = this.createEntryPointCreator().createDummyMain();
        Scene.v().setEntryPoints(Collections.singletonList(entryPoint));
        if (Scene.v().containsClass(entryPoint.getDeclaringClass().getName())) {
            Scene.v().removeClass(entryPoint.getDeclaringClass());
        }
        Scene.v().addClass(entryPoint.getDeclaringClass());
    }

    public void initializeSoot() {
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_output_format(12);
        Options.v().set_whole_program(true);
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().set_ignore_resolution_errors(true);
        Options.v().set_soot_classpath(this.classDirectory + File.pathSeparator + this.androidClassPath);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Android class path: " + this.androidClassPath);
        }
        Options.v().set_process_dir(new ArrayList<String>(this.entrypoints));
        Main.v().autoSetOptions();
        Scene.v().loadNecessaryClasses();
    }

    public AndroidEntryPointCreator createEntryPointCreator() {
        AndroidEntryPointCreator entryPointCreator = new AndroidEntryPointCreator(new ArrayList<String>(this.entrypoints));
        HashMap<String, List<String>> callbackMethodSigs = new HashMap<String, List<String>>();
        for (String className : this.callbackMethods.keySet()) {
            ArrayList<String> methodSigs = new ArrayList<String>();
            callbackMethodSigs.put(className, methodSigs);
            for (SootMethodAndClass am : this.callbackMethods.get(className)) {
                methodSigs.add(am.getSignature());
            }
        }
        entryPointCreator.setCallbackFunctions(callbackMethodSigs);
        return entryPointCreator;
    }
}

