/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3;

import java.text.DecimalFormat;
import soot.G;
import soot.Timer;
import soot.options.Options;

public class Timers {
    private static Timers instance = new Timers();
    public Timer modelParsing = new Timer("modelParsing");
    public Timer mainGeneration = new Timer("mainGeneration");
    public Timer misc = new Timer("Misc");
    public Timer classLoading = new Timer("Class loading");
    public Timer totalTimer = new Timer("totalTimer");
    public Timer entryPointMapping = new Timer("entryPointMapping");
    public int entryPoints = 0;
    public int reachableMethods = 0;
    public int classes = 0;

    private Timers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timers v() {
        Timers timers = instance;
        synchronized (timers) {
            return instance;
        }
    }

    public static void clear() {
        instance = new Timers();
    }

    public void printProfilingInformation() {
        long totalTime = this.totalTimer.getTime();
        G.v().out.println("Time measurements");
        G.v().out.println();
        G.v().out.println("    Main generation: " + this.toTimeString(this.mainGeneration, totalTime));
        G.v().out.println();
        G.v().out.println("    Entry points: " + this.entryPoints);
        G.v().out.println("     Class count: " + this.classes);
        G.v().out.println("totalTime:" + this.toTimeString(this.totalTimer, totalTime));
        if (Options.v().subtract_gc()) {
            G.v().out.println("Garbage collection was subtracted from these numbers.");
            G.v().out.println("       forcedGC:" + this.toTimeString(G.v().Timer_forcedGarbageCollectionTimer, totalTime));
        }
    }

    private String toTimeString(Timer timer, long totalTime) {
        DecimalFormat format = new DecimalFormat("00.0");
        DecimalFormat percFormat = new DecimalFormat("00.0");
        long time = timer.getTime();
        String timeString = format.format((double)time / 1000.0);
        return timeString + "s (" + percFormat.format((double)time * 100.0 / (double)totalTime) + "%)";
    }
}

