/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.ic3.db.Table;
import java.sql.SQLException;

public class ComponentTable
extends Table {
    private static final String INSERT = "INSERT INTO Components (class_id, kind, exported, permission, missing) VALUES (?, ?, ?, ?, ?)";
    private static final String FIND = "SELECT id FROM Components WHERE class_id = ? AND kind = ? AND exported = ? AND permission %s ? AND missing %s ?";

    public int insert(int classId, String type, boolean exported, int permission, Integer missingIntentFilters) throws SQLException {
        int id = this.find(classId, type, exported, permission, missingIntentFilters);
        if (id != -1) {
            return id;
        }
        if (this.insertStatement == null || this.insertStatement.isClosed()) {
            this.insertStatement = ComponentTable.getConnection().prepareStatement(INSERT);
        }
        this.insertStatement.setInt(1, classId);
        this.insertStatement.setString(2, type);
        this.insertStatement.setBoolean(3, exported);
        if (permission == -1) {
            this.insertStatement.setNull(4, 4);
        } else {
            this.insertStatement.setInt(4, permission);
        }
        if (missingIntentFilters == null) {
            this.insertStatement.setNull(5, 4);
        } else {
            this.insertStatement.setInt(5, missingIntentFilters);
        }
        if (this.insertStatement.executeUpdate() == 0) {
            return -1;
        }
        return this.findAutoIncrement();
    }

    public int find(int classId, String type, boolean exported, int permission, Integer missingIntentFilters) throws SQLException {
        String formatArg1 = permission == -1 ? "IS" : "=";
        String formatArg2 = missingIntentFilters == null ? "IS" : "=";
        this.findStatement = ComponentTable.getConnection().prepareStatement(String.format(FIND, formatArg1, formatArg2));
        this.findStatement.setInt(1, classId);
        this.findStatement.setString(2, type);
        this.findStatement.setBoolean(3, exported);
        if (permission == -1) {
            this.findStatement.setNull(4, 12);
        } else {
            this.findStatement.setInt(4, permission);
        }
        if (missingIntentFilters == null) {
            this.findStatement.setNull(5, 4);
        } else {
            this.findStatement.setInt(5, missingIntentFilters);
        }
        return this.processIntFindQuery(this.findStatement);
    }
}

