/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.coal.values.BasePropagationValue;
import edu.psu.cse.siis.coal.values.BottomPropagationValue;
import edu.psu.cse.siis.coal.values.NullPathValue;
import edu.psu.cse.siis.coal.values.PathValue;
import edu.psu.cse.siis.coal.values.PropagationValue;
import edu.psu.cse.siis.coal.values.TopPropagationValue;
import edu.psu.cse.siis.ic3.db.Pair;
import edu.psu.cse.siis.ic3.db.SQLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DbConnection
extends SQLConnection {
    public static Map<PathValue, Integer> insertIntentAtExitPoint(String className, String method, int instruction, BasePropagationValue intentValue, String exit_kind, Set<String> intentPermissions, Integer missingIntents, Set<String> exitPointComponents, Map<String, Integer> componentToIdMap) throws SQLException {
        Set<PathValue> singleIntentValues;
        PropagationValue propagationValue = null;
        if (intentValue == null || intentValue instanceof TopPropagationValue || intentValue instanceof BottomPropagationValue) {
            missingIntents = 0;
        } else if (intentValue instanceof PropagationValue) {
            propagationValue = (PropagationValue)intentValue;
            if (propagationValue.getPathValues() == null || propagationValue.getPathValues().size() == 0) {
                missingIntents = 0;
            }
        } else {
            throw new RuntimeException("Unknown PropagationValue type: " + intentValue.getClass());
        }
        int exitPointId = DbConnection.insertExitPoint(className, method, instruction, exit_kind, missingIntents);
        HashSet<Pair<Integer, Integer>> exitPointComponentPairs = new HashSet<Pair<Integer, Integer>>();
        for (String exitPointComponent : exitPointComponents) {
            exitPointComponentPairs.add(new Pair<Integer, Integer>(exitPointId, componentToIdMap.get(exitPointComponent)));
        }
        exitPointComponentTable.batchInsert(exitPointComponentPairs);
        HashMap<PathValue, Integer> pairs = new HashMap<PathValue, Integer>();
        if (missingIntents == null && (singleIntentValues = propagationValue.getPathValues()) != null) {
            for (PathValue singleIntentValue : singleIntentValues) {
                if (exit_kind.equals("p")) {
                    DbConnection.insertUriAndValue(exitPointId, singleIntentValue);
                    continue;
                }
                int intentId = DbConnection.insertIntentAndValue(exitPointId, singleIntentValue);
                if (intentId == -1) continue;
                pairs.put(singleIntentValue, intentId);
            }
        }
        if (intentPermissions != null) {
            for (String intentPermission : intentPermissions) {
                DbConnection.insertIntentPermission(exitPointId, intentPermission);
            }
        }
        return pairs;
    }

    public static void insertComponentExtras(Set<String> entryPoints, Map<String, Integer> componentToIdMap, Set<String> extras) throws SQLException {
        for (String entryPoint : entryPoints) {
            for (String extra : extras) {
                componentExtraTable.insert(componentToIdMap.get(entryPoint), extra);
            }
        }
    }

    protected static int insertIntentAndValue(int exitPointId, PathValue singleIntentValue) throws SQLException {
        String pkg;
        String clazz;
        int dataId;
        Set<String> extras;
        ArrayList<Integer> actionIds = new ArrayList<Integer>();
        ArrayList<Integer> categoryIds = new ArrayList<Integer>();
        DbConnection.insertStrings(actionStringTable, Collections.singleton(singleIntentValue.getScalarStringFieldValue("action")), actionIds);
        DbConnection.insertStrings(categoryStringTable, singleIntentValue.getSetStringFieldValue("categories"), categoryIds);
        int intentId = intentTable.forceInsert(exitPointId, singleIntentValue.getScalarStringFieldValue("clazz") == null, false);
        intentActionTable.batchForceInsert(intentId, actionIds);
        intentCategoryTable.batchForceInsert(intentId, categoryIds);
        String type = singleIntentValue.getScalarStringFieldValue("dataType");
        if (type != null) {
            String[] typeParts = null;
            if (type.equals("(.*)")) {
                typeParts = new String[]{"(.*)", "(.*)"};
            } else {
                typeParts = type.split("/");
                if (typeParts.length != 2) {
                    typeParts = null;
                }
            }
            if (typeParts != null) {
                intentMimeTypeTable.forceInsert(intentId, typeParts[0], typeParts[1]);
            }
        }
        if ((extras = singleIntentValue.getSetStringFieldValue("extras")) != null) {
            for (String extra : extras) {
                intentExtraTable.forceInsert(intentId, extra);
            }
        }
        if ((dataId = DbConnection.insertData(singleIntentValue)) != -1) {
            intentDataTable.forceInsert(intentId, dataId);
        }
        if ((clazz = singleIntentValue.getScalarStringFieldValue("clazz")) != null) {
            intentClassTable.insert(intentId, clazz);
        }
        if ((pkg = singleIntentValue.getScalarStringFieldValue("package")) != null) {
            intentPackageTable.insert(intentId, pkg);
        }
        return intentId;
    }

    protected static void insertUriAndValue(int exitPointId, PathValue singleIntentValue) throws SQLException {
        if (singleIntentValue instanceof NullPathValue) {
            return;
        }
        int dataId = DbConnection.insertData(singleIntentValue);
        uriTable.forceInsert(exitPointId, dataId != -1 ? Integer.valueOf(dataId) : null);
    }

    protected static int insertData(PathValue singleIntentValue) throws SQLException {
        if (singleIntentValue.containsNonNullFieldValue("scheme") || singleIntentValue.containsNonNullFieldValue("ssp") || singleIntentValue.containsNonNullFieldValue("uri") || singleIntentValue.containsNonNullFieldValue("path") || singleIntentValue.containsNonNullFieldValue("query") || singleIntentValue.containsNonNullFieldValue("authority")) {
            return uriDataTable.forceInsert(singleIntentValue.getScalarStringFieldValue("scheme"), singleIntentValue.getScalarStringFieldValue("ssp"), singleIntentValue.getScalarStringFieldValue("uri"), singleIntentValue.getScalarStringFieldValue("path"), singleIntentValue.getScalarStringFieldValue("query"), singleIntentValue.getScalarStringFieldValue("authority"));
        }
        return -1;
    }
}

