/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.ic3.db.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class IntentFilterTable
extends Table {
    private static final String INSERT = "INSERT INTO IntentFilters (component_id, alias) VALUES (?, ?)";
    private static final String FIND = "SELECT IntentFilters.id, COUNT(IntentFilters.id) AS cnt FROM IntentFilters LEFT JOIN IFActions ON IntentFilters.id = IFActions.filter_id LEFT JOIN IFCategories ON IntentFilters.id = IFCategories.filter_id LEFT JOIN IFMimeTypes ON IntentFilters.id = IFMimeTypes.filter_id WHERE component_id = ? AND alias = ?";

    public int forceInsert(int componentId, boolean alias) throws SQLException {
        if (this.insertStatement == null || this.insertStatement.isClosed()) {
            this.insertStatement = IntentFilterTable.getConnection().prepareStatement(INSERT);
        }
        this.insertStatement.setInt(1, componentId);
        this.insertStatement.setBoolean(2, alias);
        if (this.insertStatement.executeUpdate() == 0) {
            return -1;
        }
        return this.findAutoIncrement();
    }

    public int find(int componentId, List<Integer> actions2, List<Integer> categories, Set<String> mimeTypes, boolean alias) throws SQLException {
        int i;
        StringBuilder queryBuilder = new StringBuilder(FIND);
        int finalCount = 1;
        if (actions2 != null && actions2.size() > 0) {
            queryBuilder.append(" AND (1 = 0");
            for (i = 0; i < actions2.size(); ++i) {
                queryBuilder.append(" OR action = ?");
            }
            queryBuilder.append(")");
            finalCount *= actions2.size();
        } else {
            queryBuilder.append(" AND action IS ?");
        }
        if (categories != null && categories.size() > 0) {
            queryBuilder.append(" AND (1 = 0");
            for (i = 0; i < categories.size(); ++i) {
                queryBuilder.append(" OR category = ?");
            }
            queryBuilder.append(")");
            finalCount *= categories.size();
        } else {
            queryBuilder.append(" AND category IS ?");
        }
        ArrayList<String[]> typePartList = null;
        if (mimeTypes != null && mimeTypes.size() > 0) {
            typePartList = new ArrayList<String[]>();
            queryBuilder.append(" AND (1 = 0");
            for (String mimeType : mimeTypes) {
                if (mimeType.equals("(.*)")) {
                    typePartList.add(new String[]{"*", "*"});
                    queryBuilder.append(" OR (type = ? AND subtype = ?)");
                    continue;
                }
                String[] typeParts = mimeType.split("/");
                if (typeParts.length != 2) continue;
                typePartList.add(typeParts);
                queryBuilder.append(" OR (type = ? AND subtype = ?)");
            }
            queryBuilder.append(")");
            if (typePartList.size() > 0) {
                finalCount *= mimeTypes.size();
            }
        } else {
            queryBuilder.append(" AND type IS ? AND subtype IS ?");
        }
        this.findStatement = IntentFilterTable.getConnection().prepareStatement(queryBuilder.toString());
        this.findStatement.setInt(1, componentId);
        this.findStatement.setBoolean(2, alias);
        int parameterIndex = 3;
        if (actions2 != null && actions2.size() > 0) {
            for (Integer action : actions2) {
                this.findStatement.setInt(parameterIndex++, action);
            }
        } else {
            this.findStatement.setNull(parameterIndex++, 4);
        }
        if (categories != null && categories.size() > 0) {
            for (Integer category : categories) {
                this.findStatement.setInt(parameterIndex++, category);
            }
        } else {
            this.findStatement.setNull(parameterIndex++, 4);
        }
        if (mimeTypes != null && mimeTypes.size() > 0) {
            for (String[] typePart : typePartList) {
                this.findStatement.setString(parameterIndex++, typePart[0]);
                this.findStatement.setString(parameterIndex++, typePart[1]);
            }
        } else {
            this.findStatement.setNull(parameterIndex++, 4);
            this.findStatement.setNull(parameterIndex, 4);
        }
        ResultSet resultSet = this.findStatement.executeQuery();
        int result = resultSet.next() && resultSet.getInt("cnt") == finalCount ? resultSet.getInt("IntentFilters.id") : -1;
        resultSet.close();
        this.findStatement.close();
        return result;
    }
}

