/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.ic3.db.Table;
import java.sql.SQLException;

public abstract class OneIntOneStringTable
extends Table {
    private static final String INSERT = "INSERT INTO %s (%s, %s) VALUES (?, ?)";
    private static final String FIND = "SELECT id FROM %s WHERE %s = ? AND %s = ?";

    OneIntOneStringTable(String table, String firstColumn, String secondColumn) {
        this.insertString = String.format(INSERT, table, firstColumn, secondColumn);
        this.findString = String.format(FIND, table, firstColumn, secondColumn);
    }

    public int insert(int firstValue, String secondValue) throws SQLException {
        int id = this.find(firstValue, secondValue);
        if (id != -1) {
            return id;
        }
        return this.forceInsert(firstValue, secondValue);
    }

    public int forceInsert(int firstValue, String secondValue) throws SQLException {
        if (this.insertStatement == null || this.insertStatement.isClosed()) {
            this.insertStatement = OneIntOneStringTable.getConnection().prepareStatement(this.insertString);
        }
        if (secondValue == null) {
            secondValue = "NULL-CONSTANT";
        }
        this.insertStatement.setInt(1, firstValue);
        this.insertStatement.setString(2, secondValue);
        if (this.insertStatement.executeUpdate() == 0) {
            return -1;
        }
        return this.findAutoIncrement();
    }

    public int find(int firstValue, String secondValue) throws SQLException {
        if (this.findStatement == null || this.findStatement.isClosed()) {
            this.findStatement = OneIntOneStringTable.getConnection().prepareStatement(this.findString);
        }
        this.findStatement.setInt(1, firstValue);
        this.findStatement.setString(2, secondValue);
        return this.processIntFindQuery(this.findStatement);
    }
}

