/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.ic3.db.Table;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PermissionTable
extends Table {
    private static final String INSERT = "INSERT INTO Permissions (id, level) VALUES (?, ?)";
    private static final String FIND = "SELECT id FROM Permissions WHERE id = ? AND level = ?";
    private static final String FIND_SIGNATURE_OR_SYSTEM = "SELECT Permissions.id FROM Permissions JOIN PermissionStrings ON Permissions.id  = PermissionStrings.id WHERE st = ? AND (level = ? OR level = ?)";
    private PreparedStatement findSignatureOrSystemStatement;

    PermissionTable() {
    }

    public int insert(int permissionId, String level) throws SQLException {
        int id = this.find(permissionId, level);
        if (id != -1) {
            return id;
        }
        return this.forceInsert(permissionId, level);
    }

    public int forceInsert(int permissionId, String level) throws SQLException {
        if (this.insertStatement == null || this.insertStatement.isClosed()) {
            this.insertStatement = PermissionTable.getConnection().prepareStatement(INSERT);
        }
        this.insertStatement.setInt(1, permissionId);
        this.insertStatement.setString(2, level);
        if (this.insertStatement.executeUpdate() == 0) {
            return -1;
        }
        return permissionId;
    }

    public int find(int permissionId, String level) throws SQLException {
        if (this.findStatement == null || this.findStatement.isClosed()) {
            this.findStatement = PermissionTable.getConnection().prepareStatement(FIND);
        }
        this.findStatement.setInt(1, permissionId);
        this.findStatement.setString(2, level);
        return this.processIntFindQuery(this.findStatement);
    }

    public boolean isSignatureOrSystem(String permission) throws SQLException {
        if (this.findSignatureOrSystemStatement == null || this.findSignatureOrSystemStatement.isClosed()) {
            this.findStatement = PermissionTable.getConnection().prepareStatement(FIND_SIGNATURE_OR_SYSTEM);
        }
        this.findStatement.setString(1, permission);
        this.findStatement.setString(2, "s");
        this.findStatement.setString(3, "o");
        return this.processIntFindQuery(this.findStatement) != -1;
    }
}

