/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.ic3.db.ApplicationTable;
import edu.psu.cse.siis.ic3.db.ClassTable;
import edu.psu.cse.siis.ic3.db.ComponentExtraTable;
import edu.psu.cse.siis.ic3.db.ComponentTable;
import edu.psu.cse.siis.ic3.db.ExitPointComponentTable;
import edu.psu.cse.siis.ic3.db.ExitPointTable;
import edu.psu.cse.siis.ic3.db.FilterActionTable;
import edu.psu.cse.siis.ic3.db.FilterCategoryTable;
import edu.psu.cse.siis.ic3.db.FilterDataTable;
import edu.psu.cse.siis.ic3.db.IntentActionTable;
import edu.psu.cse.siis.ic3.db.IntentCategoryTable;
import edu.psu.cse.siis.ic3.db.IntentClassTable;
import edu.psu.cse.siis.ic3.db.IntentDataTable;
import edu.psu.cse.siis.ic3.db.IntentExtraTable;
import edu.psu.cse.siis.ic3.db.IntentFilterTable;
import edu.psu.cse.siis.ic3.db.IntentMimeTypeTable;
import edu.psu.cse.siis.ic3.db.IntentPackageTable;
import edu.psu.cse.siis.ic3.db.IntentPermissionTable;
import edu.psu.cse.siis.ic3.db.IntentTable;
import edu.psu.cse.siis.ic3.db.PermissionTable;
import edu.psu.cse.siis.ic3.db.ProviderAuthorityTable;
import edu.psu.cse.siis.ic3.db.ProviderTable;
import edu.psu.cse.siis.ic3.db.StringTable;
import edu.psu.cse.siis.ic3.db.Table;
import edu.psu.cse.siis.ic3.db.UriDataTable;
import edu.psu.cse.siis.ic3.db.UriTable;
import edu.psu.cse.siis.ic3.db.UsesPermissionTable;
import edu.psu.cse.siis.ic3.manifest.ManifestComponent;
import edu.psu.cse.siis.ic3.manifest.ManifestData;
import edu.psu.cse.siis.ic3.manifest.ManifestIntentFilter;
import edu.psu.cse.siis.ic3.manifest.ManifestProviderComponent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLConnection {
    protected static ApplicationTable applicationTable = new ApplicationTable();
    protected static IntentTable intentTable = new IntentTable();
    protected static IntentFilterTable intentFilterTable = new IntentFilterTable();
    protected static IntentMimeTypeTable intentMimeTypeTable = new IntentMimeTypeTable();
    protected static IntentActionTable intentActionTable = new IntentActionTable();
    protected static FilterActionTable filterActionTable = new FilterActionTable();
    protected static IntentCategoryTable intentCategoryTable = new IntentCategoryTable();
    protected static FilterCategoryTable filterCategoryTable = new FilterCategoryTable();
    protected static IntentDataTable intentDataTable = new IntentDataTable();
    protected static FilterDataTable filterDataTable = new FilterDataTable();
    protected static IntentClassTable intentClassTable = new IntentClassTable();
    protected static IntentPackageTable intentPackageTable = new IntentPackageTable();
    protected static StringTable actionStringTable = new StringTable("ActionStrings");
    protected static StringTable categoryStringTable = new StringTable("CategoryStrings");
    protected static StringTable permissionStringTable = new StringTable("PermissionStrings");
    protected static UsesPermissionTable usesPermissionTable = new UsesPermissionTable();
    protected static IntentPermissionTable intentPermissionTable = new IntentPermissionTable();
    protected static ClassTable classTable = new ClassTable();
    protected static IntentExtraTable intentExtraTable = new IntentExtraTable();
    protected static ComponentTable componentTable = new ComponentTable();
    protected static ComponentExtraTable componentExtraTable = new ComponentExtraTable();
    protected static ExitPointTable exitPointTable = new ExitPointTable();
    protected static ExitPointComponentTable exitPointComponentTable = new ExitPointComponentTable();
    protected static PermissionTable permissionTable = new PermissionTable();
    protected static UriDataTable uriDataTable = new UriDataTable();
    protected static UriTable uriTable = new UriTable();
    protected static ProviderTable providerTable = new ProviderTable();
    protected static ProviderAuthorityTable providerAuthorityTable = new ProviderAuthorityTable();
    protected static int appId = -1;

    public static void init(String dbName, String dbPropertiesPath, String sshPropertiesPath, int localDbPort) {
        Table.init(dbName, dbPropertiesPath, sshPropertiesPath, localDbPort);
    }

    public static void closeConnection() {
        Table.closeConnection();
    }

    public static Map<String, Integer> insert(String app, int version2, List<ManifestComponent> intentFilters, Set<String> usesPermissions, Map<String, String> permissions, boolean skipEntryPoints) {
        try {
            if (appId == -1) {
                appId = applicationTable.insert(app, version2);
            }
            if (usesPermissions != null && !SQLConnection.insertUsesPermissions(usesPermissions)) {
                return null;
            }
            if (permissions != null && !SQLConnection.insertPermissions(permissions)) {
                return null;
            }
            if (skipEntryPoints) {
                return Collections.emptyMap();
            }
            return SQLConnection.insertIntentFilters(intentFilters);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static boolean insertUsesPermissions(Set<String> usesPermissions) throws SQLException {
        if (usesPermissions == null) {
            return true;
        }
        Set<Integer> permissionIds = permissionStringTable.batchInsert(usesPermissions, null);
        for (int permissionId : permissionIds) {
            usesPermissionTable.insert(appId, permissionId);
        }
        return true;
    }

    protected static boolean insertPermissions(Map<String, String> permissions) throws SQLException {
        for (Map.Entry<String, String> entry : permissions.entrySet()) {
            int permissionId = permissionStringTable.insert(entry.getKey());
            permissionTable.insert(permissionId, entry.getValue());
        }
        return true;
    }

    public static boolean isSignatureOrSystem(String permission) throws SQLException {
        return permissionTable.isSignatureOrSystem(permission);
    }

    public static Map<String, Integer> insertIntentFilters(List<ManifestComponent> components) throws SQLException {
        if (appId == -1) {
            throw new RuntimeException("appId has not been set");
        }
        HashMap<String, Integer> componentIds = new HashMap<String, Integer>();
        for (ManifestComponent component : components) {
            int componentId;
            if (component instanceof ManifestProviderComponent) {
                componentId = SQLConnection.insertProvider((ManifestProviderComponent)component);
                componentIds.put(component.getName(), componentId);
                continue;
            }
            componentId = SQLConnection.insertComponent(component.getName(), component.getType(), component.isExported(), component.getPermission(), component.missingIntentFilters());
            componentIds.put(component.getName(), componentId);
            Set<ManifestIntentFilter> intentFilters = component.getIntentFilters();
            if (intentFilters == null) continue;
            for (ManifestIntentFilter intentFilter : component.getIntentFilters()) {
                ArrayList<Integer> actionIds = new ArrayList<Integer>();
                ArrayList<Integer> categoryIds = new ArrayList<Integer>();
                SQLConnection.insertStrings(actionStringTable, intentFilter.getActions(), actionIds);
                SQLConnection.insertStrings(categoryStringTable, intentFilter.getCategories(), categoryIds);
                int filterId = intentFilterTable.forceInsert(componentId, intentFilter.isAlias());
                filterActionTable.batchForceInsert(filterId, actionIds);
                filterCategoryTable.batchForceInsert(filterId, categoryIds);
                SQLConnection.insertFilterData(filterId, intentFilter);
            }
        }
        return componentIds;
    }

    protected static int insertProvider(ManifestProviderComponent component) throws SQLException {
        int componentId = SQLConnection.insertComponent(component.getName(), component.getType(), component.isExported(), null, null);
        int providerId = providerTable.insert(componentId, component.getGrantUriPermissions(), component.getReadPermission(), component.getWritePermission());
        Set<String> authorities = component.getAuthorities();
        if (authorities != null) {
            for (String authority : authorities) {
                providerAuthorityTable.insert(providerId, authority);
            }
        }
        return componentId;
    }

    protected static void insertFilterData(Integer filterId, ManifestIntentFilter intentFilter) throws SQLException {
        List<ManifestData> data = intentFilter.getData();
        if (data != null) {
            for (ManifestData manifestData : data) {
                String type = null;
                String subtype = null;
                String mimeType = manifestData.getMimeType();
                if (mimeType != null) {
                    String[] typeParts = null;
                    if (mimeType.equals("(.*)")) {
                        type = "*";
                        subtype = "*";
                    } else {
                        typeParts = mimeType.split("/");
                        if (typeParts.length != 2) {
                            type = null;
                            subtype = null;
                        } else {
                            type = typeParts[0];
                            subtype = typeParts[1];
                        }
                    }
                }
                filterDataTable.insert(filterId, manifestData.getScheme(), manifestData.getHost(), manifestData.getPort(), manifestData.getPath(), type, subtype);
            }
        }
    }

    protected static boolean insertStrings(StringTable table, Set<String> strings, List<Integer> output) throws SQLException {
        boolean[] allThere = new boolean[]{false};
        output.addAll(table.batchInsert(strings, allThere));
        if (strings != null) {
            for (String string : strings) {
                if (string == null) continue;
                int stringId = table.find(string);
                if (stringId == -1) {
                    throw new RuntimeException("error: string '" + string + "' not found in table.");
                }
                output.add(stringId);
            }
        }
        return allThere[0];
    }

    protected static boolean findStrings(StringTable table, Set<String> strings, List<Integer> output) throws SQLException {
        if (strings == null) {
            return true;
        }
        for (String string : strings) {
            int stringId;
            if (string == null) continue;
            if (string.equals("(.*)") || string.equals("<ANY_CLASS>")) {
                output.add(-1);
            }
            if ((stringId = table.find(string)) == -1) {
                return false;
            }
            output.add(stringId);
        }
        return true;
    }

    public static int insertComponent(String name, String type, boolean exported, String permission, Integer missingIntentFilters) throws SQLException {
        int classId = SQLConnection.insertClass(name);
        int permissionId = permission == null ? -1 : permissionStringTable.insert(permission);
        return componentTable.insert(classId, type, exported, permissionId, missingIntentFilters);
    }

    protected static int insertClass(String clazz) throws SQLException {
        return classTable.insert(appId, clazz);
    }

    protected static boolean insertIntentPermission(int exitPointId, String intentPermission) throws SQLException {
        int permissionId = permissionStringTable.insert(intentPermission);
        intentPermissionTable.insert(exitPointId, permissionId);
        return true;
    }

    protected static int insertExitPoint(String className, String method, int instruction, String exit_kind, Integer missingIntentFilters) throws SQLException {
        int classId = SQLConnection.insertClass(className);
        return exitPointTable.insert(classId, method, instruction, exit_kind, missingIntentFilters);
    }
}

