/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.ic3.db.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StringTable
extends Table {
    private static final String INSERT = "INSERT INTO %s (st) VALUES (?)";
    private static final String FIND = "SELECT id FROM %s WHERE st = ?";
    private static final String BATCH_INSERT = "INSERT INTO %s (st) VALUES (?)";
    private static final String BATCH_FIND = "SELECT id, st FROM %s WHERE st IN (?";

    StringTable(String table) {
        this.insertString = String.format("INSERT INTO %s (st) VALUES (?)", table);
        this.findString = String.format(FIND, table);
        this.batchInsertString = String.format("INSERT INTO %s (st) VALUES (?)", table);
        this.batchFindString = String.format(BATCH_FIND, table);
    }

    public Map<String, Integer> batchFind(Set<String> strings) throws SQLException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (strings == null || strings.size() == 0 || strings.size() == 1 && strings.contains(null)) {
            return result;
        }
        StringBuilder queryBuilder = new StringBuilder(this.batchFindString);
        for (int i = 1; i < strings.size(); ++i) {
            queryBuilder.append(", ?");
        }
        queryBuilder.append(")");
        PreparedStatement batchFindStatement = StringTable.getConnection().prepareStatement(queryBuilder.toString());
        int parameterIndex = 1;
        for (String string : strings) {
            if (string == null) {
                string = "NULL-CONSTANT";
            }
            batchFindStatement.setString(parameterIndex++, string);
        }
        ResultSet resultSet = batchFindStatement.executeQuery();
        while (resultSet.next()) {
            result.put(resultSet.getString("st"), resultSet.getInt("id"));
        }
        return result;
    }

    public Set<Integer> batchInsert(Set<String> strings, boolean[] allThere) throws SQLException {
        if (strings == null || strings.size() == 1 && strings.contains(null)) {
            if (allThere != null) {
                allThere[0] = true;
            }
            return new HashSet<Integer>();
        }
        Map<String, Integer> alreadyThere = this.batchFind(strings);
        HashSet<String> toBeInserted = new HashSet<String>(strings);
        toBeInserted.removeAll(alreadyThere.keySet());
        HashSet<Integer> result = new HashSet<Integer>(alreadyThere.values());
        if (toBeInserted.size() == 0) {
            if (allThere != null) {
                allThere[0] = true;
            }
            return result;
        }
        StringBuilder queryBuilder = new StringBuilder(this.batchInsertString);
        for (int i = 1; i < toBeInserted.size(); ++i) {
            queryBuilder.append(", (?)");
        }
        PreparedStatement batchInsertStatement = StringTable.getConnection().prepareStatement(queryBuilder.toString(), AUTOGENERATED_ID);
        int parameterIndex = 1;
        for (String string : toBeInserted) {
            if (string == null) {
                string = "NULL-CONSTANT";
            }
            batchInsertStatement.setString(parameterIndex++, string);
        }
        batchInsertStatement.executeUpdate();
        ResultSet resultSet = batchInsertStatement.getGeneratedKeys();
        while (resultSet.next()) {
            result.add(resultSet.getInt(1));
        }
        return result;
    }

    public int insert(String st) throws SQLException {
        int id;
        if (st == null) {
            st = "NULL-CONSTANT";
        }
        if ((id = this.find(st)) != -1) {
            return id;
        }
        return this.forceInsert(st);
    }

    public int forceInsert(String st) throws SQLException {
        if (this.insertStatement == null || this.insertStatement.isClosed()) {
            this.insertStatement = StringTable.getConnection().prepareStatement(this.insertString);
        }
        if (st == null) {
            st = "NULL-CONSTANT";
        }
        this.insertStatement.setString(1, st);
        if (this.insertStatement.executeUpdate() == 0) {
            return -1;
        }
        return this.findAutoIncrement();
    }

    public int find(String st) throws SQLException {
        if (this.findStatement == null || this.findStatement.isClosed()) {
            this.findStatement = StringTable.getConnection().prepareStatement(this.findString);
        }
        if (st == null) {
            st = "NULL-CONSTANT";
        }
        this.findStatement.setString(1, st);
        return this.processIntFindQuery(this.findStatement);
    }
}

