/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.db;

import edu.psu.cse.siis.ic3.db.Pair;
import edu.psu.cse.siis.ic3.db.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TwoIntTable
extends Table {
    private static final String INSERT = "INSERT INTO %s (%s, %s) VALUES (?, ?)";
    private static final String FIND = "SELECT id FROM %s WHERE %s = ? AND %s = ?";
    private static final String BATCH_INSERT = "INSERT INTO %s (%s, %s) VALUES (?, ?)";
    private static final String BATCH_FIND = "SELECT %s, %s, %s FROM %s WHERE 1 = 0";
    private final String firstColumn;
    private final String secondColumn;
    private final String batchInsertPattern;
    private final String batchFindPattern;

    TwoIntTable(String table, String firstColumn, String secondColumn) {
        this.insertString = String.format("INSERT INTO %s (%s, %s) VALUES (?, ?)", table, firstColumn, secondColumn);
        this.findString = String.format(FIND, table, firstColumn, secondColumn);
        this.batchInsertString = String.format("INSERT INTO %s (%s, %s) VALUES (?, ?)", table, firstColumn, secondColumn);
        this.batchFindString = String.format(BATCH_FIND, "id", firstColumn, secondColumn, table);
        this.firstColumn = firstColumn;
        this.secondColumn = secondColumn;
        this.batchInsertPattern = String.format(", (?, ?)", new Object[0]);
        this.batchFindPattern = String.format(" OR (%s = ? AND %s = ?)", firstColumn, secondColumn);
    }

    public Map<Pair<Integer, Integer>, Integer> batchFind(Set<Pair<Integer, Integer>> values) throws SQLException {
        HashMap<Pair<Integer, Integer>, Integer> found = new HashMap<Pair<Integer, Integer>, Integer>();
        if (values == null || values.size() == 0) {
            return found;
        }
        StringBuilder queryBuilder = new StringBuilder(this.batchFindString);
        for (int i = 0; i < values.size(); ++i) {
            queryBuilder.append(this.batchFindPattern);
        }
        PreparedStatement batchFindStatement = TwoIntTable.getConnection().prepareStatement(queryBuilder.toString());
        int parameterIndex = 1;
        for (Pair<Integer, Integer> value : values) {
            batchFindStatement.setInt(parameterIndex++, value.getO1());
            batchFindStatement.setInt(parameterIndex++, value.getO2());
        }
        ResultSet resultSet = batchFindStatement.executeQuery();
        while (resultSet.next()) {
            found.put(new Pair<Integer, Integer>(resultSet.getInt(this.firstColumn), resultSet.getInt(this.secondColumn)), resultSet.getInt("id"));
        }
        return found;
    }

    public Set<Integer> batchInsert(Set<Pair<Integer, Integer>> values) throws SQLException {
        Map<Pair<Integer, Integer>, Integer> found = this.batchFind(values);
        HashSet<Pair<Integer, Integer>> toBeInserted = new HashSet<Pair<Integer, Integer>>(values);
        toBeInserted.removeAll(found.keySet());
        Set<Integer> result = this.batchForceInsert(toBeInserted);
        result.addAll(found.values());
        return result;
    }

    public Set<Integer> batchForceInsert(Set<Pair<Integer, Integer>> values) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        if (values.size() > 0) {
            StringBuilder queryBuilder = new StringBuilder(this.batchInsertString);
            for (int i = 1; i < values.size(); ++i) {
                queryBuilder.append(this.batchInsertPattern);
            }
            PreparedStatement batchInsertStatement = TwoIntTable.getConnection().prepareStatement(queryBuilder.toString(), AUTOGENERATED_ID);
            int parameterIndex = 1;
            for (Pair<Integer, Integer> value : values) {
                batchInsertStatement.setInt(parameterIndex++, value.getO1());
                batchInsertStatement.setInt(parameterIndex++, value.getO2());
            }
            batchInsertStatement.executeUpdate();
            ResultSet resultSet = batchInsertStatement.getGeneratedKeys();
            while (resultSet.next()) {
                result.add(resultSet.getInt(1));
            }
        }
        return result;
    }

    public Set<Integer> batchForceInsert(Integer firstValue, List<Integer> values) throws SQLException {
        HashSet<Pair<Integer, Integer>> newValues = new HashSet<Pair<Integer, Integer>>();
        if (values == null || values.size() == 0) {
            return new HashSet<Integer>();
        }
        for (int value : values) {
            newValues.add(new Pair<Integer, Integer>(firstValue, value));
        }
        return this.batchForceInsert(newValues);
    }

    public int insert(Integer firstValue, Integer secondValue) throws SQLException {
        int id = this.find(firstValue, secondValue);
        if (id != -1) {
            return id;
        }
        return this.forceInsert(firstValue, secondValue);
    }

    public int forceInsert(Integer firstValue, Integer secondValue) throws SQLException {
        if (this.insertStatement == null || this.insertStatement.isClosed()) {
            this.insertStatement = TwoIntTable.getConnection().prepareStatement(this.insertString);
        }
        if (firstValue != null) {
            this.insertStatement.setInt(1, firstValue);
        } else {
            this.insertStatement.setNull(1, 4);
        }
        if (secondValue != null) {
            this.insertStatement.setInt(2, secondValue);
        } else {
            this.insertStatement.setNull(2, 4);
        }
        if (this.insertStatement.executeUpdate() == 0) {
            return -1;
        }
        return this.findAutoIncrement();
    }

    public int find(Integer firstValue, Integer secondValue) throws SQLException {
        if (this.findStatement == null || this.findStatement.isClosed()) {
            this.findStatement = TwoIntTable.getConnection().prepareStatement(this.findString);
        }
        if (firstValue != null) {
            this.findStatement.setInt(1, firstValue);
        } else {
            this.findStatement.setNull(1, 4);
        }
        if (secondValue != null) {
            this.findStatement.setInt(2, secondValue);
        } else {
            this.findStatement.setNull(2, 4);
        }
        return this.processIntFindQuery(this.findStatement);
    }
}

