/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.manifest;

import edu.psu.cse.siis.ic3.manifest.ManifestIntentFilter;
import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;

public class ManifestComponent {
    private final String name;
    private boolean exported;
    private final boolean foundExported;
    private final String type;
    private Set<ManifestIntentFilter> intentFilters = null;
    private final String permission;
    private final String target;
    private final Integer missingIntentFilters;
    private final SootMethod registrationMethod;
    private final Unit registrationUnit;

    public ManifestComponent(String type, String name, boolean exported, boolean foundExported, String permission, String target, Integer missingIntentFilters, SootMethod registrationMethod, Unit registrationUnit) {
        this.type = type;
        this.exported = exported;
        this.foundExported = foundExported;
        this.name = name;
        this.permission = permission;
        this.target = target;
        this.missingIntentFilters = missingIntentFilters;
        this.registrationMethod = registrationMethod;
        this.registrationUnit = registrationUnit;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExported() {
        return this.exported;
    }

    public String getType() {
        return this.type;
    }

    public Set<ManifestIntentFilter> getIntentFilters() {
        return this.intentFilters;
    }

    public SootMethod getRegistrationMethod() {
        return this.registrationMethod;
    }

    public Unit getRegistrationUnit() {
        return this.registrationUnit;
    }

    public void setIntentFilters(Set<ManifestIntentFilter> intentFilters) {
        this.intentFilters = intentFilters;
    }

    public void addIntentFilters(Set<ManifestIntentFilter> intentFilters) {
        if (intentFilters != null) {
            if (this.intentFilters == null) {
                this.intentFilters = new HashSet<ManifestIntentFilter>();
            }
            this.intentFilters.addAll(intentFilters);
        }
    }

    public void setIntentFiltersAndExported(Set<ManifestIntentFilter> intentFilters) {
        this.intentFilters = intentFilters;
        if (!this.foundExported) {
            this.exported = intentFilters != null && intentFilters.size() > 0;
        }
    }

    public boolean isFoundExported() {
        return this.foundExported;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getTarget() {
        return this.target;
    }

    public Integer missingIntentFilters() {
        return this.missingIntentFilters;
    }
}

