/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.manifest;

import edu.psu.cse.siis.ic3.manifest.ManifestData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ManifestIntentFilter {
    private static final String ACTION_MAIN = "android.intent.action.MAIN";
    private final boolean alias;
    private final Integer priority;
    private Set<String> actions = null;
    private Set<String> categories = null;
    private List<ManifestData> data = null;

    public ManifestIntentFilter(boolean alias, Integer priority) {
        this.alias = alias;
        this.priority = priority;
    }

    public ManifestIntentFilter(Set<String> actions2, Set<String> categories, boolean alias, List<ManifestData> data, Integer priority) {
        this.alias = alias;
        this.actions = actions2;
        this.categories = categories;
        this.data = data;
        this.priority = priority;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public void addAction(String action) {
        if (this.actions == null) {
            this.actions = new HashSet<String>();
        }
        this.actions.add(action);
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public void addCategory(String category) {
        if (this.categories == null) {
            this.categories = new HashSet<String>();
        }
        this.categories.add(category);
    }

    public List<ManifestData> getData() {
        return this.data;
    }

    public void addData(ManifestData manifestData) {
        if (this.data == null) {
            this.data = new ArrayList<ManifestData>();
        }
        this.data.add(manifestData);
    }

    public boolean isEntryPoint() {
        return this.actions.contains(ACTION_MAIN);
    }

    public String toString(String indent) {
        StringBuilder result = new StringBuilder(indent);
        result.append("Intent filter:\n");
        if (this.actions != null && this.actions.size() != 0) {
            result.append(indent);
            result.append("  Actions: ");
            result.append(this.actions);
            result.append("\n");
        }
        if (this.categories != null && this.categories.size() != 0) {
            result.append(indent);
            result.append("  Categories: ");
            result.append(this.categories);
            result.append("\n");
        }
        if (this.data != null && this.data.size() != 0) {
            result.append(indent);
            result.append("  Data: \n");
            for (ManifestData manifestData : this.data) {
                result.append(manifestData.toString(indent + "  ") + "\n");
            }
        }
        return result.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

