/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.manifest;

import edu.psu.cse.siis.ic3.Ic3Data;
import edu.psu.cse.siis.ic3.db.SQLConnection;
import edu.psu.cse.siis.ic3.manifest.ManifestComponent;
import edu.psu.cse.siis.ic3.manifest.ManifestData;
import edu.psu.cse.siis.ic3.manifest.ManifestIntentFilter;
import edu.psu.cse.siis.ic3.manifest.ManifestProviderComponent;
import edu.psu.cse.siis.ic3.manifest.binary.AXmlResourceParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ManifestPullParser {
    private static final String MANIFEST = "manifest";
    private static final String MANIFEST_FILE_NAME = "AndroidManifest.xml";
    private static final String ACTIVITY = "activity";
    private static final String ACTIVITY_ALIAS = "activity-alias";
    private static final String SERVICE = "service";
    private static final String PROVIDER = "provider";
    private static final String AUTHORITIES = "authorities";
    private static final String READ_PERMISSION = "readPermissions";
    private static final String WRITE_PERMISSION = "writePermission";
    private static final String RECEIVER = "receiver";
    private static final String APPLICATION = "application";
    private static final String NAMESPACE = "http://schemas.android.com/apk/res/android";
    private static final String NAME = "name";
    private static final String INTENT_FILTER = "intent-filter";
    private static final String ACTION = "action";
    private static final String CATEGORY = "category";
    private static final String MIME_TYPE = "mimeType";
    private static final String PACKAGE = "package";
    private static final String DATA = "data";
    private static final String FALSE = "false";
    private static final String VERSION = "versionCode";
    private static final String PERMISSION = "permission";
    private static final String EXPORTED = "exported";
    private static final String TRUE = "true";
    private static final String USES_PERMISSION = "uses-permission";
    private static final String PROTECTION_LEVEL = "protectionLevel";
    private static final String TARGET_ACTIVITY = "targetActivity";
    private static final String SCHEME = "scheme";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String PATH = "path";
    private static final String PATH_PATTERN = "pathPattern";
    private static final String PATH_PREFIX = "pathPrefix";
    private static final String GRANT_URI_PERMISSIONS = "grantUriPermissions";
    private static final String PRIORITY = "priority";
    private static final String NORMAL = "normal";
    private static final String DANGEROUS = "dangerous";
    private static final String SIGNATURE = "signature";
    private static final String SIGNATURE_OR_SYSTEM = "signatureOrSytem";
    private String applicationName;
    private String packageName;
    private static final String[] levelValueToShortString = new String[]{"n", "d", "s", "o"};
    private static Map<String, Integer> tagDepthMap = null;
    private final List<ManifestComponent> activities = new ArrayList<ManifestComponent>();
    private final List<ManifestComponent> activityAliases = new ArrayList<ManifestComponent>();
    private final List<ManifestComponent> services = new ArrayList<ManifestComponent>();
    private final List<ManifestComponent> receivers = new ArrayList<ManifestComponent>();
    private final List<ManifestComponent> providers = new ArrayList<ManifestComponent>();
    private int version = -1;
    private ManifestComponent currentComponent = null;
    private Set<ManifestIntentFilter> currentIntentFilters = null;
    private ManifestIntentFilter currentIntentFilter = null;
    private String skipToEndTag = null;
    private String applicationPermission = null;
    private final Set<String> usesPermissions = new HashSet<String>();
    private Map<String, String> permissions = new HashMap<String, String>();
    private final Set<String> entryPointClasses = new HashSet<String>();

    public List<ManifestComponent> getActivities() {
        return this.activities;
    }

    public List<ManifestComponent> getActivityAliases() {
        return this.activityAliases;
    }

    public List<ManifestComponent> getServices() {
        return this.services;
    }

    public List<ManifestComponent> getReceivers() {
        return this.receivers;
    }

    public List<ManifestComponent> getProviders() {
        return this.providers;
    }

    public List<String> getComponents() {
        ArrayList<String> componentNames = new ArrayList<String>();
        this.addComponentNamesToList(this.activities, componentNames);
        this.addComponentNamesToList(this.services, componentNames);
        this.addComponentNamesToList(this.receivers, componentNames);
        this.addComponentNamesToList(this.providers, componentNames);
        return componentNames;
    }

    private void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<String> getEntryPointClasses() {
        return this.entryPointClasses;
    }

    private void addComponentNamesToList(List<ManifestComponent> components, List<String> output) {
        for (ManifestComponent manifestComponent : components) {
            output.add(manifestComponent.getName());
        }
    }

    public void loadManifestFile(String manifest) {
        try {
            if (manifest.endsWith(".xml")) {
                this.loadClassesFromTextManifest(new FileInputStream(manifest));
            } else {
                this.handleBinaryManifestFile(manifest);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void handleBinaryManifestFile(String apk) {
        try {
            ZipFile archive = new ZipFile(apk);
            ZipEntry manifestEntry = archive.getEntry(MANIFEST_FILE_NAME);
            if (manifestEntry == null) {
                archive.close();
                throw new RuntimeException("No manifest file found in apk");
            }
            this.loadClassesFromBinaryManifest(archive.getInputStream(manifestEntry));
            archive.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while processing apk " + apk + ": " + e);
        }
    }

    protected void loadClassesFromBinaryManifest(InputStream manifestIS) {
        AXmlResourceParser aXmlResourceParser = new AXmlResourceParser();
        aXmlResourceParser.open(manifestIS);
        try {
            this.parse(aXmlResourceParser);
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not parse manifest file.");
        }
    }

    protected void loadClassesFromTextManifest(InputStream manifestIS) {
        try {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(true);
            XmlPullParser parser2 = xmlPullParserFactory.newPullParser();
            parser2.setInput(manifestIS, null);
            this.parse(parser2);
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not parse manifest file.");
        }
    }

    public void parse(XmlPullParser parser2) throws XmlPullParserException, IOException {
        this.initializeTagDepthMap();
        int depth = 0;
        int eventType = 0;
        eventType = parser2.next();
        boolean okayToContinue = true;
        while (okayToContinue && eventType != 1) {
            switch (eventType) {
                case 2: {
                    okayToContinue = this.handleStartTag(parser2, depth);
                    ++depth;
                    break;
                }
                case 3: {
                    okayToContinue = this.handleEndTag(parser2);
                    --depth;
                }
            }
            eventType = parser2.next();
        }
    }

    public Map<String, Integer> writeToDb(boolean skipEntryPoints) {
        HashMap<String, Integer> componentIds = new HashMap<String, Integer>();
        componentIds.putAll(SQLConnection.insert(this.getPackageName(), this.version, this.activities, this.usesPermissions, this.permissions, skipEntryPoints));
        componentIds.putAll(SQLConnection.insert(this.getPackageName(), this.version, this.activityAliases, null, null, skipEntryPoints));
        componentIds.putAll(SQLConnection.insert(this.getPackageName(), this.version, this.services, null, null, skipEntryPoints));
        componentIds.putAll(SQLConnection.insert(this.getPackageName(), this.version, this.receivers, null, null, skipEntryPoints));
        componentIds.putAll(SQLConnection.insert(this.getPackageName(), this.version, this.providers, null, null, skipEntryPoints));
        return componentIds;
    }

    public boolean isComponent(String name) {
        return this.entryPointClasses.contains(name);
    }

    public Map<String, Ic3Data.Application.Component.Builder> populateProtobuf(Ic3Data.Application.Builder ic3Builder) {
        ic3Builder.setName(this.getPackageName());
        ic3Builder.setVersion(this.version);
        for (Map.Entry<String, String> permission : this.permissions.entrySet()) {
            Ic3Data.Application.Permission protobufPermission = Ic3Data.Application.Permission.newBuilder().setName(permission.getKey()).setLevel(this.stringToLevel(permission.getValue())).build();
            ic3Builder.addPermissions(protobufPermission);
        }
        ic3Builder.addAllUsedPermissions(this.usesPermissions);
        HashMap<String, Ic3Data.Application.Component.Builder> componentNameToBuilderMap = new HashMap<String, Ic3Data.Application.Component.Builder>();
        componentNameToBuilderMap.putAll(this.populateProtobufComponentBuilders(this.activities, Ic3Data.Application.Component.ComponentKind.ACTIVITY));
        componentNameToBuilderMap.putAll(this.populateProtobufComponentBuilders(this.services, Ic3Data.Application.Component.ComponentKind.SERVICE));
        componentNameToBuilderMap.putAll(this.populateProtobufComponentBuilders(this.receivers, Ic3Data.Application.Component.ComponentKind.RECEIVER));
        componentNameToBuilderMap.putAll(this.populateProtobufComponentBuilders(this.providers, Ic3Data.Application.Component.ComponentKind.PROVIDER));
        return componentNameToBuilderMap;
    }

    private Map<String, Ic3Data.Application.Component.Builder> populateProtobufComponentBuilders(List<ManifestComponent> components, Ic3Data.Application.Component.ComponentKind componentKind) {
        HashMap<String, Ic3Data.Application.Component.Builder> componentNameToBuilderMap = new HashMap<String, Ic3Data.Application.Component.Builder>();
        for (ManifestComponent manifestComponent : components) {
            componentNameToBuilderMap.put(manifestComponent.getName(), ManifestPullParser.makeProtobufComponentBuilder(manifestComponent, componentKind));
        }
        return componentNameToBuilderMap;
    }

    public static Ic3Data.Application.Component.Builder makeProtobufComponentBuilder(ManifestComponent manifestComponent, Ic3Data.Application.Component.ComponentKind componentKind) {
        Ic3Data.Application.Component.Builder componentBuilder = Ic3Data.Application.Component.newBuilder();
        componentBuilder.setName(manifestComponent.getName());
        componentBuilder.setKind(componentKind);
        componentBuilder.setExported(manifestComponent.isExported());
        if (manifestComponent.getPermission() != null) {
            componentBuilder.setPermission(manifestComponent.getPermission());
        }
        if (manifestComponent.missingIntentFilters() != null) {
            componentBuilder.setMissing(manifestComponent.missingIntentFilters());
        }
        if (manifestComponent.getIntentFilters() != null) {
            for (ManifestIntentFilter filter : manifestComponent.getIntentFilters()) {
                Set<String> value;
                Ic3Data.Application.Component.IntentFilter.Builder filterBuilder = Ic3Data.Application.Component.IntentFilter.newBuilder();
                if (filter.getPriority() != null) {
                    filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.PRIORITY).addIntValue(filter.getPriority()));
                }
                if ((value = filter.getActions()) != null) {
                    if (value.contains(null)) {
                        value.remove(null);
                        value.add("NULL-CONSTANT");
                    }
                    filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.ACTION).addAllValue(value));
                }
                if ((value = filter.getCategories()) != null) {
                    if (value.contains(null)) {
                        value.remove(null);
                        value.add("NULL-CONSTANT");
                    }
                    filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.CATEGORY).addAllValue(value));
                }
                if (filter.getData() != null) {
                    for (ManifestData data : filter.getData()) {
                        if (data.getHost() != null) {
                            filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.HOST).addValue(data.getHost()));
                        }
                        if (data.getMimeType() != null) {
                            filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.TYPE).addValue(data.getMimeType()));
                        }
                        if (data.getPath() != null) {
                            filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.PATH).addValue(data.getPath()));
                        }
                        if (data.getPort() != null) {
                            filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.PORT).addValue(data.getPort()));
                        }
                        if (data.getScheme() == null) continue;
                        filterBuilder.addAttributes(Ic3Data.Attribute.newBuilder().setKind(Ic3Data.AttributeKind.SCHEME).addValue(data.getScheme()));
                    }
                }
                componentBuilder.addIntentFilters(filterBuilder);
            }
        }
        return componentBuilder;
    }

    private Ic3Data.Application.Permission.Level stringToLevel(String levelString) {
        if (levelString.equalsIgnoreCase("n")) {
            return Ic3Data.Application.Permission.Level.NORMAL;
        }
        if (levelString.equalsIgnoreCase("d")) {
            return Ic3Data.Application.Permission.Level.DANGEROUS;
        }
        if (levelString.equalsIgnoreCase("s")) {
            return Ic3Data.Application.Permission.Level.SIGNATURE;
        }
        if (levelString.equalsIgnoreCase("o")) {
            return Ic3Data.Application.Permission.Level.SIGNATURE_OR_SYSTEM;
        }
        throw new RuntimeException("Unknown permission level: " + levelString);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Manifest file for ");
        result.append(this.getPackageName());
        if (this.version != -1) {
            result.append(" version ").append(this.version);
        }
        result.append("\n  Activities:\n");
        this.componentMapToString(this.activities, result);
        result.append("\n  Activity Aliases:\n");
        this.componentMapToString(this.activityAliases, result);
        result.append("  Services:\n");
        this.componentMapToString(this.services, result);
        result.append("  Receivers:\n");
        this.componentMapToString(this.receivers, result);
        result.append("  Providers:\n");
        this.componentMapToString(this.providers, result);
        return result.toString();
    }

    private void componentMapToString(List<ManifestComponent> components, StringBuilder out) {
        for (ManifestComponent component : components) {
            out.append("    ").append(component.getName()).append("\n");
            if (component.getIntentFilters() != null) {
                for (ManifestIntentFilter manifestIntentFilter : component.getIntentFilters()) {
                    out.append(manifestIntentFilter.toString("      "));
                }
            }
            if (!(component instanceof ManifestProviderComponent)) continue;
            ManifestProviderComponent provider = (ManifestProviderComponent)component;
            for (String authority : provider.getAuthorities()) {
                out.append("      authority: " + authority + "\n");
            }
            String readPermission = provider.getReadPermission();
            String writePermission = provider.getWritePermission();
            if (readPermission != null && !readPermission.equals("")) {
                out.append("      read permission: " + readPermission + "\n");
            }
            if (writePermission == null || writePermission.equals("")) continue;
            out.append("      write permission: " + writePermission + "\n");
        }
    }

    private boolean handleEndTag(XmlPullParser parser2) {
        String tagName = parser2.getName();
        if (this.skipToEndTag != null) {
            if (this.skipToEndTag.equals(tagName)) {
                this.skipToEndTag = null;
            }
            return true;
        }
        if (tagName.equals(ACTIVITY)) {
            return this.handleActivityEnd(parser2);
        }
        if (tagName.equals(ACTIVITY_ALIAS)) {
            return this.handleActivityAliasEnd(parser2);
        }
        if (tagName.equals(SERVICE)) {
            return this.handleServiceEnd(parser2);
        }
        if (tagName.equals(RECEIVER)) {
            return this.handleReceiverEnd(parser2);
        }
        if (tagName.equals(INTENT_FILTER)) {
            return this.handleIntentFilterEnd(parser2);
        }
        if (tagName.equals(PROVIDER)) {
            return this.handleProviderEnd(parser2);
        }
        return true;
    }

    private void initializeTagDepthMap() {
        if (tagDepthMap == null) {
            tagDepthMap = new HashMap<String, Integer>();
            tagDepthMap.put(MANIFEST, 0);
            tagDepthMap.put(USES_PERMISSION, 1);
            tagDepthMap.put(PERMISSION, 1);
            tagDepthMap.put(APPLICATION, 1);
            tagDepthMap.put(ACTIVITY, 2);
            tagDepthMap.put(SERVICE, 2);
            tagDepthMap.put(RECEIVER, 2);
            tagDepthMap.put(INTENT_FILTER, 3);
            tagDepthMap.put(ACTION, 4);
            tagDepthMap.put(CATEGORY, 4);
            tagDepthMap.put(DATA, 4);
            tagDepthMap = Collections.unmodifiableMap(tagDepthMap);
        }
    }

    private boolean handleStartTag(XmlPullParser parser2, int depth) {
        if (this.skipToEndTag != null) {
            return true;
        }
        String tagName = parser2.getName();
        if (!this.checkDepth(tagName, depth)) {
            return true;
        }
        if (tagName.equals(ACTIVITY)) {
            return this.handleActivityStart(parser2);
        }
        if (tagName.equals(ACTIVITY_ALIAS)) {
            return this.handleActivityAliasStart(parser2);
        }
        if (tagName.equals(SERVICE)) {
            return this.handleServiceStart(parser2);
        }
        if (tagName.equals(RECEIVER)) {
            return this.handleReceiverStart(parser2);
        }
        if (tagName.equals(INTENT_FILTER)) {
            return this.handleIntentFilterStart(parser2);
        }
        if (tagName.equals(ACTION)) {
            return this.handleActionStart(parser2);
        }
        if (tagName.equals(CATEGORY)) {
            return this.handleCategoryStart(parser2);
        }
        if (tagName.equals(MANIFEST)) {
            return this.handleManifestStart(parser2);
        }
        if (tagName.equals(APPLICATION)) {
            return this.handleApplicationStart(parser2);
        }
        if (tagName.equals(USES_PERMISSION)) {
            return this.handleUsesPermissionStart(parser2);
        }
        if (tagName.equals(PERMISSION)) {
            return this.handlePermissionStart(parser2);
        }
        if (tagName.equals(DATA)) {
            return this.handleDataStart(parser2);
        }
        if (tagName.equals(PROVIDER)) {
            return this.handleProviderStart(parser2);
        }
        return true;
    }

    private boolean handleIntentFilterStart(XmlPullParser parser2) {
        Integer priority = null;
        String priorityString = parser2.getAttributeValue(NAMESPACE, PRIORITY);
        if (priorityString != null && priorityString.length() != 0) {
            try {
                priority = Integer.valueOf(priorityString);
            }
            catch (NumberFormatException exception) {
                System.err.println("Bad priority: " + priorityString);
            }
        }
        this.currentIntentFilter = new ManifestIntentFilter(false, priority);
        return true;
    }

    private boolean handleIntentFilterEnd(XmlPullParser parser2) {
        if (this.currentIntentFilters == null) {
            this.currentIntentFilters = new HashSet<ManifestIntentFilter>();
        }
        this.currentIntentFilters.add(this.currentIntentFilter);
        this.currentIntentFilter = null;
        return true;
    }

    private boolean handleActivityStart(XmlPullParser parser2) {
        return this.handleComponentStart(parser2, ACTIVITY, "a");
    }

    private boolean handleActivityEnd(XmlPullParser parser2) {
        return this.handleComponentEnd(parser2, this.activities);
    }

    private boolean handleActivityAliasStart(XmlPullParser parser2) {
        return this.handleComponentStart(parser2, ACTIVITY_ALIAS, "a");
    }

    private boolean handleActivityAliasEnd(XmlPullParser parser2) {
        return this.handleComponentEnd(parser2, this.activityAliases);
    }

    private boolean handleServiceStart(XmlPullParser parser2) {
        return this.handleComponentStart(parser2, SERVICE, "s");
    }

    private boolean handleServiceEnd(XmlPullParser parser2) {
        return this.handleComponentEnd(parser2, this.services);
    }

    private boolean handleReceiverStart(XmlPullParser parser2) {
        return this.handleComponentStart(parser2, RECEIVER, "r");
    }

    private boolean handleReceiverEnd(XmlPullParser parser2) {
        return this.handleComponentEnd(parser2, this.receivers);
    }

    private boolean handleComponentStart(XmlPullParser parser2, String endTag, String componentType) {
        String name = null;
        String targetActivity = null;
        boolean isExported = false;
        boolean foundExported = false;
        String permission = null;
        for (int i = 0; i < parser2.getAttributeCount(); ++i) {
            if (!parser2.getAttributeNamespace(i).equals(NAMESPACE)) continue;
            String attributeName = parser2.getAttributeName(i);
            if (attributeName.equals(NAME)) {
                name = parser2.getAttributeValue(i);
                continue;
            }
            if (attributeName.equals(EXPORTED)) {
                String value = parser2.getAttributeValue(i);
                if (value.equals(TRUE)) {
                    isExported = true;
                    foundExported = true;
                    continue;
                }
                if (!value.equals(FALSE)) continue;
                foundExported = true;
                continue;
            }
            if (attributeName.equals(PERMISSION)) {
                permission = parser2.getAttributeValue(i);
                continue;
            }
            if (!attributeName.equals(TARGET_ACTIVITY)) continue;
            targetActivity = parser2.getAttributeValue(i);
        }
        if (name == null || targetActivity != null && !this.entryPointClasses.contains(this.canonicalizeComponentName(targetActivity))) {
            this.skipToEndTag = endTag;
            return true;
        }
        if (permission == null) {
            permission = this.applicationPermission;
        }
        this.currentComponent = new ManifestComponent(componentType, this.canonicalizeComponentName(name), isExported, foundExported, permission, targetActivity, null, null, null);
        return true;
    }

    private boolean handleComponentEnd(XmlPullParser parser2, List<ManifestComponent> componentSet) {
        this.currentComponent.setIntentFiltersAndExported(this.currentIntentFilters);
        this.entryPointClasses.add(this.currentComponent.getName());
        componentSet.add(this.currentComponent);
        this.currentComponent = null;
        this.currentIntentFilters = null;
        return true;
    }

    private boolean handleApplicationStart(XmlPullParser parser2) {
        for (int i = 0; i < parser2.getAttributeCount(); ++i) {
            if (!parser2.getAttributeNamespace(i).equals(NAMESPACE)) continue;
            if (parser2.getAttributeName(i).equals(NAME)) {
                this.setApplicationName(parser2.getAttributeValue(i));
                continue;
            }
            if (!parser2.getAttributeName(i).equals(PERMISSION)) continue;
            this.applicationPermission = parser2.getAttributeValue(i);
        }
        return true;
    }

    private boolean handleUsesPermissionStart(XmlPullParser parser2) {
        String permission = parser2.getAttributeValue(NAMESPACE, NAME);
        if (permission != null) {
            this.usesPermissions.add(permission);
        }
        return true;
    }

    private boolean handlePermissionStart(XmlPullParser parser2) {
        String permission = parser2.getAttributeValue(NAMESPACE, NAME);
        String protectionLevel = parser2.getAttributeValue(NAMESPACE, PROTECTION_LEVEL);
        protectionLevel = this.transformProtectionLevel(protectionLevel);
        if (permission != null) {
            if (this.permissions == null) {
                this.permissions = new HashMap<String, String>();
            }
            this.permissions.put(permission, protectionLevel);
        }
        return true;
    }

    private String transformProtectionLevel(String protectionLevel) {
        if (protectionLevel == null || protectionLevel.equals("") || NORMAL.equalsIgnoreCase(protectionLevel)) {
            return "n";
        }
        if (DANGEROUS.equalsIgnoreCase(protectionLevel)) {
            return "d";
        }
        if (SIGNATURE.equalsIgnoreCase(protectionLevel)) {
            return "s";
        }
        if (SIGNATURE_OR_SYSTEM.equalsIgnoreCase(protectionLevel)) {
            return "o";
        }
        if (protectionLevel.startsWith("0x")) {
            protectionLevel = protectionLevel.substring(2);
        }
        int level = Integer.parseInt(protectionLevel);
        return levelValueToShortString[level];
    }

    private boolean handleActionStart(XmlPullParser parser2) {
        if (this.currentIntentFilter != null) {
            this.currentIntentFilter.addAction(parser2.getAttributeValue(NAMESPACE, NAME));
        }
        return true;
    }

    private boolean handleCategoryStart(XmlPullParser parser2) {
        if (this.currentIntentFilter != null) {
            this.currentIntentFilter.addCategory(parser2.getAttributeValue(NAMESPACE, NAME));
        }
        return true;
    }

    private boolean handleDataStart(XmlPullParser parser2) {
        if (this.currentIntentFilter != null) {
            ManifestData manifestData = new ManifestData();
            for (int i = 0; i < parser2.getAttributeCount(); ++i) {
                if (!parser2.getAttributeNamespace(i).equals(NAMESPACE)) continue;
                String attributeName = parser2.getAttributeName(i);
                String attributeValue = parser2.getAttributeValue(i);
                if (attributeName.equals(MIME_TYPE)) {
                    manifestData.setMimeType(attributeValue);
                    continue;
                }
                if (attributeName.equals(SCHEME)) {
                    manifestData.setScheme(attributeValue);
                    continue;
                }
                if (attributeName.equals(HOST)) {
                    manifestData.setHost(attributeValue);
                    continue;
                }
                if (attributeName.equals(PORT)) {
                    manifestData.setPort(attributeValue);
                    continue;
                }
                if (attributeName.equals(PATH)) {
                    manifestData.setPath(attributeValue);
                    continue;
                }
                if (attributeName.equals(PATH_PATTERN)) {
                    manifestData.setPath(attributeValue);
                    continue;
                }
                if (!attributeName.equals(PATH_PREFIX)) continue;
                manifestData.setPath(String.format("%s(.*)", attributeValue));
            }
            this.currentIntentFilter.addData(manifestData);
        }
        return true;
    }

    private String canonicalizeComponentName(String name) {
        if (name.length() == 0) {
            throw new RuntimeException("Component should have non-empty name.");
        }
        if (!name.contains(".")) {
            name = this.getPackageName() + "." + name;
        } else if (name.charAt(0) == '.') {
            name = this.getPackageName() + name;
        }
        return name.replace('/', '.');
    }

    private boolean handleManifestStart(XmlPullParser parser2) {
        for (int i = 0; i < parser2.getAttributeCount(); ++i) {
            String attributeName = parser2.getAttributeName(i);
            if (attributeName.equals(PACKAGE)) {
                this.setPackageName(parser2.getAttributeValue(i));
                continue;
            }
            if (!parser2.getAttributeNamespace(i).equals(NAMESPACE) || !attributeName.equals(VERSION)) continue;
            this.version = Integer.parseInt(parser2.getAttributeValue(i));
        }
        return this.getPackageName() != null;
    }

    private boolean handleProviderStart(XmlPullParser parser2) {
        boolean r = this.handleComponentStart(parser2, PROVIDER, "p");
        String readPermission = this.currentComponent.getPermission();
        String writePermission = this.currentComponent.getPermission();
        HashSet<String> authorities = new HashSet<String>();
        boolean grantUriPermissions = false;
        for (int i = 0; i < parser2.getAttributeCount(); ++i) {
            if (!parser2.getAttributeNamespace(i).equals(NAMESPACE)) continue;
            String attributeName = parser2.getAttributeName(i);
            if (attributeName.equals(READ_PERMISSION)) {
                readPermission = parser2.getAttributeValue(i);
                continue;
            }
            if (attributeName.equals(WRITE_PERMISSION)) {
                writePermission = parser2.getAttributeValue(i);
                continue;
            }
            if (attributeName.equals(AUTHORITIES)) {
                String s = parser2.getAttributeValue(i);
                for (String a : s.split(";")) {
                    authorities.add(a);
                }
                continue;
            }
            if (!attributeName.equals(GRANT_URI_PERMISSIONS)) continue;
            grantUriPermissions = !parser2.getAttributeValue(i).equals(FALSE);
        }
        this.currentComponent = new ManifestProviderComponent(this.currentComponent.getType(), this.currentComponent.getName(), this.currentComponent.isExported(), this.currentComponent.isFoundExported(), readPermission, writePermission, authorities, grantUriPermissions);
        return r;
    }

    private boolean handleProviderEnd(XmlPullParser parser2) {
        return this.handleComponentEnd(parser2, this.providers);
    }

    private boolean checkDepth(String tagName, int depth) {
        Integer expectedDepth = tagDepthMap.get(tagName);
        if (expectedDepth != null && expectedDepth != depth) {
            this.skipToEndTag = tagName;
            System.err.println("Warning: malformed Manifest file: " + tagName + " at depth " + depth);
        }
        return true;
    }
}

