/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.manifest.binary;

import java.util.ArrayList;
import java.util.List;

public final class ResXmlEncoders {
    public static String escapeXmlChars(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;");
    }

    public static String encodeAsResXmlAttr(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder out = new StringBuilder(str.length() + 10);
        switch (chars[0]) {
            case '#': 
            case '?': 
            case '@': {
                out.append('\\');
            }
        }
        block8: for (char c : chars) {
            switch (c) {
                case '\\': {
                    out.append('\\');
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    out.append("\\n");
                    continue block8;
                }
                default: {
                    if (ResXmlEncoders.isPrintableChar(c)) break;
                    out.append(String.format("\\u%04x", c));
                    continue block8;
                }
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String encodeAsXmlValue(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder out = new StringBuilder(str.length() + 10);
        switch (chars[0]) {
            case '#': 
            case '?': 
            case '@': {
                out.append('\\');
            }
        }
        boolean isInStyleTag = false;
        int startPos = 0;
        boolean enclose = false;
        boolean wasSpace = true;
        block9: for (char c : chars) {
            if (isInStyleTag) {
                if (c == '>') {
                    isInStyleTag = false;
                    startPos = out.length() + 1;
                    enclose = false;
                }
            } else if (c == ' ') {
                if (wasSpace) {
                    enclose = true;
                }
                wasSpace = true;
            } else {
                wasSpace = false;
                switch (c) {
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\n': 
                    case '\'': {
                        enclose = true;
                        break;
                    }
                    case '\"': {
                        out.append('\\');
                        break;
                    }
                    case '<': {
                        isInStyleTag = true;
                        if (!enclose) break;
                        out.insert(startPos, '\"').append('\"');
                        break;
                    }
                    default: {
                        if (ResXmlEncoders.isPrintableChar(c)) break;
                        out.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                }
            }
            out.append(c);
        }
        if (enclose || wasSpace) {
            out.insert(startPos, '\"').append('\"');
        }
        return out.toString();
    }

    public static boolean hasMultipleNonPositionalSubstitutions(String str) {
        return ResXmlEncoders.findNonPositionalSubstitutions(str, 2).size() > 1;
    }

    public static String enumerateNonPositionalSubstitutions(String str) {
        List<Integer> subs = ResXmlEncoders.findNonPositionalSubstitutions(str, -1);
        if (subs.size() < 2) {
            return str;
        }
        StringBuilder out = new StringBuilder();
        int pos = 0;
        int count = 0;
        for (Integer sub : subs) {
            sub = sub + 1;
            out.append(str.substring(pos, sub)).append(++count).append('$');
            pos = sub;
        }
        out.append(str.substring(pos));
        return out.toString();
    }

    private static List<Integer> findNonPositionalSubstitutions(String str, int max) {
        int pos = 0;
        int pos2 = 0;
        int count = 0;
        int length = str.length();
        ArrayList<Integer> ret = new ArrayList<Integer>();
        while ((pos2 = (pos = str.indexOf(37, pos2)) + 1) != 0 && pos2 != length) {
            char c;
            if ((c = str.charAt(pos2++)) == '%') continue;
            if (c >= '0' && c <= '9' && pos2 < length) {
                while ((c = str.charAt(pos2++)) >= '0' && c <= '9' && pos2 < length) {
                }
                if (c == '$') continue;
            }
            ret.add(pos);
            if (max == -1 || ++count < max) continue;
            break;
        }
        return ret;
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

