/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.ic3.manifest.binary;

import edu.psu.cse.siis.ic3.manifest.binary.ExtDataInput;
import edu.psu.cse.siis.ic3.manifest.binary.ResXmlEncoders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringBlock {
    private int[] m_stringOffsets;
    private byte[] m_strings;
    private int[] m_styleOffsets;
    private int[] m_styles;
    private boolean m_isUTF8;
    private int[] m_stringOwns;
    private static final CharsetDecoder UTF16LE_DECODER = Charset.forName("UTF-16LE").newDecoder();
    private static final CharsetDecoder UTF8_DECODER = Charset.forName("UTF-8").newDecoder();
    private static final Logger LOGGER = Logger.getLogger(StringBlock.class.getName());
    private static final int CHUNK_TYPE = 0x1C0001;
    private static final int UTF8_FLAG = 256;

    public static StringBlock read(ExtDataInput reader) throws IOException {
        int size;
        reader.skipCheckInt(0x1C0001);
        int chunkSize = reader.readInt();
        int stringCount = reader.readInt();
        int styleOffsetCount = reader.readInt();
        int flags = reader.readInt();
        int stringsOffset = reader.readInt();
        int stylesOffset = reader.readInt();
        StringBlock block = new StringBlock();
        block.m_isUTF8 = (flags & 0x100) != 0;
        block.m_stringOffsets = reader.readIntArray(stringCount);
        block.m_stringOwns = new int[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            block.m_stringOwns[i] = -1;
        }
        if (styleOffsetCount != 0) {
            block.m_styleOffsets = reader.readIntArray(styleOffsetCount);
        }
        if ((size = (stylesOffset == 0 ? chunkSize : stylesOffset) - stringsOffset) % 4 != 0) {
            throw new IOException("String data size is not multiple of 4 (" + size + ").");
        }
        block.m_strings = new byte[size];
        reader.readFully(block.m_strings);
        if (stylesOffset != 0) {
            size = chunkSize - stylesOffset;
            if (size % 4 != 0) {
                throw new IOException("Style data size is not multiple of 4 (" + size + ").");
            }
            block.m_styles = reader.readIntArray(size / 4);
        }
        return block;
    }

    public int getCount() {
        return this.m_stringOffsets != null ? this.m_stringOffsets.length : 0;
    }

    public String getString(int index) {
        int length;
        if (index < 0 || this.m_stringOffsets == null || index >= this.m_stringOffsets.length) {
            return null;
        }
        int offset = this.m_stringOffsets[index];
        if (!this.m_isUTF8) {
            length = StringBlock.getShort(this.m_strings, offset) * 2;
            offset += 2;
        } else {
            offset += StringBlock.getVarint(this.m_strings, offset)[1];
            int[] varint = StringBlock.getVarint(this.m_strings, offset);
            offset += varint[1];
            length = varint[0];
        }
        return this.decodeString(offset, length);
    }

    public CharSequence get(int index) {
        return this.getString(index);
    }

    public String getHTML(int index) {
        String raw = this.getString(index);
        if (raw == null) {
            return raw;
        }
        int[] style = this.getStyle(index);
        if (style == null) {
            return ResXmlEncoders.escapeXmlChars(raw);
        }
        StringBuilder html = new StringBuilder(raw.length() + 32);
        int[] opened = new int[style.length / 3];
        int offset = 0;
        int depth = 0;
        while (true) {
            int last;
            int end;
            int j;
            int i = -1;
            for (j = 0; j != style.length; j += 3) {
                if (style[j + 1] == -1 || i != -1 && style[i + 1] <= style[j + 1]) continue;
                i = j;
            }
            int start = i != -1 ? style[i + 1] : raw.length();
            for (j = depth - 1; j >= 0 && (end = style[(last = opened[j]) + 2]) < start; --j) {
                if (offset <= end) {
                    html.append(ResXmlEncoders.escapeXmlChars(raw.substring(offset, end + 1)));
                    offset = end + 1;
                }
                this.outputStyleTag(this.getString(style[last]), html, true);
            }
            depth = j + 1;
            if (offset < start) {
                html.append(ResXmlEncoders.escapeXmlChars(raw.substring(offset, start)));
                offset = start;
            }
            if (i == -1) break;
            this.outputStyleTag(this.getString(style[i]), html, false);
            style[i + 1] = -1;
            opened[depth++] = i;
        }
        return html.toString();
    }

    private void outputStyleTag(String tag, StringBuilder builder, boolean close) {
        int pos;
        builder.append('<');
        if (close) {
            builder.append('/');
        }
        if ((pos = tag.indexOf(59)) == -1) {
            builder.append(tag);
        } else {
            builder.append(tag.substring(0, pos));
            if (!close) {
                boolean loop = true;
                while (loop) {
                    String val;
                    int pos2 = tag.indexOf(61, pos + 1);
                    builder.append(' ').append(tag.substring(pos + 1, pos2)).append("=\"");
                    pos = tag.indexOf(59, pos2 + 1);
                    if (pos != -1) {
                        val = tag.substring(pos2 + 1, pos);
                    } else {
                        loop = false;
                        val = tag.substring(pos2 + 1);
                    }
                    builder.append(ResXmlEncoders.escapeXmlChars(val)).append('\"');
                }
            }
        }
        builder.append('>');
    }

    public int find(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i != this.m_stringOffsets.length; ++i) {
            int j;
            int offset = this.m_stringOffsets[i];
            int length = StringBlock.getShort(this.m_strings, offset);
            if (length != string.length()) continue;
            for (j = 0; j != length && string.charAt(j) == StringBlock.getShort(this.m_strings, offset += 2); ++j) {
            }
            if (j != length) continue;
            return i;
        }
        return -1;
    }

    private StringBlock() {
    }

    private int[] getStyle(int index) {
        if (this.m_styleOffsets == null || this.m_styles == null || index >= this.m_styleOffsets.length) {
            return null;
        }
        int offset = this.m_styleOffsets[index] / 4;
        int count = 0;
        for (int i = offset; i < this.m_styles.length && this.m_styles[i] != -1; ++i) {
            ++count;
        }
        if (count == 0 || count % 3 != 0) {
            return null;
        }
        int[] style = new int[count];
        int i = offset;
        int j = 0;
        while (i < this.m_styles.length && this.m_styles[i] != -1) {
            style[j++] = this.m_styles[i++];
        }
        return style;
    }

    private String decodeString(int offset, int length) {
        try {
            return (this.m_isUTF8 ? UTF8_DECODER : UTF16LE_DECODER).decode(ByteBuffer.wrap(this.m_strings, offset, length)).toString();
        }
        catch (CharacterCodingException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    private static final int getShort(byte[] array, int offset) {
        return (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    private static final int[] getVarint(byte[] array, int offset) {
        int val = array[offset];
        boolean more = (val & 0x80) != 0;
        val &= 0x7F;
        if (!more) {
            return new int[]{val, 1};
        }
        return new int[]{val << 8 | array[offset + 1] & 0xFF, 2};
    }

    public boolean touch(int index, int own) {
        if (index < 0 || this.m_stringOwns == null || index >= this.m_stringOwns.length) {
            return false;
        }
        if (this.m_stringOwns[index] == -1) {
            this.m_stringOwns[index] = own;
            return true;
        }
        return this.m_stringOwns[index] == own;
    }
}

