/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import heros.fieldsens.AccessPath;
import heros.fieldsens.FlowFunction;
import heros.fieldsens.Resolver;
import heros.fieldsens.ZeroCallEdgeResolver;
import heros.fieldsens.ZeroHandler;
import heros.fieldsens.structs.WrappedFact;

public class AccessPathHandler<Field, Fact, Stmt, Method> {
    private AccessPath<Field> accessPath;
    private Resolver<Field, Fact, Stmt, Method> resolver;

    public AccessPathHandler(AccessPath<Field> accessPath, Resolver<Field, Fact, Stmt, Method> resolver) {
        this.accessPath = accessPath;
        this.resolver = resolver;
    }

    public boolean canRead(Field field) {
        return this.accessPath.canRead(field);
    }

    public boolean mayCanRead(Field field) {
        return this.accessPath.canRead(field) || this.accessPath.hasEmptyAccessPath() && !this.accessPath.isAccessInExclusions(field);
    }

    public boolean mayBeEmpty() {
        return this.accessPath.hasEmptyAccessPath();
    }

    public FlowFunction.ConstrainedFact<Field, Fact, Stmt, Method> generate(Fact fact) {
        return new FlowFunction.ConstrainedFact<Field, Fact, Stmt, Method>(new WrappedFact<Field, Fact, Stmt, Method>(fact, this.accessPath, this.resolver));
    }

    public FlowFunction.ConstrainedFact<Field, Fact, Stmt, Method> generateWithEmptyAccessPath(Fact fact, ZeroHandler<Field> zeroHandler) {
        return new FlowFunction.ConstrainedFact(new WrappedFact(fact, new AccessPath(), new ZeroCallEdgeResolver(this.resolver.analyzer, zeroHandler)));
    }

    public ResultBuilder<Field, Fact, Stmt, Method> prepend(final Field field) {
        return new ResultBuilder<Field, Fact, Stmt, Method>(){

            @Override
            public FlowFunction.ConstrainedFact<Field, Fact, Stmt, Method> generate(Fact fact) {
                return new FlowFunction.ConstrainedFact(new WrappedFact(fact, AccessPathHandler.this.accessPath.prepend(field), AccessPathHandler.this.resolver));
            }
        };
    }

    public ResultBuilder<Field, Fact, Stmt, Method> read(final Field field) {
        if (this.mayCanRead(field)) {
            return new ResultBuilder<Field, Fact, Stmt, Method>(){

                @Override
                public FlowFunction.ConstrainedFact<Field, Fact, Stmt, Method> generate(Fact fact) {
                    if (AccessPathHandler.this.canRead(field)) {
                        return new FlowFunction.ConstrainedFact(new WrappedFact(fact, AccessPathHandler.this.accessPath.removeFirst(), AccessPathHandler.this.resolver));
                    }
                    return new FlowFunction.ConstrainedFact(new WrappedFact(fact, new AccessPath(), AccessPathHandler.this.resolver), new FlowFunction.ReadFieldConstraint<Object>(field));
                }
            };
        }
        throw new IllegalArgumentException("Cannot read field " + field);
    }

    public ResultBuilder<Field, Fact, Stmt, Method> overwrite(final Field field) {
        if (this.mayBeEmpty()) {
            return new ResultBuilder<Field, Fact, Stmt, Method>(){

                @Override
                public FlowFunction.ConstrainedFact<Field, Fact, Stmt, Method> generate(Fact fact) {
                    if (AccessPathHandler.this.accessPath.canRead(field)) {
                        AccessPath<Object> tempAccPath = AccessPathHandler.this.accessPath.removeFirst();
                        if (tempAccPath.hasEmptyAccessPath()) {
                            return new FlowFunction.ConstrainedFact(new WrappedFact(fact, tempAccPath.appendExcludedFieldReference(field), AccessPathHandler.this.resolver));
                        }
                        return new FlowFunction.ConstrainedFact(new WrappedFact(fact, tempAccPath, AccessPathHandler.this.resolver));
                    }
                    if (AccessPathHandler.this.accessPath.isAccessInExclusions(field)) {
                        return new FlowFunction.ConstrainedFact(new WrappedFact(fact, AccessPathHandler.this.accessPath, AccessPathHandler.this.resolver));
                    }
                    return new FlowFunction.ConstrainedFact(new WrappedFact(fact, AccessPathHandler.this.accessPath.appendExcludedFieldReference(field), AccessPathHandler.this.resolver), new FlowFunction.WriteFieldConstraint<Object>(field));
                }
            };
        }
        throw new IllegalArgumentException("Cannot write field " + field);
    }

    public static interface ResultBuilder<FieldRef, FactAbstraction, Stmt, Method> {
        public FlowFunction.ConstrainedFact<FieldRef, FactAbstraction, Stmt, Method> generate(FactAbstraction var1);
    }
}

