/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import heros.fieldsens.AccessPath;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import heros.fieldsens.Resolver;
import heros.fieldsens.structs.DeltaConstraint;
import heros.fieldsens.structs.WrappedFact;
import heros.fieldsens.structs.WrappedFactAtStatement;

public class CallEdge<Field, Fact, Stmt, Method> {
    private WrappedFact<Field, Fact, Stmt, Method> calleeSourceFact;
    private PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> callerAnalyzer;
    private WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtCallSite;

    public CallEdge(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> callerAnalyzer, WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtCallSite, WrappedFact<Field, Fact, Stmt, Method> calleeSourceFact) {
        this.callerAnalyzer = callerAnalyzer;
        this.factAtCallSite = factAtCallSite;
        this.calleeSourceFact = calleeSourceFact;
    }

    public WrappedFact<Field, Fact, Stmt, Method> getCalleeSourceFact() {
        return this.calleeSourceFact;
    }

    public WrappedFact<Field, Fact, Stmt, Method> getCallerCallSiteFact() {
        return this.factAtCallSite.getWrappedFact();
    }

    public WrappedFact<Field, Fact, Stmt, Method> getCallerSourceFact() {
        return this.callerAnalyzer.wrappedSource();
    }

    public Stmt getCallSite() {
        return this.factAtCallSite.getStatement();
    }

    public PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> getCallerAnalyzer() {
        return this.callerAnalyzer;
    }

    public void registerInterestCallback(final PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> interestedAnalyzer) {
        final AccessPath.Delta<Field> delta = this.calleeSourceFact.getAccessPath().getDeltaTo(interestedAnalyzer.getAccessPath());
        if (!this.factAtCallSite.canDeltaBeApplied(delta)) {
            return;
        }
        this.factAtCallSite.getWrappedFact().getResolver().resolve(new DeltaConstraint<Field>(delta), new InterestCallback<Field, Fact, Stmt, Method>(){

            @Override
            public void interest(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Resolver<Field, Fact, Stmt, Method> resolver) {
                WrappedFact calleeSourceFactWithDelta = new WrappedFact(CallEdge.this.calleeSourceFact.getFact(), delta.applyTo(CallEdge.this.calleeSourceFact.getAccessPath()), resolver);
                if (interestedAnalyzer.getAccessPath().isPrefixOf(calleeSourceFactWithDelta.getAccessPath()) != AccessPath.PrefixTestResult.GUARANTEED_PREFIX) {
                    throw new AssertionError();
                }
                interestedAnalyzer.addIncomingEdge(new CallEdge(analyzer, new WrappedFactAtStatement(CallEdge.this.factAtCallSite.getStatement(), new WrappedFact(CallEdge.this.factAtCallSite.getWrappedFact().getFact(), delta.applyTo(CallEdge.this.factAtCallSite.getWrappedFact().getAccessPath()), resolver)), calleeSourceFactWithDelta));
            }

            @Override
            public void canBeResolvedEmpty() {
                CallEdge.this.callerAnalyzer.getCallEdgeResolver().resolve(new DeltaConstraint(delta), this);
            }
        });
    }

    public String toString() {
        return "[IncEdge CSite:" + this.getCallSite() + ", Caller-Edge: " + this.getCallerSourceFact() + "->" + this.getCallerCallSiteFact() + ",  CalleeFact: " + this.calleeSourceFact + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calleeSourceFact == null ? 0 : this.calleeSourceFact.hashCode());
        result = 31 * result + (this.callerAnalyzer == null ? 0 : this.callerAnalyzer.hashCode());
        result = 31 * result + (this.factAtCallSite == null ? 0 : this.factAtCallSite.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallEdge other = (CallEdge)obj;
        if (this.calleeSourceFact == null ? other.calleeSourceFact != null : !this.calleeSourceFact.equals(other.calleeSourceFact)) {
            return false;
        }
        if (this.callerAnalyzer == null ? other.callerAnalyzer != null : !this.callerAnalyzer.equals(other.callerAnalyzer)) {
            return false;
        }
        return !(this.factAtCallSite == null ? other.factAtCallSite != null : !this.factAtCallSite.equals(other.factAtCallSite));
    }
}

