/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import com.google.common.collect.Maps;
import heros.EdgeFunction;
import heros.FlowFunction;
import heros.FlowFunctions;
import heros.IFDSTabulationProblem;
import heros.InterproceduralCFG;
import heros.solver.CountingThreadPoolExecutor;
import heros.solver.IFDSSolver;
import heros.solver.JoinHandlingNode;
import heros.solver.JoinHandlingNodesIFDSSolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BiDiIFDSSolver<N, D extends JoinHandlingNode<D>, M, I extends InterproceduralCFG<N, M>> {
    private final IFDSTabulationProblem<N, AbstractionWithSourceStmt, M, I> forwardProblem;
    private final IFDSTabulationProblem<N, AbstractionWithSourceStmt, M, I> backwardProblem;
    private final CountingThreadPoolExecutor sharedExecutor;
    private SingleDirectionSolver fwSolver;
    private SingleDirectionSolver bwSolver;

    public BiDiIFDSSolver(IFDSTabulationProblem<N, D, M, I> forwardProblem, IFDSTabulationProblem<N, D, M, I> backwardProblem) {
        if (!forwardProblem.followReturnsPastSeeds() || !backwardProblem.followReturnsPastSeeds()) {
            throw new IllegalArgumentException("This solver is only meant for bottom-up problems, so followReturnsPastSeeds() should return true.");
        }
        this.forwardProblem = new AugmentedTabulationProblem(forwardProblem);
        this.backwardProblem = new AugmentedTabulationProblem(backwardProblem);
        this.sharedExecutor = new CountingThreadPoolExecutor(1, Math.max(1, forwardProblem.numThreads()), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void solve() {
        this.fwSolver = this.createSingleDirectionSolver(this.forwardProblem, "FW");
        this.bwSolver = this.createSingleDirectionSolver(this.backwardProblem, "BW");
        this.fwSolver.otherSolver = this.bwSolver;
        this.bwSolver.otherSolver = this.fwSolver;
        this.bwSolver.submitInitialSeeds();
        this.fwSolver.solve();
    }

    protected SingleDirectionSolver createSingleDirectionSolver(IFDSTabulationProblem<N, AbstractionWithSourceStmt, M, I> problem, String debugName) {
        return new SingleDirectionSolver(problem, debugName);
    }

    public Set<D> fwIFDSResultAt(N stmt) {
        return this.extractResults(this.fwSolver.ifdsResultsAt(stmt));
    }

    public Set<D> bwIFDSResultAt(N stmt) {
        return this.extractResults(this.bwSolver.ifdsResultsAt(stmt));
    }

    private Set<D> extractResults(Set<AbstractionWithSourceStmt> annotatedResults) {
        HashSet res = new HashSet();
        for (AbstractionWithSourceStmt abstractionWithSourceStmt : annotatedResults) {
            res.add(abstractionWithSourceStmt.getAbstraction());
        }
        return res;
    }

    private class AugmentedTabulationProblem
    implements IFDSTabulationProblem<N, AbstractionWithSourceStmt, M, I> {
        private final IFDSTabulationProblem<N, D, M, I> delegate;
        private final AbstractionWithSourceStmt ZERO;
        private final FlowFunctions<N, D, M> originalFunctions;

        public AugmentedTabulationProblem(IFDSTabulationProblem<N, D, M, I> delegate) {
            this.delegate = delegate;
            this.originalFunctions = this.delegate.flowFunctions();
            this.ZERO = new AbstractionWithSourceStmt(BiDiIFDSSolver.this, (JoinHandlingNode)delegate.zeroValue(), null);
        }

        @Override
        public FlowFunctions<N, AbstractionWithSourceStmt, M> flowFunctions() {
            return new FlowFunctions<N, AbstractionWithSourceStmt, M>(){

                @Override
                public FlowFunction<AbstractionWithSourceStmt> getNormalFlowFunction(final N curr, final N succ) {
                    return new FlowFunction<AbstractionWithSourceStmt>(){

                        @Override
                        public Set<AbstractionWithSourceStmt> computeTargets(AbstractionWithSourceStmt source) {
                            return this.copyOverSourceStmts(source, AugmentedTabulationProblem.this.originalFunctions.getNormalFlowFunction(curr, succ));
                        }
                    };
                }

                @Override
                public FlowFunction<AbstractionWithSourceStmt> getCallFlowFunction(final N callStmt, final M destinationMethod) {
                    return new FlowFunction<AbstractionWithSourceStmt>(){

                        @Override
                        public Set<AbstractionWithSourceStmt> computeTargets(AbstractionWithSourceStmt source) {
                            Set origTargets = AugmentedTabulationProblem.this.originalFunctions.getCallFlowFunction(callStmt, destinationMethod).computeTargets(source.getAbstraction());
                            HashSet<AbstractionWithSourceStmt> res = new HashSet<AbstractionWithSourceStmt>();
                            for (JoinHandlingNode d : origTargets) {
                                res.add(new AbstractionWithSourceStmt(BiDiIFDSSolver.this, d, null));
                            }
                            return res;
                        }
                    };
                }

                @Override
                public FlowFunction<AbstractionWithSourceStmt> getReturnFlowFunction(final N callSite, final M calleeMethod, final N exitStmt, final N returnSite) {
                    return new FlowFunction<AbstractionWithSourceStmt>(){

                        @Override
                        public Set<AbstractionWithSourceStmt> computeTargets(AbstractionWithSourceStmt source) {
                            return this.copyOverSourceStmts(source, AugmentedTabulationProblem.this.originalFunctions.getReturnFlowFunction(callSite, calleeMethod, exitStmt, returnSite));
                        }
                    };
                }

                @Override
                public FlowFunction<AbstractionWithSourceStmt> getCallToReturnFlowFunction(final N callSite, final N returnSite) {
                    return new FlowFunction<AbstractionWithSourceStmt>(){

                        @Override
                        public Set<AbstractionWithSourceStmt> computeTargets(AbstractionWithSourceStmt source) {
                            return this.copyOverSourceStmts(source, AugmentedTabulationProblem.this.originalFunctions.getCallToReturnFlowFunction(callSite, returnSite));
                        }
                    };
                }

                private Set<AbstractionWithSourceStmt> copyOverSourceStmts(AbstractionWithSourceStmt source, FlowFunction<D> originalFunction) {
                    Object originalAbstraction = source.getAbstraction();
                    Set origTargets = originalFunction.computeTargets(originalAbstraction);
                    HashSet<AbstractionWithSourceStmt> res = new HashSet<AbstractionWithSourceStmt>();
                    for (JoinHandlingNode d : origTargets) {
                        res.add(new AbstractionWithSourceStmt(BiDiIFDSSolver.this, d, source.getSourceStmt()));
                    }
                    return res;
                }
            };
        }

        @Override
        public boolean followReturnsPastSeeds() {
            return this.delegate.followReturnsPastSeeds();
        }

        @Override
        public boolean autoAddZero() {
            return this.delegate.autoAddZero();
        }

        @Override
        public int numThreads() {
            return this.delegate.numThreads();
        }

        @Override
        public boolean computeValues() {
            return this.delegate.computeValues();
        }

        @Override
        public I interproceduralCFG() {
            return this.delegate.interproceduralCFG();
        }

        @Override
        public Map<N, Set<AbstractionWithSourceStmt>> initialSeeds() {
            Map originalSeeds = this.delegate.initialSeeds();
            HashMap res = new HashMap();
            for (Map.Entry entry : originalSeeds.entrySet()) {
                Object stmt = entry.getKey();
                Set seeds = entry.getValue();
                HashSet<AbstractionWithSourceStmt> resSet = new HashSet<AbstractionWithSourceStmt>();
                for (JoinHandlingNode d : seeds) {
                    resSet.add(new AbstractionWithSourceStmt(BiDiIFDSSolver.this, d, stmt));
                }
                res.put(stmt, resSet);
            }
            return res;
        }

        @Override
        public AbstractionWithSourceStmt zeroValue() {
            return this.ZERO;
        }
    }

    public static class AbstractionWithSourceStmt
    implements JoinHandlingNode<AbstractionWithSourceStmt> {
        protected final D abstraction;
        protected final N source;
        final /* synthetic */ BiDiIFDSSolver this$0;

        private AbstractionWithSourceStmt(D abstraction, N source) {
            this.this$0 = var1_1;
            this.abstraction = abstraction;
            this.source = source;
        }

        public D getAbstraction() {
            return this.abstraction;
        }

        public N getSourceStmt() {
            return this.source;
        }

        public String toString() {
            if (this.source != null) {
                return "" + this.abstraction + "-@-" + this.source + "";
            }
            return this.abstraction.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.abstraction == null ? 0 : this.abstraction.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractionWithSourceStmt other = (AbstractionWithSourceStmt)obj;
            if (this.abstraction == null ? other.abstraction != null : !this.abstraction.equals(other.abstraction)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        @Override
        public void setCallingContext(AbstractionWithSourceStmt callingContext) {
            this.abstraction.setCallingContext(callingContext.getAbstraction());
        }

        @Override
        public boolean handleJoin(AbstractionWithSourceStmt joiningNode) {
            return this.abstraction.handleJoin(joiningNode.getAbstraction());
        }

        @Override
        public JoinHandlingNode.JoinKey createJoinKey() {
            return new JoinHandlingNode.JoinKey(this.source, this.abstraction.createJoinKey());
        }
    }

    protected class SingleDirectionSolver
    extends JoinHandlingNodesIFDSSolver<N, AbstractionWithSourceStmt, M, I> {
        private final String debugName;
        private SingleDirectionSolver otherSolver;
        private Set<LeakKey<N>> leakedSources;
        private ConcurrentMap<LeakKey<N>, Set<PausedEdge>> pausedPathEdges;

        public SingleDirectionSolver(IFDSTabulationProblem<N, AbstractionWithSourceStmt, M, I> ifdsProblem, String debugName) {
            super(ifdsProblem);
            this.leakedSources = Collections.newSetFromMap(Maps.newConcurrentMap());
            this.pausedPathEdges = Maps.newConcurrentMap();
            this.debugName = debugName;
        }

        @Override
        protected void propagateUnbalancedReturnFlow(N retSiteC, AbstractionWithSourceStmt targetVal, EdgeFunction<IFDSSolver.BinaryDomain> edgeFunction, N relatedCallSite) {
            Object sourceStmt = targetVal.getSourceStmt();
            LeakKey leakKey = new LeakKey(sourceStmt, relatedCallSite);
            this.leakedSources.add(leakKey);
            if (this.otherSolver.hasLeaked(leakKey)) {
                this.otherSolver.unpausePathEdgesForSource(leakKey);
                super.propagateUnbalancedReturnFlow(retSiteC, targetVal, edgeFunction, relatedCallSite);
            } else {
                Set newPausedEdges = Collections.newSetFromMap(Maps.newConcurrentMap());
                Set existingPausedEdges = this.pausedPathEdges.putIfAbsent(leakKey, newPausedEdges);
                if (existingPausedEdges == null) {
                    existingPausedEdges = newPausedEdges;
                }
                PausedEdge edge = new PausedEdge(retSiteC, targetVal, edgeFunction, relatedCallSite);
                existingPausedEdges.add(edge);
                if (this.otherSolver.hasLeaked(leakKey) && existingPausedEdges.remove(edge)) {
                    super.propagateUnbalancedReturnFlow(retSiteC, targetVal, edgeFunction, relatedCallSite);
                }
                logger.debug(" ++ PAUSE {}: {}", (Object)this.debugName, (Object)edge);
            }
        }

        @Override
        protected void propagate(AbstractionWithSourceStmt sourceVal, N target, AbstractionWithSourceStmt targetVal, EdgeFunction<IFDSSolver.BinaryDomain> f, N relatedCallSite, boolean isUnbalancedReturn) {
            if (isUnbalancedReturn) {
                assert (sourceVal.getSourceStmt() == null) : "source value should have no statement attached";
                targetVal = new AbstractionWithSourceStmt(BiDiIFDSSolver.this, (JoinHandlingNode)targetVal.getAbstraction(), relatedCallSite);
                super.propagate(sourceVal, target, targetVal, f, relatedCallSite, isUnbalancedReturn);
            } else {
                super.propagate(sourceVal, target, targetVal, f, relatedCallSite, isUnbalancedReturn);
            }
        }

        @Override
        protected AbstractionWithSourceStmt restoreContextOnReturnedFact(AbstractionWithSourceStmt d4, AbstractionWithSourceStmt d5) {
            d5.getAbstraction().setCallingContext(d4.getAbstraction());
            return new AbstractionWithSourceStmt(BiDiIFDSSolver.this, (JoinHandlingNode)d5.getAbstraction(), d4.getSourceStmt());
        }

        private boolean hasLeaked(LeakKey<N> leakKey) {
            return this.leakedSources.contains(leakKey);
        }

        private void unpausePathEdgesForSource(LeakKey<N> leakKey) {
            Set pausedEdges = (Set)this.pausedPathEdges.get(leakKey);
            if (pausedEdges != null) {
                for (PausedEdge edge : pausedEdges) {
                    if (!pausedEdges.remove(edge)) continue;
                    if (DEBUG) {
                        logger.debug("-- UNPAUSE {}: {}", (Object)this.debugName, (Object)edge);
                    }
                    super.propagateUnbalancedReturnFlow(edge.retSiteC, edge.targetVal, edge.edgeFunction, edge.relatedCallSite);
                }
            }
        }

        @Override
        protected CountingThreadPoolExecutor getExecutor() {
            return BiDiIFDSSolver.this.sharedExecutor;
        }

        @Override
        protected String getDebugName() {
            return this.debugName;
        }
    }

    private static class LeakKey<N> {
        private N sourceStmt;
        private N relatedCallSite;

        public LeakKey(N sourceStmt, N relatedCallSite) {
            this.sourceStmt = sourceStmt;
            this.relatedCallSite = relatedCallSite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.relatedCallSite == null ? 0 : this.relatedCallSite.hashCode());
            result = 31 * result + (this.sourceStmt == null ? 0 : this.sourceStmt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LeakKey)) {
                return false;
            }
            LeakKey other = (LeakKey)obj;
            if (this.relatedCallSite == null ? other.relatedCallSite != null : !this.relatedCallSite.equals(other.relatedCallSite)) {
                return false;
            }
            return !(this.sourceStmt == null ? other.sourceStmt != null : !this.sourceStmt.equals(other.sourceStmt));
        }
    }

    private class PausedEdge {
        private N retSiteC;
        private AbstractionWithSourceStmt targetVal;
        private EdgeFunction<IFDSSolver.BinaryDomain> edgeFunction;
        private N relatedCallSite;

        public PausedEdge(N retSiteC, AbstractionWithSourceStmt targetVal, EdgeFunction<IFDSSolver.BinaryDomain> edgeFunction, N relatedCallSite) {
            this.retSiteC = retSiteC;
            this.targetVal = targetVal;
            this.edgeFunction = edgeFunction;
            this.relatedCallSite = relatedCallSite;
        }
    }
}

