/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import heros.EdgeFunction;
import heros.EdgeFunctions;
import heros.FlowFunctions;
import heros.IDETabulationProblem;
import heros.IFDSTabulationProblem;
import heros.InterproceduralCFG;
import heros.JoinLattice;
import heros.edgefunc.AllBottom;
import heros.edgefunc.AllTop;
import heros.edgefunc.EdgeIdentity;
import heros.solver.IDESolver;
import java.util.Map;
import java.util.Set;

public class IFDSSolver<N, D, M, I extends InterproceduralCFG<N, M>>
extends IDESolver<N, D, M, BinaryDomain, I> {
    private static final EdgeFunction<BinaryDomain> ALL_BOTTOM = new AllBottom<BinaryDomain>(BinaryDomain.BOTTOM);

    public IFDSSolver(final IFDSTabulationProblem<N, D, M, I> ifdsProblem) {
        super(new IDETabulationProblem<N, D, M, BinaryDomain, I>(){

            @Override
            public FlowFunctions<N, D, M> flowFunctions() {
                return ifdsProblem.flowFunctions();
            }

            @Override
            public I interproceduralCFG() {
                return ifdsProblem.interproceduralCFG();
            }

            @Override
            public Map<N, Set<D>> initialSeeds() {
                return ifdsProblem.initialSeeds();
            }

            @Override
            public D zeroValue() {
                return ifdsProblem.zeroValue();
            }

            @Override
            public EdgeFunctions<N, D, M, BinaryDomain> edgeFunctions() {
                return new IFDSEdgeFunctions();
            }

            @Override
            public JoinLattice<BinaryDomain> joinLattice() {
                return new JoinLattice<BinaryDomain>(){

                    @Override
                    public BinaryDomain topElement() {
                        return BinaryDomain.TOP;
                    }

                    @Override
                    public BinaryDomain bottomElement() {
                        return BinaryDomain.BOTTOM;
                    }

                    @Override
                    public BinaryDomain join(BinaryDomain left, BinaryDomain right) {
                        if (left == BinaryDomain.TOP && right == BinaryDomain.TOP) {
                            return BinaryDomain.TOP;
                        }
                        return BinaryDomain.BOTTOM;
                    }
                };
            }

            @Override
            public EdgeFunction<BinaryDomain> allTopFunction() {
                return new AllTop<BinaryDomain>(BinaryDomain.TOP);
            }

            @Override
            public boolean followReturnsPastSeeds() {
                return ifdsProblem.followReturnsPastSeeds();
            }

            @Override
            public boolean autoAddZero() {
                return ifdsProblem.autoAddZero();
            }

            @Override
            public int numThreads() {
                return ifdsProblem.numThreads();
            }

            @Override
            public boolean computeValues() {
                return ifdsProblem.computeValues();
            }

            class IFDSEdgeFunctions
            implements EdgeFunctions<N, D, M, BinaryDomain> {
                IFDSEdgeFunctions() {
                }

                @Override
                public EdgeFunction<BinaryDomain> getNormalEdgeFunction(N src, D srcNode, N tgt, D tgtNode) {
                    if (srcNode == ifdsProblem.zeroValue()) {
                        return ALL_BOTTOM;
                    }
                    return EdgeIdentity.v();
                }

                @Override
                public EdgeFunction<BinaryDomain> getCallEdgeFunction(N callStmt, D srcNode, M destinationMethod, D destNode) {
                    if (srcNode == ifdsProblem.zeroValue()) {
                        return ALL_BOTTOM;
                    }
                    return EdgeIdentity.v();
                }

                @Override
                public EdgeFunction<BinaryDomain> getReturnEdgeFunction(N callSite, M calleeMethod, N exitStmt, D exitNode, N returnSite, D retNode) {
                    if (exitNode == ifdsProblem.zeroValue()) {
                        return ALL_BOTTOM;
                    }
                    return EdgeIdentity.v();
                }

                @Override
                public EdgeFunction<BinaryDomain> getCallToReturnEdgeFunction(N callStmt, D callNode, N returnSite, D returnSideNode) {
                    if (callNode == ifdsProblem.zeroValue()) {
                        return ALL_BOTTOM;
                    }
                    return EdgeIdentity.v();
                }
            }
        });
    }

    public Set<D> ifdsResultsAt(N statement) {
        return this.resultsAt(statement).keySet();
    }

    protected static enum BinaryDomain {
        TOP,
        BOTTOM;

    }
}

