/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.Base64;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;

class CodeAttributeDecoder {
    CodeAttributeDecoder() {
    }

    public static byte[] decode(String attr2, Hashtable labelToPc) {
        LinkedList<byte[]> attributeHunks = new LinkedList<byte[]>();
        int attributeSize = 0;
        int tableSize = 0;
        StringTokenizer st = new StringTokenizer(attr2, "%", true);
        boolean isLabel = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("%")) {
                isLabel = !isLabel;
                continue;
            }
            if (isLabel) {
                Integer pc = (Integer)labelToPc.get(token);
                if (pc == null) {
                    throw new RuntimeException("PC is null, the token is " + token);
                }
                int pcvalue = pc;
                if (pcvalue > 65535) {
                    throw new RuntimeException("PC great than 65535, the token is " + token + " : " + pcvalue);
                }
                byte[] pcArray = new byte[2];
                pcArray[1] = (byte)(pcvalue & 0xFF);
                pcArray[0] = (byte)(pcvalue >> 8 & 0xFF);
                attributeHunks.add(pcArray);
                attributeSize += 2;
                ++tableSize;
                continue;
            }
            byte[] hunk = Base64.decode(token.toCharArray());
            attributeSize += hunk.length;
            attributeHunks.add(hunk);
        }
        byte[] attributeValue = new byte[attributeSize += 2];
        attributeValue[0] = (byte)(tableSize >> 8 & 0xFF);
        attributeValue[1] = (byte)(tableSize & 0xFF);
        int index = 2;
        for (byte[] hunk : attributeHunks) {
            for (int i = 0; i < hunk.length; ++i) {
                attributeValue[index++] = hunk[i];
            }
        }
        if (index != attributeSize) {
            throw new RuntimeException("Index does not euqal to attrubute size :" + index + " -- " + attributeSize);
        }
        return attributeValue;
    }
}

