/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.util.ConsoleUtil;

public class DumpVtables {
    private static final Options options = new Options();

    public static void main(String[] args) {
        CommandLine commandLine;
        PosixParser parser2 = new PosixParser();
        try {
            commandLine = parser2.parse(options, args);
        }
        catch (ParseException ex) {
            DumpVtables.usage();
            return;
        }
        String[] remainingArgs = commandLine.getArgs();
        Option[] parsedOptions = commandLine.getOptions();
        ArrayList<String> bootClassPathDirs = Lists.newArrayList();
        String outFile = "vtables.txt";
        int apiLevel = 15;
        boolean experimental = false;
        block10: for (int i = 0; i < parsedOptions.length; ++i) {
            Option option = parsedOptions[i];
            String opt = option.getOpt();
            switch (opt.charAt(0)) {
                case 'd': {
                    bootClassPathDirs.add(option.getValue());
                    continue block10;
                }
                case 'o': {
                    outFile = option.getValue();
                    continue block10;
                }
                case 'a': {
                    apiLevel = Integer.parseInt(commandLine.getOptionValue("a"));
                    continue block10;
                }
                case 'X': {
                    experimental = true;
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        if (remainingArgs.length != 1) {
            DumpVtables.usage();
            return;
        }
        String inputDexFileName = remainingArgs[0];
        File dexFileFile = new File(inputDexFileName);
        if (!dexFileFile.exists()) {
            System.err.println("Can't find the file " + inputDexFileName);
            System.exit(1);
        }
        try {
            DexBackedDexFile dexFile = DexFileFactory.loadDexFile(dexFileFile, apiLevel, experimental);
            Iterable<String> bootClassPaths = Splitter.on(":").split("core.jar:ext.jar:framework.jar:android.policy.jar:services.jar");
            ClassPath classPath = ClassPath.fromClassPath(bootClassPathDirs, bootClassPaths, dexFile, apiLevel, experimental);
            FileOutputStream outStream = new FileOutputStream(outFile);
            for (ClassDef classDef : dexFile.getClasses()) {
                ClassProto classProto = (ClassProto)classPath.getClass(classDef);
                List<Method> methods = classProto.getVtable();
                String className = "Class " + classDef.getType() + " extends " + classDef.getSuperclass() + " : " + methods.size() + " methods\n";
                outStream.write(className.getBytes());
                for (int i = 0; i < methods.size(); ++i) {
                    Method method = methods.get(i);
                    String methodString = i + ":" + method.getDefiningClass() + "->" + method.getName() + "(";
                    for (CharSequence charSequence : method.getParameterTypes()) {
                        methodString = methodString + charSequence;
                    }
                    methodString = methodString + ")" + method.getReturnType() + "\n";
                    outStream.write(methodString.getBytes());
                }
                outStream.write("\n".getBytes());
            }
            outStream.close();
        }
        catch (IOException ex) {
            System.out.println("IOException thrown when trying to open a dex file or write out vtables: " + ex);
        }
    }

    private static void usage() {
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 80;
        }
        System.out.println("java -cp baksmali.jar org.jf.dexlib2.analysis.DumpVtables -d path/to/framework/jar/files <dex-file>");
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt("bootclasspath-dir");
        OptionBuilder.withDescription("the base folder to look for the bootclasspath files in. Defaults to the current directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("DIR");
        Option classPathDirOption = OptionBuilder.create("d");
        OptionBuilder.withLongOpt("out-file");
        OptionBuilder.withDescription("output file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("FILE");
        Option outputFileOption = OptionBuilder.create("o");
        OptionBuilder.withLongOpt("api-level");
        OptionBuilder.withDescription("The numeric api-level of the file being disassembled. If not specified, it defaults to 15 (ICS).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("API_LEVEL");
        Option apiLevelOption = OptionBuilder.create("a");
        OptionBuilder.withLongOpt("experimental");
        OptionBuilder.withDescription("Enable dumping experimental opcodes, that aren't necessarily supported by the android runtime yet.");
        Option experimentalOption = OptionBuilder.create("X");
        options.addOption(classPathDirOption);
        options.addOption(outputFileOption);
        options.addOption(apiLevelOption);
        options.addOption(experimentalOption);
    }

    static {
        DumpVtables.buildOptions();
    }
}

