/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import soot.ClassSource;
import soot.G;
import soot.SootClass;
import soot.Type;
import soot.coffi.Util;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;
import soot.tagkit.SourceFileTag;

public class CoffiClassSource
extends ClassSource {
    protected final InputStream classFile;
    private final String fileName;
    private final String zipFileName;

    public CoffiClassSource(String className, InputStream classFile, String fileName, String zipFileName) {
        super(className);
        this.classFile = classFile;
        this.fileName = fileName;
        this.zipFileName = zipFileName;
    }

    @Override
    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            G.v().out.println("resolving [from .class]: " + this.className);
        }
        ArrayList<Type> references = new ArrayList<Type>();
        Util.v().resolveFromClassFile(sc, this.classFile, this.fileName, references);
        try {
            this.classFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException("!?");
        }
        this.addSourceFileTag(sc);
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        deps.typesToSignature.addAll(references);
        return deps;
    }

    protected void addSourceFileTag(SootClass sc) {
        if (this.fileName == null && this.zipFileName == null) {
            return;
        }
        SourceFileTag tag = null;
        if (sc.hasTag("SourceFileTag")) {
            tag = (SourceFileTag)sc.getTag("SourceFileTag");
        } else {
            tag = new SourceFileTag();
            sc.addTag(tag);
        }
        if (tag.getSourceFile() == null) {
            String name = this.zipFileName == null ? new File(this.fileName).getName() : new File(this.zipFileName).getName();
            tag.setSourceFile(name);
        }
    }
}

