/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.Collection;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.Body;
import soot.JastAddJ.Expr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Value;

public class ArrayAccess
extends Access
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ArrayAccess clone() throws CloneNotSupportedException {
        ArrayAccess node = (ArrayAccess)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ArrayAccess copy() {
        try {
            ArrayAccess node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public ArrayAccess fullCopy() {
        ArrayAccess tree = this.copy();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                ASTNode child = this.children[i];
                if (child != null) {
                    child = child.fullCopy();
                    tree.setChild(child, i);
                }
                ++i;
            }
        }
        return tree;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("[");
        this.getExpr().toString(s);
        s.append("]");
    }

    @Override
    public void typeCheck() {
        if (this.isQualified() && !this.qualifier().type().isArrayDecl() && !this.qualifier().type().isUnknown()) {
            this.error("the type " + this.qualifier().type().name() + " of the indexed element is not an array");
        }
        if (!this.getExpr().type().unaryNumericPromotion().isInt() || !this.getExpr().type().isIntegralType()) {
            this.error("array index must be int after unary numeric promotion which " + this.getExpr().type().typeName() + " is not");
        }
    }

    @Override
    public Value eval(Body b) {
        Local arrayRef = b.newTemp(this.prevExpr().eval(b));
        Local arrayIndex = b.newTemp(this.getExpr().eval(b));
        return b.newArrayRef(this.asLocal(b, arrayRef), this.asImmediate(b, arrayIndex), this);
    }

    public ArrayAccess() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public ArrayAccess(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        return this.getExpr().isDUafter(v);
    }

    @Override
    public boolean isArrayAccess() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        return NameType.EXPRESSION_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.isQualified() ? this.qualifier().type().componentType() : this.unknownType();
    }

    @Override
    public boolean isVariable() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    @Override
    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    @Override
    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupMethod(name);
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    @Override
    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().hasPackage(packageName);
        }
        return this.getParent().Define_boolean_hasPackage(this, caller, packageName);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupType(name);
        }
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

