/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import soot.JastAddJ.Access;
import soot.JastAddJ.AnnotationDecl;
import soot.JastAddJ.Attributes;
import soot.JastAddJ.BytecodeReader;
import soot.JastAddJ.BytecodeTypeAccess;
import soot.JastAddJ.CONSTANT_Class_Info;
import soot.JastAddJ.CONSTANT_Double_Info;
import soot.JastAddJ.CONSTANT_Fieldref_Info;
import soot.JastAddJ.CONSTANT_Float_Info;
import soot.JastAddJ.CONSTANT_Info;
import soot.JastAddJ.CONSTANT_Integer_Info;
import soot.JastAddJ.CONSTANT_InterfaceMethodref_Info;
import soot.JastAddJ.CONSTANT_Long_Info;
import soot.JastAddJ.CONSTANT_Methodref_Info;
import soot.JastAddJ.CONSTANT_NameAndType_Info;
import soot.JastAddJ.CONSTANT_String_Info;
import soot.JastAddJ.CONSTANT_Utf8_Info;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.EnumDecl;
import soot.JastAddJ.FieldInfo;
import soot.JastAddJ.Flags;
import soot.JastAddJ.InterfaceDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodInfo;
import soot.JastAddJ.Modifier;
import soot.JastAddJ.Modifiers;
import soot.JastAddJ.Opt;
import soot.JastAddJ.Program;
import soot.JastAddJ.TypeAccess;
import soot.JastAddJ.TypeDecl;

public class BytecodeParser
implements Flags,
BytecodeReader {
    public static final boolean VERBOSE = false;
    private DataInputStream is;
    public CONSTANT_Class_Info classInfo;
    public String outerClassName;
    public String name;
    public boolean isInnerClass = false;
    public CONSTANT_Info[] constantPool = null;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_FieldRef = 9;
    private static final int CONSTANT_MethodRef = 10;
    private static final int CONSTANT_InterfaceMethodRef = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;

    @Override
    public CompilationUnit read(InputStream is, String fullName, Program p) throws FileNotFoundException, IOException {
        return new BytecodeParser(is, fullName).parse(null, null, p);
    }

    public BytecodeParser(byte[] buffer, int size, String name) {
        this.is = new DataInputStream(new ByteArrayInputStream(buffer, 0, size));
        this.name = name;
    }

    public BytecodeParser(InputStream in, String name) {
        this.is = new DataInputStream(new DummyInputStream(in));
        this.name = name;
    }

    public BytecodeParser() {
        this("");
    }

    public BytecodeParser(String name) {
        if (!name.endsWith(".class")) {
            name = String.valueOf(name.replace('.', '/')) + ".class";
        }
        this.name = name;
    }

    public int next() {
        try {
            return this.is.read();
        }
        catch (IOException e) {
            System.exit(1);
            return -1;
        }
    }

    public int u1() {
        try {
            return this.is.readUnsignedByte();
        }
        catch (IOException e) {
            System.exit(1);
            return -1;
        }
    }

    public int u2() {
        try {
            return this.is.readUnsignedShort();
        }
        catch (IOException e) {
            System.exit(1);
            return -1;
        }
    }

    public int u4() {
        try {
            return this.is.readInt();
        }
        catch (IOException e) {
            System.exit(1);
            return -1;
        }
    }

    public int readInt() {
        try {
            return this.is.readInt();
        }
        catch (IOException e) {
            System.exit(1);
            return -1;
        }
    }

    public float readFloat() {
        try {
            return this.is.readFloat();
        }
        catch (IOException e) {
            System.exit(1);
            return -1.0f;
        }
    }

    public long readLong() {
        try {
            return this.is.readLong();
        }
        catch (IOException e) {
            System.exit(1);
            return -1L;
        }
    }

    public double readDouble() {
        try {
            return this.is.readDouble();
        }
        catch (IOException e) {
            System.exit(1);
            return -1.0;
        }
    }

    public String readUTF() {
        try {
            return this.is.readUTF();
        }
        catch (IOException e) {
            System.exit(1);
            return "";
        }
    }

    public void skip(int length) {
        try {
            this.is.skip(length);
        }
        catch (IOException e) {
            System.exit(1);
        }
    }

    public void error(String s) {
        throw new RuntimeException(s);
    }

    public void print(String s) {
    }

    public void println(String s) {
        this.print(String.valueOf(s) + "\n");
    }

    public void println() {
        this.print("\n");
    }

    public CompilationUnit parse(TypeDecl outerTypeDecl, String outerClassName, Program classPath, boolean isInner) throws FileNotFoundException, IOException {
        this.isInnerClass = isInner;
        return this.parse(outerTypeDecl, outerClassName, classPath);
    }

    public CompilationUnit parse(TypeDecl outerTypeDecl, String outerClassName, Program program) throws FileNotFoundException, IOException {
        if (this.is == null) {
            FileInputStream file = new FileInputStream(this.name);
            if (file == null) {
                throw new FileNotFoundException(this.name);
            }
            this.is = new DataInputStream(new BufferedInputStream(file));
        }
        this.outerClassName = outerClassName;
        this.parseMagic();
        this.parseMinor();
        this.parseMajor();
        this.parseConstantPool();
        CompilationUnit cu = new CompilationUnit();
        TypeDecl typeDecl = this.parseTypeDecl();
        cu.setPackageDecl(this.classInfo.packageDecl());
        cu.addTypeDecl(typeDecl);
        this.parseFields(typeDecl);
        this.parseMethods(typeDecl);
        if (new Attributes.TypeAttributes(this, typeDecl, outerTypeDecl, program).isInnerClass()) {
            program.addCompilationUnit(cu);
            int i = 0;
            while (i < cu.getTypeDecls().getNumChild()) {
                cu.getTypeDecls().removeChild(i);
                ++i;
            }
            program.getCompilationUnits().removeChild(program.getCompilationUnits().getIndexOfChild(cu));
        }
        this.is.close();
        this.is = null;
        return cu;
    }

    public void parseMagic() {
        if (this.next() != 202 || this.next() != 254 || this.next() != 186 || this.next() != 190) {
            this.error("magic error");
        }
    }

    public void parseMinor() {
        int low = this.u1();
        int high = this.u1();
    }

    public void parseMajor() {
        int low = this.u1();
        int high = this.u1();
    }

    public TypeDecl parseTypeDecl() {
        int flags = this.u2();
        Modifiers modifiers = BytecodeParser.modifiers(flags & 0xFDDF);
        if ((flags & 0x4200) == 16384) {
            EnumDecl decl = new EnumDecl();
            decl.setModifiers(modifiers);
            decl.setID(this.parseThisClass());
            Access superClass = this.parseSuperClass();
            decl.setImplementsList(this.parseInterfaces(new List()));
            return decl;
        }
        if ((flags & 0x200) == 0) {
            ClassDecl decl = new ClassDecl();
            decl.setModifiers(modifiers);
            decl.setID(this.parseThisClass());
            Access superClass = this.parseSuperClass();
            decl.setSuperClassAccessOpt(superClass == null ? new Opt<Access>() : new Opt<Access>(superClass));
            decl.setImplementsList(this.parseInterfaces(new List()));
            return decl;
        }
        if ((flags & 0x2000) == 0) {
            InterfaceDecl decl = new InterfaceDecl();
            decl.setModifiers(modifiers);
            decl.setID(this.parseThisClass());
            Access superClass = this.parseSuperClass();
            decl.setSuperInterfaceIdList(this.parseInterfaces(superClass == null ? new List() : new List<Access>().add(superClass)));
            return decl;
        }
        AnnotationDecl decl = new AnnotationDecl();
        decl.setModifiers(modifiers);
        decl.setID(this.parseThisClass());
        Access superClass = this.parseSuperClass();
        this.parseInterfaces(superClass == null ? new List() : new List<Access>().add(superClass));
        return decl;
    }

    public String parseThisClass() {
        CONSTANT_Class_Info info;
        int index = this.u2();
        this.classInfo = info = (CONSTANT_Class_Info)this.constantPool[index];
        return info.simpleName();
    }

    public Access parseSuperClass() {
        int index = this.u2();
        if (index == 0) {
            return null;
        }
        CONSTANT_Class_Info info = (CONSTANT_Class_Info)this.constantPool[index];
        return info.access();
    }

    public List parseInterfaces(List list) {
        int count = this.u2();
        int i = 0;
        while (i < count) {
            CONSTANT_Class_Info info = (CONSTANT_Class_Info)this.constantPool[this.u2()];
            list.add(info.access());
            ++i;
        }
        return list;
    }

    public Access fromClassName(String s) {
        String typeName;
        String packageName = "";
        int index = s.lastIndexOf(47);
        if (index != -1) {
            packageName = s.substring(0, index).replace('/', '.');
        }
        if ((typeName = s.substring(index + 1, s.length())).indexOf(36) != -1) {
            return new BytecodeTypeAccess(packageName, typeName);
        }
        return new TypeAccess(packageName, typeName);
    }

    public static Modifiers modifiers(int flags) {
        Modifiers m = new Modifiers();
        if ((flags & 1) != 0) {
            m.addModifier(new Modifier("public"));
        }
        if ((flags & 2) != 0) {
            m.addModifier(new Modifier("private"));
        }
        if ((flags & 4) != 0) {
            m.addModifier(new Modifier("protected"));
        }
        if ((flags & 8) != 0) {
            m.addModifier(new Modifier("static"));
        }
        if ((flags & 0x10) != 0) {
            m.addModifier(new Modifier("final"));
        }
        if ((flags & 0x20) != 0) {
            m.addModifier(new Modifier("synchronized"));
        }
        if ((flags & 0x40) != 0) {
            m.addModifier(new Modifier("volatile"));
        }
        if ((flags & 0x80) != 0) {
            m.addModifier(new Modifier("transient"));
        }
        if ((flags & 0x100) != 0) {
            m.addModifier(new Modifier("native"));
        }
        if ((flags & 0x400) != 0) {
            m.addModifier(new Modifier("abstract"));
        }
        if ((flags & 0x800) != 0) {
            m.addModifier(new Modifier("strictfp"));
        }
        return m;
    }

    public void parseFields(TypeDecl typeDecl) {
        int count = this.u2();
        int i = 0;
        while (i < count) {
            FieldInfo fieldInfo = new FieldInfo(this);
            if (!fieldInfo.isSynthetic()) {
                typeDecl.addBodyDecl(fieldInfo.bodyDecl());
            }
            ++i;
        }
    }

    public void parseMethods(TypeDecl typeDecl) {
        int count = this.u2();
        int i = 0;
        while (i < count) {
            MethodInfo info = new MethodInfo(this);
            if (!info.isSynthetic() && !info.name.equals("<clinit>")) {
                typeDecl.addBodyDecl(info.bodyDecl());
            }
            ++i;
        }
    }

    private void checkLengthAndNull(int index) {
        if (index >= this.constantPool.length) {
            throw new Error("Trying to access element " + index + " in constant pool of length " + this.constantPool.length);
        }
        if (this.constantPool[index] == null) {
            throw new Error("Unexpected null element in constant pool at index " + index);
        }
    }

    public boolean validConstantPoolIndex(int index) {
        return index < this.constantPool.length && this.constantPool[index] != null;
    }

    public CONSTANT_Info getCONSTANT_Info(int index) {
        this.checkLengthAndNull(index);
        return this.constantPool[index];
    }

    public CONSTANT_Utf8_Info getCONSTANT_Utf8_Info(int index) {
        this.checkLengthAndNull(index);
        CONSTANT_Info info = this.constantPool[index];
        if (!(info instanceof CONSTANT_Utf8_Info)) {
            throw new Error("Expected CONSTANT_Utf8_info at " + index + " in constant pool but found " + info.getClass().getName());
        }
        return (CONSTANT_Utf8_Info)info;
    }

    public CONSTANT_Class_Info getCONSTANT_Class_Info(int index) {
        this.checkLengthAndNull(index);
        CONSTANT_Info info = this.constantPool[index];
        if (!(info instanceof CONSTANT_Class_Info)) {
            throw new Error("Expected CONSTANT_Class_info at " + index + " in constant pool but found " + info.getClass().getName());
        }
        return (CONSTANT_Class_Info)info;
    }

    public void parseConstantPool() {
        int count = this.u2();
        this.constantPool = new CONSTANT_Info[count + 1];
        int i = 1;
        while (i < count) {
            this.parseEntry(i);
            if (this.constantPool[i] instanceof CONSTANT_Long_Info || this.constantPool[i] instanceof CONSTANT_Double_Info) {
                ++i;
            }
            ++i;
        }
    }

    public void parseEntry(int i) {
        int tag = this.u1();
        switch (tag) {
            case 7: {
                this.constantPool[i] = new CONSTANT_Class_Info(this);
                break;
            }
            case 9: {
                this.constantPool[i] = new CONSTANT_Fieldref_Info(this);
                break;
            }
            case 10: {
                this.constantPool[i] = new CONSTANT_Methodref_Info(this);
                break;
            }
            case 11: {
                this.constantPool[i] = new CONSTANT_InterfaceMethodref_Info(this);
                break;
            }
            case 8: {
                this.constantPool[i] = new CONSTANT_String_Info(this);
                break;
            }
            case 3: {
                this.constantPool[i] = new CONSTANT_Integer_Info(this);
                break;
            }
            case 4: {
                this.constantPool[i] = new CONSTANT_Float_Info(this);
                break;
            }
            case 5: {
                this.constantPool[i] = new CONSTANT_Long_Info(this);
                break;
            }
            case 6: {
                this.constantPool[i] = new CONSTANT_Double_Info(this);
                break;
            }
            case 12: {
                this.constantPool[i] = new CONSTANT_NameAndType_Info(this);
                break;
            }
            case 1: {
                this.constantPool[i] = new CONSTANT_Utf8_Info(this);
                break;
            }
            default: {
                this.println("Unknown entry: " + tag);
            }
        }
    }

    private static class DummyInputStream
    extends InputStream {
        byte[] bytes;
        int pos;
        int size;

        public DummyInputStream(byte[] buffer, int size) {
            this.bytes = buffer;
            this.size = size;
        }

        public DummyInputStream(InputStream is) {
            this.bytes = new byte[1024];
            int index = 0;
            this.size = 1024;
            try {
                int status;
                do {
                    if ((status = is.read(this.bytes, index, this.size - index)) == -1 || (index += status) != this.size) continue;
                    byte[] newBytes = new byte[this.size * 2];
                    System.arraycopy(this.bytes, 0, newBytes, 0, this.size);
                    this.bytes = newBytes;
                    this.size *= 2;
                } while (status != -1);
            }
            catch (IOException e) {
                System.err.println("Something went wrong trying to read " + is);
            }
            this.size = index;
            this.pos = 0;
        }

        @Override
        public int available() {
            return this.size - this.pos;
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(byte[] b) {
            int actualLength = Math.min(b.length, this.size - this.pos);
            System.arraycopy(this.bytes, this.pos, b, 0, actualLength);
            this.pos += actualLength;
            return actualLength;
        }

        @Override
        public int read(byte[] b, int offset, int length) {
            int actualLength = Math.min(length, this.size - this.pos);
            System.arraycopy(this.bytes, this.pos, b, offset, actualLength);
            this.pos += actualLength;
            return actualLength;
        }

        @Override
        public void reset() {
        }

        @Override
        public long skip(long n) {
            if (this.size == this.pos) {
                return -1L;
            }
            long skipSize = Math.min(n, (long)(this.size - this.pos));
            this.pos = (int)((long)this.pos + skipSize);
            return skipSize;
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.size) {
                int i;
                if ((i = this.bytes[this.pos++]) < 0) {
                    i += 256;
                }
                return i;
            }
            return -1;
        }
    }
}

