/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import soot.Immediate;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.ArrayCreationExpr;
import soot.JastAddJ.ArrayInit;
import soot.JastAddJ.ArrayTypeAccess;
import soot.JastAddJ.Body;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.Expr;
import soot.JastAddJ.List;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Opt;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.VarAccess;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.jimple.NullConstant;

public class ConstructorAccess
extends Access
implements Cloneable {
    protected boolean addEnclosingVariables = true;
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected boolean decls_computed = false;
    protected SimpleSet decls_value;
    protected boolean decl_computed = false;
    protected ConstructorDecl decl_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.decls_computed = false;
        this.decls_value = null;
        this.decl_computed = false;
        this.decl_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ConstructorAccess clone() throws CloneNotSupportedException {
        ConstructorAccess node = (ConstructorAccess)super.clone();
        node.decls_computed = false;
        node.decls_value = null;
        node.decl_computed = false;
        node.decl_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ConstructorAccess copy() {
        try {
            ConstructorAccess node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public ConstructorAccess fullCopy() {
        ConstructorAccess tree = this.copy();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                ASTNode child = this.children[i];
                if (child != null) {
                    child = child.fullCopy();
                    tree.setChild(child, i);
                }
                ++i;
            }
        }
        return tree;
    }

    @Override
    public void exceptionHandling() {
        int i = 0;
        while (i < this.decl().getNumException()) {
            TypeDecl exceptionType = this.decl().getException(i).type();
            if (!this.handlesException(exceptionType)) {
                this.error(this + " may throw uncaught exception " + exceptionType.fullName());
            }
            ++i;
        }
    }

    @Override
    protected boolean reachedException(TypeDecl catchType) {
        int i = 0;
        while (i < this.decl().getNumException()) {
            TypeDecl exceptionType = this.decl().getException(i).type();
            if (catchType.mayCatch(exceptionType)) {
                return true;
            }
            ++i;
        }
        return super.reachedException(catchType);
    }

    @Override
    public void nameCheck() {
        super.nameCheck();
        if (this.decls().isEmpty()) {
            this.error("no constructor named " + this);
        }
        if (this.decls().size() > 1 && this.validArgs()) {
            this.error("several most specific constructors for " + this);
            Iterator iter = this.decls().iterator();
            while (iter.hasNext()) {
                this.error("         " + ((ConstructorDecl)iter.next()).signature());
            }
        }
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.name());
        s.append("(");
        if (this.getNumArg() > 0) {
            this.getArg(0).toString(s);
            int i = 1;
            while (i < this.getNumArg()) {
                s.append(", ");
                this.getArg(i).toString(s);
                ++i;
            }
        }
        s.append(")");
    }

    @Override
    public void checkModifiers() {
        if (this.decl().isDeprecated() && !this.withinDeprecatedAnnotation() && this.hostType().topLevelType() != this.decl().hostType().topLevelType() && !this.withinSuppressWarnings("deprecation")) {
            this.warning(String.valueOf(this.decl().signature()) + " in " + this.decl().hostType().typeName() + " has been deprecated");
        }
    }

    @Override
    protected void transformEnumConstructors() {
        super.transformEnumConstructors();
        this.getArgList().insertChild(new VarAccess("@p0"), 0);
        this.getArgList().insertChild(new VarAccess("@p1"), 1);
    }

    public void addEnclosingVariables() {
        if (!this.addEnclosingVariables) {
            return;
        }
        this.addEnclosingVariables = false;
        this.decl().addEnclosingVariables();
        for (Variable v : this.decl().hostType().enclosingVariables()) {
            this.getArgList().add(new VarAccess("val$" + v.name()));
        }
    }

    public void refined_Transformations_ConstructorAccess_transformation() {
        this.addEnclosingVariables();
        if (this.decl().isPrivate() && this.decl().hostType() != this.hostType()) {
            this.decl().createAccessor();
        }
        super.transformation();
    }

    @Override
    public void collectTypesToSignatures(Collection<Type> set) {
        super.collectTypesToSignatures(set);
        this.addDependencyIfNeeded(set, this.decl().erasedConstructor().hostType());
    }

    public ConstructorAccess() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
        this.setChild(new List(), 0);
    }

    public ConstructorAccess(String p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    public ConstructorAccess(Symbol p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setArgList(List<Expr> list) {
        this.setChild(list, 0);
    }

    public int getNumArg() {
        return this.getArgList().getNumChild();
    }

    public int getNumArgNoTransform() {
        return this.getArgListNoTransform().getNumChildNoTransform();
    }

    public Expr getArg(int i) {
        return (Expr)this.getArgList().getChild(i);
    }

    public void addArg(Expr node) {
        List<Expr> list = this.parent == null || state == null ? this.getArgListNoTransform() : this.getArgList();
        list.addChild(node);
    }

    public void addArgNoTransform(Expr node) {
        List<Expr> list = this.getArgListNoTransform();
        list.addChild(node);
    }

    public void setArg(Expr node, int i) {
        List<Expr> list = this.getArgList();
        list.setChild(node, i);
    }

    public List<Expr> getArgs() {
        return this.getArgList();
    }

    public List<Expr> getArgsNoTransform() {
        return this.getArgListNoTransform();
    }

    public List<Expr> getArgList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    public List<Expr> getArgListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    @Override
    public void transformation() {
        if (this.decl().isVariableArity() && !this.invokesVariableArityAsArray()) {
            List<Expr> list = new List<Expr>();
            int i = 0;
            while (i < this.decl().getNumParameter() - 1) {
                list.add((Expr)this.getArg(i).fullCopy());
                ++i;
            }
            List<Expr> last = new List<Expr>();
            int i2 = this.decl().getNumParameter() - 1;
            while (i2 < this.getNumArg()) {
                last.add((Expr)this.getArg(i2).fullCopy());
                ++i2;
            }
            Access typeAccess = this.decl().lastParameter().type().elementType().createQualifiedAccess();
            int i3 = 0;
            while (i3 < this.decl().lastParameter().type().dimension()) {
                typeAccess = new ArrayTypeAccess(typeAccess);
                ++i3;
            }
            list.add(new ArrayCreationExpr(typeAccess, new Opt<ArrayInit>(new ArrayInit(last))));
            this.setArgList(list);
        }
        this.refined_Transformations_ConstructorAccess_transformation();
    }

    @Override
    public Value eval(Body b) {
        b.setLine(this);
        ConstructorDecl c = this.decl().erasedConstructor();
        Local base = b.emitThis(this.hostType());
        int index = 0;
        ArrayList<Immediate> list = new ArrayList<Immediate>();
        if (c.needsEnclosing()) {
            list.add(this.asImmediate(b, b.newParameterRef(this.hostType().enclosingType().getSootType(), index++, this)));
        }
        if (c.needsSuperEnclosing()) {
            ClassDecl superClass = ((ClassDecl)this.hostType()).superclass();
            list.add(this.asImmediate(b, b.newParameterRef(superClass.enclosingType().getSootType(), index++, this)));
        }
        int i = 0;
        while (i < this.getNumArg()) {
            list.add(this.asImmediate(b, this.getArg(i).type().emitCastTo(b, this.getArg(i), c.getParameter(i).type())));
            ++i;
        }
        if (this.decl().isPrivate() && this.decl().hostType() != this.hostType()) {
            list.add(this.asImmediate(b, NullConstant.v()));
            b.add(b.newInvokeStmt(b.newSpecialInvokeExpr(base, this.decl().erasedConstructor().createAccessor().sootRef(), list, (ASTNode)this), this));
            return base;
        }
        return b.newSpecialInvokeExpr(base, c.sootRef(), list, (ASTNode)this);
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        return this.decl().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        return this.decl().isDUafter(v);
    }

    @Override
    public boolean applicableAndAccessible(ConstructorDecl decl) {
        ASTNode$State state = this.state();
        return decl.applicable(this.getArgList()) && decl.accessibleFrom(this.hostType());
    }

    public SimpleSet decls() {
        if (this.decls_computed) {
            return this.decls_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decls_value = this.decls_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decls_computed = true;
        }
        return this.decls_value;
    }

    private SimpleSet decls_compute() {
        return this.chooseConstructor(this.lookupConstructor(), this.getArgList());
    }

    public ConstructorDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decl_computed = true;
        }
        return this.decl_value;
    }

    private ConstructorDecl decl_compute() {
        SimpleSet decls = this.decls();
        if (decls.size() == 1) {
            return (ConstructorDecl)decls.iterator().next();
        }
        return this.unknownConstructor();
    }

    public boolean validArgs() {
        ASTNode$State state = this.state();
        int i = 0;
        while (i < this.getNumArg()) {
            if (this.getArg(i).type().isUnknown()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String name() {
        ASTNode$State state = this.state();
        return "this";
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        return NameType.AMBIGUOUS_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.decl().type();
    }

    public int arity() {
        ASTNode$State state = this.state();
        return this.getNumArg();
    }

    public boolean invokesVariableArityAsArray() {
        ASTNode$State state = this.state();
        if (!this.decl().isVariableArity()) {
            return false;
        }
        if (this.arity() != this.decl().arity()) {
            return false;
        }
        return this.getArg(this.getNumArg() - 1).type().methodInvocationConversionTo(this.decl().lastParameter().type());
    }

    public boolean handlesException(TypeDecl exceptionType) {
        ASTNode$State state = this.state();
        boolean handlesException_TypeDecl_value = this.getParent().Define_boolean_handlesException(this, null, exceptionType);
        return handlesException_TypeDecl_value;
    }

    public Collection lookupConstructor() {
        ASTNode$State state = this.state();
        Collection lookupConstructor_value = this.getParent().Define_Collection_lookupConstructor(this, null);
        return lookupConstructor_value;
    }

    public ConstructorDecl unknownConstructor() {
        ASTNode$State state = this.state();
        ConstructorDecl unknownConstructor_value = this.getParent().Define_ConstructorDecl_unknownConstructor(this, null);
        return unknownConstructor_value;
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupMethod(name);
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    @Override
    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().hasPackage(packageName);
        }
        return this.getParent().Define_boolean_hasPackage(this, caller, packageName);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupType(name);
        }
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public String Define_String_methodHost(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unqualifiedScope().methodHost();
    }

    @Override
    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return true;
        }
        return this.getParent().Define_boolean_inExplicitConstructorInvocation(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

