/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.MultiplicativeExpr;
import soot.Value;

public class DivExpr
extends MultiplicativeExpr
implements Cloneable {
    protected int isConstant_visited = -1;
    protected boolean isConstant_computed = false;
    protected boolean isConstant_initialized = false;
    protected boolean isConstant_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isConstant_visited = -1;
        this.isConstant_computed = false;
        this.isConstant_initialized = false;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public DivExpr clone() throws CloneNotSupportedException {
        DivExpr node = (DivExpr)super.clone();
        node.isConstant_visited = -1;
        node.isConstant_computed = false;
        node.isConstant_initialized = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public DivExpr copy() {
        try {
            DivExpr node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public DivExpr fullCopy() {
        DivExpr tree = this.copy();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                ASTNode child = this.children[i];
                if (child != null) {
                    child = child.fullCopy();
                    tree.setChild(child, i);
                }
                ++i;
            }
        }
        return tree;
    }

    @Override
    public Value emitOperation(Body b, Value left, Value right) {
        return this.asLocal(b, b.newDivExpr(this.asImmediate(b, left), this.asImmediate(b, right), this));
    }

    public DivExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
    }

    public DivExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        return this.type().div(this.getLeftOperand().constant(), this.getRightOperand().constant());
    }

    @Override
    public boolean isConstant() {
        if (this.isConstant_computed) {
            return this.isConstant_value;
        }
        ASTNode$State state = this.state();
        if (!this.isConstant_initialized) {
            this.isConstant_initialized = true;
            this.isConstant_value = false;
        }
        if (!state.IN_CIRCLE) {
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                this.isConstant_visited = state.CIRCLE_INDEX;
                state.CHANGE = false;
                boolean new_isConstant_value = this.isConstant_compute();
                if (new_isConstant_value != this.isConstant_value) {
                    state.CHANGE = true;
                }
                this.isConstant_value = new_isConstant_value;
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.isConstant_computed = true;
            } else {
                state.RESET_CYCLE = true;
                this.isConstant_compute();
                state.RESET_CYCLE = false;
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
            }
            state.IN_CIRCLE = false;
            return this.isConstant_value;
        }
        if (this.isConstant_visited != state.CIRCLE_INDEX) {
            this.isConstant_visited = state.CIRCLE_INDEX;
            if (state.RESET_CYCLE) {
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
                this.isConstant_visited = -1;
                return this.isConstant_value;
            }
            boolean new_isConstant_value = this.isConstant_compute();
            if (new_isConstant_value != this.isConstant_value) {
                state.CHANGE = true;
            }
            this.isConstant_value = new_isConstant_value;
            return this.isConstant_value;
        }
        return this.isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getLeftOperand().isConstant() && this.getRightOperand().isConstant() && (!this.getRightOperand().type().isInt() || this.getRightOperand().constant().intValue() != 0);
    }

    @Override
    public String printOp() {
        ASTNode$State state = this.state();
        return " / ";
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

