/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Expr;
import soot.JastAddJ.RelationalExpr;
import soot.JastAddJ.TypeDecl;

public abstract class EqualityExpr
extends RelationalExpr
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public EqualityExpr clone() throws CloneNotSupportedException {
        EqualityExpr node = (EqualityExpr)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public void typeCheck() {
        TypeDecl left = this.getLeftOperand().type();
        TypeDecl right = this.getRightOperand().type();
        if (left.isNumericType() && right.isNumericType()) {
            return;
        }
        if (left.isBoolean() && right.isBoolean()) {
            return;
        }
        if ((left.isReferenceType() || left.isNull()) && (right.isReferenceType() || right.isNull()) && (left.castingConversionTo(right) || right.castingConversionTo(left))) {
            return;
        }
        this.error(String.valueOf(left.typeName()) + " can not be compared to " + right.typeName());
    }

    public EqualityExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
    }

    public EqualityExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

